;; AUX 1 . CC41A 

;; DrScheme -> Language -> Chosee language -> Standard (R5R6)
;; Scheme básico, se usará las dos primera clases.
;; Para el resto del curso, ver web profesor : http://www.dcc.uchile.cl/~etanter/courses/cc41a/

;; Las líneas iniciadas con ';' son comentarios
;; Puede descomentar las líneas que indican pruebas y ejecutar sus propios experimentos.
;; Para ello puede utilizar la línea de comandos de DrScheme '>'.
;; Asegúrese que entiende la definición de funciones, tras diversas pruebas que ejecute.



; -power : number integer -> real
; retorna x^n
(define (-power x n)
  (cond
    ((= n 0) 1)
    (else (* x (power x (- n 1))))
    )
  )

;; (-power 2 3)
;; (-power 10 6)
          
; -fact : integer -> integer
; retorna n!
(define (fact n)
  (cond
    ((= n 0) 1)
    (else (* (fact (- n 1)) n))
    )
  )

;; (-fact 5) 
;; (-fact 12)

; -fib : integer -> integer
; retorna el n-ésimo elemento de la sucesión de Fibonacci
; F[0] = 0
; F[1] = 1
; F[n] = F[n-1]+F[n-2]
(define (-fib n)
  (cond
    ((= n 0) 0)
    ((= n 1) 1)
    (else (+ (-fib (- n 1)) (-fib (- n 2))))
    )
  )

;; BOOLEANOS

;; #t -> true
;; #f -> false
;;
;; Funciones lógicas para boleanos : not, and, or

;; LISTAS

;; car : list -> atom          '' Primer elemento de una lista
;; cdr : list -> list          '' Resto de la lista
;; cons : atom list -> list    '' Retorna una nueva lista añadiendo una elemento al principio
;; append : list list -> list  '' Retorna una nueva lista resultante de 'pegar' dos listas
;; (list 1 2 3)                '' Crea una nueva lista
;; '(1 2 3)                    '' Igual que el anterior, notar el ' delante del primer paréntesis.
;; '()                         '' Lista vacía
;; (list? l)                   '' Es l una lista?
;; (null? l)                   '' En l una lista vacía?


;; (car '(1 2 3))   -> 1
;; (cdr '(1 2 3))   -> (2 3)
;; (car '())        -> ERROR!
;; (cdr '())        -> ERROR!
;; (car '(1 2))     -> 1
;; (cdr '(1 2))     -> (2)  ... Prop: (number? (cdr '(1 2))) ?  #t | #f ?
;; (car '( (1 2) 3) -> (1 2)
;; (car (cdr '(1 2 3)) -> 2
;; (car (cons 1 '(2 3)) -> 1
;; (append '(1 2) '(3 4)) -> (1 2 3 4)
;; (append 1 '(2 3)) -> ERROR! Ambos argumentos deben ser listas!!!


; -nlist : number number -> list
; retorna la lista que incluye todos los enteros entre dos números
(define (-nlist n1 n2)
  (cond
    ((> n1 n2) '())
    (else (cons n1 (-nlist (+ n1 1) n2)))
    )
  )

;; (-nlist 1 5)

;; Primeros 10 elementos de fibonacci
;; (map fibo (nlist 1 10))

;; my-member : atom list -> boolean
;; pregunta si un elemento pertenece o no a una lista.
(define (my-member atom list)
  (cond
    ((null? list) #f)
    ((eq? (car list) atom) #t)
    (else (my-member atom (cdr list)))
    ))


(my-member 1 '(1 2 3))
(my-member 5 '(1 2 3))
(my-member 5 '(1 2 3 (5)))

;; eq? : Permite determinar si dos objetos en Scheme son el mismo.

; propuesto: escriba my-member-recursivo que solucione (my-member 5 '(1 2 3 (5)))
(define (my-member-list atom list)
  (cond
    ((null? list) #f)
    ((list? (car list))
     (or 
      (my-member-list atom (car list)) ;; Permite 'entrar' en las sublistas
      (my-member-list atom (cdr list))
      )
     )
    ((eq? (car list) atom) #t)
    (else (my-member-list atom (cdr list)))
    )
  )

(my-member-list 5 '(1 2 3 (5)))
(my-member-list 5 '(1 (5 6) 2 ))
(my-member-list 5 '(1 2 (3 4)))