;; CC41A - CC54A : Lenguajes de Programación
;; Aux 2 - Lunes 06 Agosto 2007
;; Richard Ibarra - richard.ibarra@gmail.com


;; d/dx : (number -> number) -> (number -> number)
;; retorna df/dx (x) 
(define (d/dx f)
  (define dx 0.0001)
  (lambda (x)
    (/ (- (f (+ x dx)) (f x)) dx)
    )
  )


;; diff-square : number -> number
;; d/dx (x²) = 2x
(define diff-square (d/dx 
                     (lambda (x) (* x x)) ;; x²
                     )
  )
(diff-square 2)                                        ;; Cercano a 4. Entre más pequeño dx, más cercano a 4.

;; diff-dsin : number -> number
;; d/dx sin(2x) = 2cos(2x)
(define diff-dsin (d/dx (lambda (x) (sin (* 2 x)))))


;; f-compose : (X->Y) (Y->Z) -> (X->Z)
;; (f-compose f g) -> fog
(define (f-compose f g)
  (lambda (x) (f (g x))
    )
  )

;; f-n : (X -> X) number -> (X -> X)
;; (f-n f n) -> f^n
(define (f-n f n)
  (cond
    ((= n 0) (lambda (x) x))
    ((= n 1) f)
    (else (f-compose f (f-n f (- n 1))))
    )
  )

;; second : list -> atom
(define second (f-compose car cdr))

;; third : list -> atom
(define third (f-compose car (f-compose cdr cdr)))

;; forth : list -> atom
(define fourth (f-compose car (f-compose cdr (f-compose cdr cdr))))

;; (second '(1 2 3 4)) -> 2
;; (third '(1 2 3 4))  -> 3
;; (fourth '(1 2 3 4)) -> 4

;; -listref : list number -> atom
;; similar a l[i] ...
;; a contar de l[0]
;; cdr : listOf(X) -> listOf(X)
;; car : listOf(X) -> X
(define (-listref l n)
  ((f-compose car (f-n cdr n)) l)
  )
  

(define -l '(1 2 3))
(-listref -l 0)
(-listref -l 1)
(-listref -l 2)

;; filter-<-pivot : number list(number) -> list(number)
(define (filter-<-pivot pivot l)
  (cond
    ((null? l) '())
    ((list? l)
     (if (< (car l) pivot)
         (cons (car l) (filter-<-pivot pivot (cdr l)))  ;; agrego el elemento (pasó el TEST)
         (filter-<-pivot pivot (cdr l))                 ;; no agrego el elemento...
         )
     )
    )
  )
;; Problema : Necesitamos otra función que filtre los mayores que el pivote

;; filter-pivot : (X-> boolean) listOf(X) -> listOf(X)
(define (filter-pivot pivot comp l)
  (cond
    ((null? l) '())
    ((list? l)
     (if (comp (first l) pivot)
         (cons (car l) (filter-pivot pivot comp (cdr l)))
         (filter-pivot pivot comp (cdr l))
         )
     )
    )
  )
;; Ventaja : Podemos pasar funciones como <, string<=?, etc...
;; Problema : No refleja la "esencia" filtrar
                       

;; filter-any : (X -> boolean) listOf(X) -> listOf(X)
(define (filter-any comp l)
  (cond
    ((null? l) '())
    ((list? l)
     (if (comp (car l))
         (cons (car l) (filter-any comp (cdr l)))
         (filter-any comp (cdr l))
         )
     )
    )
  )

;; qsort : (X->boolean) listOf(X) -> listOf(X)
(define (qsort comp l)
  (cond
    ((null? l) '())
    ((list? l)
     (append
      (qsort comp (filter-any (lambda (x) (comp x (car l))) (cdr l)))
      (list (car l))                                                         ;; append NECESITA listas
      (qsort comp (filter-any (lambda (x) (not (comp x (car l)))) (cdr l)))
      )
     )
    )
  )
;; Nota: Como comentó alguien en clases la lista se recorre dos veces para filtrar (<p y >p).
;; Si bien esto genera un problema, notar que el orden del algoritmo sigue siendo el mismo [ O(n*log n) ]

(qsort < '(10 9 8 7 6 5 4 3 2 1))
(qsort string<=? '("Hola" "mundo" "chao"))
    
