#include  <sys/types.h>
#include  <pthread.h>
#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include "filosofos.h"

#define FILOSOFOS_NUM 5

typedef enum {pensando, hambriento, comiendo} filosofo_status;

typedef struct  {
  pthread_t t[FILOSOFOS_NUM];
  int self[FILOSOFOS_NUM];
  pthread_mutex_t mutex;
  pthread_cond_t condition[FILOSOFOS_NUM];
  filosofo_status status[FILOSOFOS_NUM];
} mesa;

mesa * mesa_filosofos;

void filosofos_print(void){
  static char* stat[] = {"Pensando ","Hambirento","Comiendo"};
  int i;
  for (i=0; i<FILOSOFOS_NUM; i++) {
    printf("%s\t", stat[(int)(mesa_filosofos->status)[i]]);}
  printf("\n");
}

int filosofos_tomar2 (int i) {
  if (
      ((mesa_filosofos->status)[i] == hambriento) &&
      ((mesa_filosofos->status)[(i+1)% FILOSOFOS_NUM] != comiendo) &&
      ((mesa_filosofos->status)[(i-1+FILOSOFOS_NUM)% FILOSOFOS_NUM] != comiendo)) {
    (mesa_filosofos->status)[i] = comiendo;
    pthread_cond_signal(&((mesa_filosofos->condition)[i]));
    return 1;
  }
  return 0;
}

void filosofos_tomar(int k) {
  pthread_mutex_lock(&(mesa_filosofos->mutex));
  (mesa_filosofos->status)[k] = hambriento;
  filosofos_print();
  if (!filosofos_tomar2(k)) {
    pthread_cond_wait(&((mesa_filosofos->condition)[k]), &(mesa_filosofos->mutex));}
  filosofos_print();
  pthread_mutex_unlock(&(mesa_filosofos->mutex));
}

void filosofos_dejar(int k) {
  pthread_mutex_lock(&(mesa_filosofos->mutex));
  (mesa_filosofos->status)[k] = pensando;
  filosofos_print();
  filosofos_tomar2((k+1)%FILOSOFOS_NUM);
  filosofos_tomar2((k-1+FILOSOFOS_NUM)%FILOSOFOS_NUM);
  pthread_mutex_unlock(&(mesa_filosofos->mutex));
}

void * filosofos_init(void *(* filosofo)(void *)) {
  int i, rc;
  
  mesa_filosofos = (mesa *) malloc (sizeof(mesa));
  if((rc = pthread_mutex_init(&(mesa_filosofos->mutex), NULL)) != 0) {
    fprintf(stderr, "pthread_mutex_init %s\n", strerror(rc));
    exit(1);}
  for (i=0; i<FILOSOFOS_NUM; i++) {
    (mesa_filosofos->self)[i] = i;
    (mesa_filosofos->status)[i] = pensando;
    if((rc = pthread_cond_init(&((mesa_filosofos->condition)[i]), NULL)) 
       != 0) {
      fprintf(stderr, "pthread_cond_init %s\n", strerror(rc));
      exit(1);}
  }
  for (i=0; i<FILOSOFOS_NUM; i++) {
    if ((rc = pthread_create(&((mesa_filosofos->t)[i]),NULL,
			     filosofo, &((mesa_filosofos->self)[i])))!= 0) {
      fprintf(stderr, "pthread_create %s\n", strerror(rc));
      exit(1);}
  }
  return mesa_filosofos;
}
