#include <stdio.h>
#include <stdlib.h>
#include "tree.h"
#include "element.h"
/*
 * inserta un elemento en un arbol
 * se pide memoria si es necesario
 * Para liberar/borrar un arbol no basta con hacerle free
 * Sino que hay que borrar todos los elementos de este
 * */
Node *insertTree(Element e,Node *t){
	int c;
	if(t==NULL){
		t=(Node *)malloc(sizeof(Node));
		t->element=e;
		t->left=NULL;
		t->right=NULL;	
	}else{
		c=compare(t->element,e);
		if(c>0)t->left=insertTree(e,t->left);
		else if(c<0)t->right=insertTree(e,t->right);
	}
	return t;
}
/*
 * se borra del arbol el elemento e
 * se retorna un puntero al nuevo arbol
 */
Node *removeTree(Element e,Node *t){
	int c;
	Node *temp;
	if(t!=NULL){
		c=compare(t->element,e);
		if(c>0)t->left=removeTree(e,t->left);/*esta en el arbol izquierdo*/
		else if(c<0)t->right=removeTree(e,t->right);/*esta en arbol derecho*/
		else{
			if(t->left!=NULL&&t->right!=NULL){
                                /*los dos nodos son no nulos*/
				temp=minTree(t->right);
				t->element=temp->element;
				t->right=removeTree(t->element,t->right);
			}else{
                                /*al menos un nodo nulo*/
				temp=t;
				if(t->left==NULL)t=t->right;
				else if(t->right==NULL)t=t->left;
                                /*ya no se puede acceder a temp, se libera su
                                 * contenido*/
                                free(temp);
			}
		}
	}
	return t;
}
/*
 *PROPUESTO: escribir una funcion que permita liberar de una sola vez el arbol
 */
void freeTree(Node *t) {
  if(t!=NULL){
    if((t->left)!=NULL)freeTree(t->left);
    if((t->right)!=NULL)freeTree(t->right);
    free(t);
  }
}
/*
 * se retorna el minimo nodo de un arbol
 */
Node *minTree(Node *t){
	if(t!=NULL){
		while(t->left!=NULL)
			t=t->left;
	}
	return t;
}
/*
 * se busca la llave k en el arbol
 * se retorna el nodo que contiene esa llave 
 */
Node *searchTree(Key k,Node *t){
        /*podemos modificar t, sin cambiar la estructura del arbol
         * ya que el paso de parametro es por valor, es decir se pasa una copia
         * de t*/
	int c;
	if(t!=NULL){
		c=compareToKey(t->element,k);
		if(c>0)t=searchTree(k,t->left);/*la llave es menor, esta a la izquierda*/ 
		else if(c<0)t=searchTree(k,t->right);/*es mayor esta a la derecha*/
	}
	return t;
}
/*
 * recorrido en preorden del arbol
 */
void preorden(Node *t){
	if(t!=NULL){
		preorden(t->left);
		printElement(t->element);
		preorden(t->right);
	}
}
