#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "hash.h"

/* calcula la funcion de hash para un string(char*) 
	codigo tomado de http://www.cse.yorku.ca/~oz/hash.html
*/
int hash_function(Key k,int size)   {
	char* str=k;
	int hash = 5381;
	int c;
	while ((c = *str++)!='\0')
		hash = (((hash << 5) + hash) + c)%size; /* hash * 33 + c */
	return hash;
}
int hash_key_equal(Key k1,Key k2){
	return strcmp(k1,k2)==0;
}

Hash* hash_init(int size){
	int i;
	Hash* h=(Hash*)malloc(sizeof(Hash));
	h->size=size;
	h->table=(Node**)malloc(sizeof(Node*)*size);
	h->elements=(int*)malloc(sizeof(int)*size);
	h->max_elements=(int*)malloc(sizeof(int)*size);
	for(i=0;i<size;i++){
		*(h->table+i)=(Node*)malloc(sizeof(Node)*BASE_SIZE);
		h->elements[i]=0;
		h->max_elements[i]=BASE_SIZE;
	}
	return h;
}

int hash_add(Hash* h,Key k,Val v){
	Node* temp;
	int i;
	int hf=hash_function(k,h->size);
	if(h->elements[hf]<h->max_elements[hf]){
		/*hay espacio para agregar el elemento*/
		h->table[hf][h->elements[hf]].key=k;
		h->table[hf][h->elements[hf]].val=v;
		h->elements[hf]++;
	}else{
		/*no hay espacio para agregar el elemento*/
		/*pedimos un arreglo del doble de tamaño y copiamos el anterior*/
		temp=(Node*)malloc(sizeof(Node)*(h->max_elements[hf])*2);
		for(i=0;i<h->elements[hf];i++)
			*(temp+i)=h->table[hf][i];
		(*(temp+h->elements[hf])).key=k;
		(temp+h->elements[hf])->val=v;
		h->elements[hf]++;
		h->max_elements[hf]*=2;
		free(h->table[hf]);
		h->table[hf]=temp;
	}
	return 1;
}

Val hash_get(Hash* h,Key k){
	int hf=hash_function(k,h->size);
	int i;
	for(i=0;i<h->elements[hf];i++)
			if(hash_key_equal(h->table[hf][i].key,k))return h->table[hf][i].val;
	return NULL_VAL;
}

int hash_delete(Hash* h,Key k){
	int hf=hash_function(k,h->size);
	int i;
	for(i=0;i<h->elements[hf];i++)
			if(hash_key_equal(h->table[hf][i].key,k)){
				h->table[hf][i].val=h->table[hf][h->elements[hf]-1].val;
				h->table[hf][i].key=h->table[hf][h->elements[hf]-1].key;
				h->elements[hf]--;
				return 1;
			}
	return 0;
}

int hash_free(Hash* h){
	int i;
	for(i=0;i<h->size;i++)
		free(h->table[i]);
	free(h->table);
	free(h->elements);
	free(h->max_elements);
	free(h);
	return 1;
}
