/*
 * Treap.java
 *
 * Created on 24 de septiembre de 2007, 20:28
 *
 */

/**
 *
 * @author ccabrera
 */
public class Treap {
    
    TreapNode root;
    
    public Treap(){
        root=null;
    }
    
    public int altura(){
        return altura(root);
    }
    
    public boolean contains( Integer x ){
        
        TreapNode n=root;
        
        while( n!= null){
            
            if(n.key.compareTo( x ) == 0)
                return true;
            else if( n.key.compareTo( x ) > 0 )
                n=n.left;
            else if( n.key.compareTo( x ) < 0 )
                n=n.right;
            
        }
        
        return false;
    }
    
    public void insert(Integer llave, Double prioridad){
        
        root= insert(llave, prioridad, root);
        
    }
    
    private TreapNode insert(Integer llave, Double prioridad, TreapNode node){
        
        TreapNode e=new TreapNode(llave, prioridad, null, null);
        
        if(node == null)
            node=e;

        
        else if( llave.compareTo(node.key)<0){/*en javas modernos se puede aprovechar el autoUnboxing y escribir llave < node.key*/
            
                   node.left=insert(llave, prioridad, node.left);
                   
                   if( node.left.priority.compareTo( node.priority ) < 0 )
                       node=rotateRight( node );
                   
                   
        }
        
        else if( llave.compareTo(node.key)>0){
            
                   node.right=insert(llave, prioridad, node.right);
                   
                   if( node.right.priority.compareTo( node.priority ) > 0 )
                       node=rotateLeft( node );
                         
                   
         }
            
        return node; 
        
    }
    
    

    private TreapNode rotateRight(TreapNode node) {
        
        TreapNode pivot=node.left; /*pivot es el elemento que quedará como raiz*/
        node.left=pivot.right;
        pivot.right=node;
        node=pivot;
        
        return node;
        
    }

    private TreapNode rotateLeft(TreapNode node) {
        
        TreapNode pivot=node.right;
        node.right=pivot.left;
        pivot.left=node;
        node=pivot;
        
        return node;
        
    }
    
    public void delete(Integer key){
        
        /*primero encuentro lo que quiero borrar*/
        TreapNode e=root;
        TreapNode padre=root;
        
        while( (e != null)  ){
            padre=e;
            if( key.compareTo( e.key ) < 0 ){
                e = e.left;
                if( e.key.compareTo(key) == 0 )                    
                    break;
            }
            
            else if( key.compareTo(e.key)> 0){
                e = e.right;
                if( e.key.compareTo(key) == 0 )
                    break;
            }
        } 
        
        if( e==null ) /*no habia nada que borrar*/
            return;
        
        /*ahora lo llevo hasta el final con rotaciones y lo elimino*/
        
        if(padre.left==e)
            padre.left=rotateAndEliminate( e );
        else if(padre.right==e)
            padre.right=rotateAndEliminate( e );

        
        
    }

    private TreapNode rotateAndEliminate(TreapNode e) {
        
        if( e.left==null && e.right==null )/*aca lo elimino definitivamente*/
            return null;
        
        else if( e.right == null || e.left.priority.compareTo( e.right.priority ) > 0 ){
            
            e=rotateRight( e );
            e.right = rotateAndEliminate( e.right );
            
        }
        
        else if( e.left == null || e.left.priority.compareTo( e.right.priority ) < 0 ){
            
            e=rotateLeft( e );
            e.left = rotateAndEliminate( e.left );
            
        }
        
        return e;
        
    }

    private int altura(TreapNode root) {
        if(root==null)
            return 0;
        else
            return Math.max(altura(root.left),altura(root.right))+1;
    }
}
