/*
 * MetodosArbol.java
 *
 * Created on 30 de agosto de 2007, 21:46
 *
 */

/**
 *
 * @author ccabrera
 */
public class MetodosArbol {
    
    public int alturaArbol( ArbolBinario arbol ){
        //arbol vacio
        if(arbol==null)
            return 0;
        
        //arbol con 2 hijos
        return Math.max( alturaArbol( arbol.left ), alturaArbol( arbol.right ) ) + 1 ;
            
    }
    
    public boolean arbolBalanceado(ArbolBinario arbol){

        //condicion de balanceo: para todo nodo, la diferencia entre la altura de sus dos hijos es menor o igual  a 1.
        
        //primero, probar que se cumpla en este nodo
        int alturaIzq = alturaArbol( arbol.left );
        int alturaDer = alturaArbol( arbol.right );
        
        int absDifference = Math.abs( alturaIzq - alturaDer );
        
        if( absDifference > 1)
            return false; //no esta balanceado!
        
         //luego, la condicion se tiene que cumplir para todos los hijos tambien
        else return
                arbolBalanceado( arbol.left ) && arbolBalanceado( arbol.right );
        
    }
    
}
