/*
 * ArbolPosicional.java
 *
 * Created on 30 de agosto de 2007, 22:10
 *
 */

/**
 *
 * @author ccabrera
 */
public class ArbolPosicional{
    
    int  numNodosLeft, numNodosRight;
    public ArbolPosicional left,right;
    public Integer value;
    
    
    public ArbolPosicional( ArbolPosicional a, ArbolPosicional b, Integer v ){
        
        left=a;
        right=b;
        value=v;
        numNodosLeft=0;
        numNodosRight=0;
        
    }
    
    public void insertar( Integer x){
        
        if(x==null)
            return;
        
        if(this.value==null){
            value=x;
            return;
        }
        
        
        if( x < value ){
            
            numNodosLeft += 1;
            if( left==null )
                left = new ArbolPosicional( null, null, x);
            else
                ((ArbolPosicional)left).insertar(x);
            
        } else{
            
            numNodosRight += 1;
            if( right==null )
                right = new ArbolPosicional( null, null, x);
            else
                ((ArbolPosicional)right).insertar(x);
            
        }
        
    }
    
    
    public boolean contiene( Integer x){
        
        if( x==null || value==null )
            return false;
        
        if( x==value )
            return true;
        
        if( x < value ){
            if(left==null)
                return false;
            return left.contiene(x);
        } else{
            if(right==null)
                return false;
            return right.contiene(x);
        }
        
    }
    public boolean eliminar( Integer x){
        
        if(!this.contiene(x))
            return false;
        return eliminar(x,null);
        
    }
    public boolean eliminar( Integer x,ArbolPosicional parent ){
        
        if(value==x){
            //si yo contengo al elemento y no tengo hijos, me tengo que eliminar
            if( left==null && right==null && x.equals(value) ){
                
                if(parent.left==this)
                    parent.left=null;
                else if(parent.right==this)
                    parent.right=null;
                return true;
                
            }
            
            //si tengo un solo hijo, basta con que lo tome y lo ponga en mi lugar :)
            if( left==null ){
                
                if(parent.left==this)
                    parent.left=right;
                else if(parent.right==this)
                    parent.right=right;
                return true;
                
            }
            if( right==null ){
                
                if(parent.left==this)
                    parent.left=left;
                else if(parent.right==this)
                    parent.right=left;
                return true;
                
            }
            
            //si tengo ambos hijos, pongo uno de mis hijos en mi lugar
            
            if(parent.left==this){
                
                parent.left=right;
                //y mi hijo izquierdo, lo pongo abajo a la izquierda!
                left.putFarLeft(left);
                
            } else if(parent.right==this){
                
                parent.right=left;
                //y mi hijo derecho, lo pongo abajo a la derecha!
                right.putFarRight(right);
                
            }
            return true;
        }
        
        if(x<value){
            
            numNodosLeft -= 1;
            return left.eliminar(x,this);
            
        } else{
            
            numNodosRight -= 1;
            return right.eliminar(x,this);
            
        }
        
    }
    
    private void putFarRight(ArbolPosicional right) {
        ArbolPosicional aux=this;
        while(aux.right!=null)
            aux=aux.right;
        aux.right=right;
    }
    
    private void putFarLeft(ArbolPosicional left) {
        ArbolPosicional aux=this;
        while(aux.left!=null)
            aux=aux.left;
        aux.left=left;
    }
    
    public Integer buscar(Integer x){
        
        if(x > (this.numNodosLeft+this.numNodosRight+1) )
            return null;
        
        ArbolPosicional aux=this;
        while(true){
            
            if( x == (numNodosLeft+1) )//o lo tengo yo
                return aux.value;
            
            else if( x <= numNodosLeft )//o esta a la izquierda
                aux=aux.left;
            
            else{//o esta a la derecha
                
                x -= numNodosLeft - 1;
                aux=aux.right;
                
            }
            
        }
        
    }
}











