function [error_3p,error_5p] = Ejemplo_Derivadas_3_5()
h=1e-4;
x0=(0:h:12);
xl=x0-h; x2l=x0-2*h;
xr=x0+h; x2r=x0+2*h;
y0=x0.*cos(x0.^2);
yl=xl.*cos(xl.^2); 
y2l=x2l.*cos(x2l.^2);
yr=xr.*cos(xr.^2);
y2r=x2r.*cos(x2r.^2);
der_3p=(yr-yl)/(2*h);
der_5p=(y2l-8*yl+8*yr-y2r)/(12*h);
syms u;
f=u*cos(u^2);
df=diff(f,1);
der_exacta=subs(df,x0);
error_3p=der_exacta-der_3p;
error_5p=der_exacta-der_5p;
subplot(1,2,1); plot(x0,error_3p);
title('Error Derivada 3 puntos: y=x*cos(x^2)');
legend('h=1e-4',2);
subplot(1,2,2); plot(x0,error_5p);
title('Error Derivada 5 puntos: y=x*cos(x^2)');
legend('h=1e-4',2);
end