import java.awt.*;
import java.awt.event.*;

class SuperCajaFuerte extends Frame implements ActionListener, WindowListener {
	String clave;
	String frase;
	
	Button ok;
	Label instr, resp;
	TextField msj;
	
	Button menu;
	Button cambiaClave;
	Button cambiaFrase;
	
	boolean modoAdmin;
	
	SuperCajaFuerte(){
		super("Caja Fuerte");
		
		this.clave="hola";
		this.frase="1+1=2";
		
		this.setLayout(new BorderLayout());
		
		this.ok=new Button(" Ok ");
		this.cambiaClave=new Button(" Clave ");
		this.cambiaFrase=new Button(" Frase ");
		this.menu=new Button();
		
		this.instr=new Label();
		this.resp=new Label();
		this.msj=new TextField(10);
		
		this.ok.addActionListener(this);
		this.menu.addActionListener(this);
		this.cambiaClave.addActionListener(this);
		this.cambiaFrase.addActionListener(this);
		this.addWindowListener(this);
		
		modoAdmin=false;
		this.muestraCaja();
	}
	public void muestraCaja(){
		this.removeAll();
		menu.setLabel(" Admin ");
		Panel p = new Panel(new FlowLayout());
		instr.setText(" Ingresa la clave secreta ");
		resp.setText("");
		p.add(msj);
		p.add(ok);
		p.add(menu);
		this.add(this.instr, BorderLayout.NORTH);
		this.add(p, BorderLayout.CENTER);
		this.add(this.resp, BorderLayout.SOUTH);
		pack();
		setVisible(true);
		modoAdmin=false;
	}
	public void muestraAdmin(){
		this.removeAll();
		menu.setLabel(" Volver ");
		Panel p = new Panel(new FlowLayout());
		Panel p2 = new Panel(new GridLayout(2,1));
		instr.setText(" Ingrese el campo a cambiar ");
		resp.setText("");
		p.add(msj);
		p2.add(cambiaClave);
		p2.add(cambiaFrase);
		p.add(p2);
		p.add(menu);
		this.add(this.instr, BorderLayout.NORTH);
		this.add(p, BorderLayout.CENTER);
		this.add(this.resp, BorderLayout.SOUTH);
		pack();
		setVisible(true);
		modoAdmin=true;
	}
	public void actionPerformed(ActionEvent e){
		if (e.getSource()==this.ok){
			String s=this.msj.getText();
			if(s.equals(this.clave))
				this.resp.setText("Frase Secreta="+frase);
			else
				this.resp.setText("Clave incorrecta");
			this.msj.setText("");
		}
		if (e.getSource()==this.menu){
			if (! modoAdmin){
				String s=this.msj.getText();
				if(s.equals(this.clave))
					this.muestraAdmin();
				else
					this.resp.setText("Clave incorrecta");
			}else
				this.muestraCaja();
			this.msj.setText("");
		}
		if (e.getSource()==this.cambiaClave){
			if (modoAdmin){
				String s=this.msj.getText();
				this.clave=s;
				this.resp.setText("Clave nueva!="+this.clave);
			}
			this.msj.setText("");
		}
		if (e.getSource()==this.cambiaFrase){
			if (modoAdmin){
				String s=this.msj.getText();
				this.frase=s;
				this.resp.setText("Frase modificada!");
			}
			this.msj.setText("");
		}
	}
	public void windowOpened(WindowEvent e){}
	public void windowClosing(WindowEvent e){this.dispose();}
	public void windowClosed(WindowEvent e){}
	public void windowIconified(WindowEvent e){}
	public void windowDeiconified(WindowEvent e){}
	public void windowActivated(WindowEvent e){}
	public void windowDeactivated(WindowEvent e){}
	public static void main(String args[]){
		new SuperCajaFuerte();
	}
}