import java.io.*;
import java.awt.*;
import java.awt.event.*;
class IngresaNotas extends Frame implements ActionListener{
	Button ingresa, borra;
	TextField apellido, nota;
	Label instr, resp;
	public IngresaNotas(){
		super ("Ingresa Notas");
		
		this.setLayout(new BorderLayout());
		
		this.ingresa = new Button(" Ingresar ");
		this.borra = new Button(" Borrar ");
		
		this.apellido=new TextField(7);
		this.nota=new TextField(3);
		
		this.instr=new Label(" Ingrese un apellido de largo menor a 7 ");
		this.resp=new Label("");
		
		Panel p1 = new Panel(new FlowLayout());
		p1.add(apellido);
		p1.add(nota);
		
		Panel p2 = new Panel(new GridLayout(2,1));
		p2.add(ingresa);
		p2.add(borra);
		
		Panel p = new Panel(new FlowLayout());
		p.add(p1);
		p.add(p2);
				
		this.ingresa.addActionListener(this);
		this.borra.addActionListener(this);
		
		this.add(this.instr, BorderLayout.NORTH);
		this.add(p, BorderLayout.CENTER);		
		this.add(this.resp, BorderLayout.SOUTH);
		
		this.pack();
		this.setVisible(true);
		
	}
	
	
	
	public void actionPerformed(ActionEvent e){
		if (e.getSource()==this.borra){
			String ap=this.apellido.getText();
			boolean b=false;
			
			if(ap.length()>7){
				this.resp.setText("Error: Largo max=7");
			}else{
				 b=borra(ap);				 
			}
			this.apellido.setText("");
			this.nota.setText("");
			if(b)
				this.resp.setText("Borrado exitoso");
			else
				this.resp.setText("Borrado fallo");
		}
		if (e.getSource()==this.ingresa){
			String ap=this.apellido.getText();
			String nt=this.nota.getText();
			boolean b=false;
			if(ap.length()>7){
				this.resp.setText("Error: Largo max=7");
			}else{
				double n=0.0;
				try{
					n=Double.parseDouble(nt);
					b=ingresaNota(completaEspacios(ap),n);
				}catch(Exception e2){
					this.resp.setText("Error: ingrese nota valida");
				}
			}
			this.apellido.setText("");
			this.nota.setText("");
			if(b)
				this.resp.setText("Ingreso exitoso");
			else
				this.resp.setText("Ingreso fallo");
		}
	}
	
	public static String completaEspacios(String s){
		for (int i=s.length(); i<7;i++){
			s=s+" ";
		}
		return s;
	}
	public static boolean borra(String apellido){
		boolean b=true;
		try{
			PrintWriter wr = new PrintWriter(new FileWriter("Notas2.txt"));
			BufferedReader rd = new BufferedReader (new FileReader("Notas.txt"));
			String l="";
			while((l=rd.readLine())!=null){			
				// supongo que en los 7 primeros caracteres tengo el nombre
				// y desp la nota
				String n= l.substring(0,7).trim();
				if (!n.equals(apellido))
					wr.println(l);
			}
			rd.close();
			wr.close();
			b=actualiza();
		}
		catch(Exception e2){
			System.out.println("Error borrar");
		}
		return b;
	}
	public static boolean ingresaNota(String apellido, double nota){
		boolean b=false;
		try{
			PrintWriter wr = new PrintWriter(new FileWriter("Notas2.txt"));
			BufferedReader rd = new BufferedReader (new FileReader("Notas.txt"));
			String l="";
			boolean ingreso=false;
			while((l=rd.readLine())!=null){			
				// supongo que en los 7 primeros caracteres tengo el nombre
				// y desp la nota
				String n= l.substring(0,7);
				if (n.equals(apellido)){
					wr.println(apellido+""+nota);
					ingreso=true;
				}else
					wr.println(l);
			}
			if (!ingreso)
				wr.println(apellido+""+nota);
			rd.close();
			wr.close();
			b=actualiza();
		}
		catch(Exception e2){
			System.out.println("Error ingrsar");
		}
		return b;
	}
	public static boolean actualiza(){
		boolean b=false;
		try{
			PrintWriter wr = new PrintWriter(new FileWriter("Notas.txt"));
			BufferedReader rd = new BufferedReader (new FileReader("Notas2.txt"));
			String l="";
			while((l=rd.readLine())!=null){			
				// supongo que en los 7 primeros caracteres tengo el nombre
				// y desp la nota
				wr.println(l);
			}
			rd.close();
			wr.close();
			b=true;
		}
		catch(Exception e2){
			System.out.println("Error actualiza");
		}
		return b;
	}
	
	public static void main (String args[]){
		IngresaNotas i = new IngresaNotas();
	}
}
