

public class Complejo implements Comparable{

	/*
	 * Variables de Instancia (Propiedades)
	 */
	private double real, imag;
	
	/*
	 * Constructor (Formato de Creacin)
	 */
	public Complejo(){
		
		real = 0.0;
		imag = 0.0;
	}
	
	public Complejo(double real, double imag){
		
		/*
		 * 'this.real' hace referencia a la variable de instancia 'real'
		 */
		this.real = real;
		this.imag = imag;
	}
	
	/*
	 * Mtodo Simple (Funcin que se ejecuta sobre un objeto)
	 */
	public void amplificar(double k){
		
		real = k*real;
		imag = k*imag;
	}
	
	/*
	 * Mtodo Complejo (Mtodo Simple que involucra otro Objeto)
	 * a = a+b;
	 */
	public void sumar(Complejo b){
		
		real = real + b.real;
		imag = imag + b.imag;
	}
	
	/*
	 * Mtodo Complejo (Mtodo Simple que involucra otro Objeto)
	 * return a+b;
	 */
	public Complejo suma(Complejo b){
		
		Complejo aux = new Complejo(real+b.real, imag+b.imag);
		return aux;
	}
	
	/*
	 * Mtodo Especial (Sirve para imprimir ms facil en pantalla)
	 */
	public String tostring(){
		
		return "("+real+", "+imag+"i)";
	}
	
	public boolean equals(Object o){
		
		Complejo b = (Complejo)o;
		
		return real*real+imag*imag == b.real*b.real+b.imag*b.imag;
	}

	public int compareTo(Object o) {

		Complejo b = (Complejo)o;
		
		return (int)(real*real+imag*imag-b.real*b.real-b.imag*b.imag);
	}
}
