//encabezamiento: 0.5
import java.awt.*;
import java.awt.event.*;

class EjemploCanvas extends Frame implements ActionListener {
	
	// componentes: 1.0
	private int ancho, alto;
	private Label label = new Label("N?");
	private TextField textfield = new TextField();
	private Button yellow = new Button("Y/B"), red = new Button("RB"), quit = new Button("quit");
	private Canvas canvas = new Canvas();

	// constructor: 1.5
	public EjemploCanvas() {
		// construir panel: 0.5
		ancho = 200;
		alto = 200;
		
		Panel p = new Panel();
		p.setLayout(new GridLayout(1, 5));
		p.add(label);
		p.add(textfield);
		p.add(yellow);
		p.add(red);
		p.add(quit);
		
		// diagramar ventana: 0.7
		setSize(ancho, alto + 50);
		canvas.setSize(ancho, alto);
		setLayout(new GridLayout(2,1));
		add(p);
		add(canvas);
		
		// activar botones: 0.3
		yellow.addActionListener(this);
		red.addActionListener(this);
		quit.addActionListener(this);
		
		//para que se vea
		this.setSize(400, 600);
		this.setVisible(true);
	}

	// metodo actionPerformed: 3.0
	// parte inicial: 0.5
	public void actionPerformed(ActionEvent x) {
		if (x.getSource() == quit)
			System.exit(0);
		Graphics g = canvas.getGraphics();
		int n = Integer.parseInt(textfield.getText());
		// dibujar ejes: 0.5
		int lado = ancho / n;
		//dibujar las lineas
		for (int i = 1; i <= n; ++i) {
			g.drawLine(0, i * lado, ancho, i * lado);
			g.drawLine(i * lado, 0, i * lado, alto);
		}
		// establecer colores: 0.5
		Color c1 = Color.yellow, c2 = Color.black;
		if (x.getSource() == red) {
			c1 = Color.red;
			c2 = Color.blue;
		}
		// dibujar fichas centrales: 1.5
		int i = n / 2 - 1;
		//Se elige el color con el cual se va a pintar
		g.setColor(c1);
		//Se dibujan los circulos
		g.fillOval(i * lado, i * lado, lado, lado);
		g.fillOval((i + 1) * lado, (i + 1) * lado, lado, lado);
		//Se elige el color con el cual se va a pintar
		g.setColor(c2);
		//Se dibujan los circulos
		g.fillOval((i + 1) * lado, i * lado, lado, lado);
		g.fillOval(i * lado, (i + 1) * lado, lado, lado);
	}
	
	static public void main(String[] args) {
		
		EjemploCanvas f = new EjemploCanvas();
	}
}
