import java.io.IOException;

class Auxiliar2 {
	
	
	public static void main(String[] args) throws IOException {
		
		U.println("Probando funciones. (Primero la version recursiva y luego la iterativa)");

		U.print("Ingrese un numero positivo para escribirlo en notacion binaria: ");
		binario_r(U.readInt());
		U.println("");	
		
		U.print("Ingrese un numero positivo para escribirlo en notacion binaria: ");
		binario_i(U.readInt());
		U.println("");	

		U.print("Ingrese un numero positivo para escribir su reverso: ");
		reverso_i(U.readInt());
		U.println("");


		U.print("Ingrese un numero positivo para escribir su reverso: ");
		reverso_r(U.readInt());
		U.println("");	
		
		U.print("Ingrese n para calcular fibonacci(n): ");
		U.println("" + fibonacci_r(U.readInt()));
		U.println("");

		U.print("Ingrese n para calcular fibonacci(n): ");
		U.println("" + fibonacci_i(U.readInt()));
		U.println("");				

	}
	
	public static void binario_r(int n) throws IOException {
		/*Se asume n >= 0*/
		if(n <= 1)
			U.print("" + n);
		else {
			binario_r(n/2);
			U.print("" + n%2);
		}
	}
	
	public static void binario_i(int n) throws IOException {
		/*Se asume n > 0*/
		/*Si n es 0, entonces conviene usar
		
		int i = (int)Math.ceil(Math.log(n + 1)/Math.log(2));
		
		*/
		
		int i = (int)Math.floor(Math.log(n)/Math.log(2)) + 1;
		
		while(i >= 1) {
			
			if(n >= potencia2(i - 1)) {
				U.print("" + 1);
				n = n - potencia2(i - 1);
			}
			
			else 
				U.print("" + 0);
			
			i = i - 1;
		}
	}
	
	public static void reverso_r(int n) throws IOException {
		if(n < 10)
			U.print("" + n);
		else {
			U.print("" + n%10);
			reverso_r(n/10);
		}
	}
	
	public static void reverso_i(int n) throws IOException {
		while(n > 0) {
			U.print("" + n%10);
			n = n/10;
		}
	}
	
	public static int fibonacci_r(int n) {
		if(n < 2)
			return n;
		else
			return fibonacci_r(n - 2) + fibonacci_r(n - 1);
	}
	
	public static int fibonacci_i(int n) {
		if(n < 2)
			return n;
		
		int fib_ant = 0;
		int fib = 1;
		int temp;

		int i = 1;
		
		while(i < n) {
			temp = fib;
			fib = fib_ant + fib;
			fib_ant = temp;
			i = i + 1;
		}
		
		return fib;
	}
	
	//Funcion que calcula la n-esima potencia de 2
	public static int potencia2(int n) {
		return (int)Math.pow(2, n);
	}
	
}
