import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class Ejemplos extends Frame implements ActionListener{

	Label L;
	
	JLabel label;
	ImageIcon imagen1, imagen2, imagen3;
	
	TextField T1,T2,T3;
	
	Button botonI, botonF, botonB, botonC;
	
	//Estos booleans son para los "intercambios" en el ActionListener
	boolean block, negr, col;
	
	Font f;
	
	public Ejemplos(){
		
		setSize(600,150);
		setTitle("Ejemplos");
		
		//Para que una palabra salga centrada en un Label o TF
		//solo hay que agregarle un parmetro
		L = new Label("Esta oracin esta centrada",Label.CENTER);
		
		label = new JLabel();
		T1 = new TextField();
		T2 = new TextField();
		T3 = new TextField();
		
		block=negr=col=false;
		
		botonI = new Button("Cambiar Imagen");
		botonF = new Button("Cambiar Fuente");
		botonB = new Button("Bloquear/Desbloquear ");
		botonC = new Button("Cambiar Color");
		
		//Para definir la FUENTE con que voy a escribir
		f = new Font("", Font.PLAIN, 14);
		
		
		Panel P=new Panel();
		P.setLayout(new GridLayout(1,4));
		P.add(label);P.add(T1);P.add(T2);P.add(T3);
		
		Panel Q=new Panel();
		Q.setLayout(new GridLayout(1,4));
		Q.add(botonI);Q.add(botonF);Q.add(botonB);Q.add(botonC);
		
		setLayout(new GridLayout(3,1));
		add(L);add(P);add(Q);
		
		//Objetos que representan imagenes
		imagen1 = new ImageIcon("pasillo.jpg");
		imagen2 = new ImageIcon("jugador.jpg");
		imagen3 = new ImageIcon("pared.jpg");
		
		//Seteo la imagen que mostrara el label
		label.setIcon(imagen1);
		
		
		botonI.addActionListener(this);
		botonF.addActionListener(this);
		botonB.addActionListener(this);
		botonC.addActionListener(this);
		
		//Para que se cierre la ventana con la X
		addWindowListener(new WindowAdapter(){public void windowClosing(WindowEvent x){
		dispose();}});
		
		
	
	}
	
	public static void main(String[] args) {
		new Ejemplos().setVisible(true);

	}

	public void actionPerformed(ActionEvent x) {
		//Hago que las imagenes del label vayan cambiando
		if(x.getSource() == botonI){
			if (label.getIcon() == imagen1) //Si la imagen era la misma que imagen1
				label.setIcon(imagen2); 	//Entonces hago que muestre imagen2
			else if (label.getIcon() == imagen2) 
				label.setIcon(imagen3);
			else {
				label.setIcon(imagen1);
			}
		}
		else
		//Si quiero NEGRITAS para mis letras, cambio la FUENTE
		if(x.getSource() == botonF){
			if(negr) f = new Font("", Font.PLAIN, 14);
			else f = new Font("", Font.BOLD, 14);
			T1.setFont(f);
			negr = (!negr);
		}
		else
		//Para BLOQUEAR el TF
		if(x.getSource() == botonB){
			T2.setEditable(block);
			block = (!block);
		}
		else
		//Otra forma de marcar un TF es con COLOR
		if(x.getSource() == botonC){
			if(col) T3.setBackground(Color.white);
			else T3.setBackground(Color.yellow);
			col = (!col);
		}
				
	}

}
