import java.*;
import java.lang.*;
import java.io.*;

/* Tarea 2 MA37A Implementacion del Metodo de la Esquina Noroeste
 * Prof.: Hector Ramirez
 * Aux.: Oscar Peredo
 *
 * El objetivo de esta tarea es implementar la fase I del
 * algoritmo simplex para redes (problema de transporte), 
 * para ello se le pide en particular implementar el metodo 
 * de la esquina noroeste.
 *
 * Para la compilacion:
 * $javac esquinaNoroeste.java
 *
 * El uso de este template es el siguiente:
 * $ java esquinaNoroeste N M
 * donde N es el numero de nodos ofertantes y M de demandantes.
 * Ademas se debe entregar la informacion de oferta/demanda
 * en un archivo de la siguiente forma
 * (para N=4,M=3):
 *
 * 0 1
 * 1 1
 * 2 1
 * 3 1
 * #
 * 0 1
 * 1 1
 * 2 2
 * 
 * Si la informacion anterior esta guardada en un archivo llamado
 * datos.txt, entonces el programa se ejecuta de la forma:
 * $ java esquinaNoroeste N M < datos.txt
 *
 * La salida esperada es el flujo basico factible obtenido,
 * en el siguiente formato:
 *
 * 0 0 0
 * 0 1 0
 * 0 2 1
 * 1 0 1
 * 1 1 0
 * 1 2 0
 * 2 0 0
 * 2 1 0
 * 2 2 1
 * 3 0 0
 * 3 1 0
 * 3 2 1
 *      
 * Cualquier duda o consulta enviar un correo a operedo@ing.uchile.cl.
 * 
 * */


public class esquinaNoroeste{
	public static void main(String args[]) throws IOException{
		if(args.length>2){
			System.out.println("Uso: java esquinaNoroeste N M\nCon N=numero de nodos de partida y M=numero de nodos de llegada");
			System.exit(1);
		}
		int n=Integer.parseInt(args[0]);
		int m=Integer.parseInt(args[1]);
		double[] ofertantes = new double[n];
		double[] demandantes = new double[m];
		
		String linea="";
		String[] aux=new String[2];
		BufferedReader entrada=new BufferedReader(new InputStreamReader(System.in));
		
		int index=0;
		for(int i=0; i<n; i++){
        		linea=entrada.readLine();
        	
        		// version 1.4 o mas
			//******************
			//aux=linea.split("[\t ]+");
			//******************
        	
            		// version 1.2
            		//******************
            		aux[0]=linea.substring(0,linea.indexOf(' '));
            		aux[1]=linea.substring(linea.indexOf(' '));
            		//******************
			
			index=Integer.parseInt(aux[0]);
			ofertantes[index]=Double.parseDouble(aux[1]);
		}
		
		linea=entrada.readLine();
		
		for(int i=0; i<m; i++){
        		linea=entrada.readLine();
        	
        		// version 1.4 o mas
        		//*******************
        		//aux=linea.split("[\t ]+");
        		//*******************
        	
        		// version 1.2
        		//*******************
        		aux[0]=linea.substring(0,linea.indexOf(' '));
            		aux[1]=linea.substring(linea.indexOf(' '));
			//*******************
			index=Integer.parseInt(aux[0]);
			demandantes[index]=Double.parseDouble(aux[1]);
		}
		
		//
		//
		//desarrolle su solucion aca...
		//
		//
		
		
		entrada.close();
	}
	
}
