Attribute VB_Name = "Module1"
Option Explicit
Public sendText As String    ' text (xml) to send
Public msgCounter As Long    ' to match server response with client event
Public inWait As Boolean     ' semaphore marker when waiting
Public receivedNumber As Integer   ' last received event number
Public waitCanceled As Boolean
Public waitCount As Long
Public echoCount, gotEcho
Public inCritical   ' if in critical section
Function inMyList(ByVal inMe As String, ByVal findMe As String) As Boolean

   ' if in a comma-separated list
   Dim useInMe, useFindMe
   useInMe = Trim(cReplace(inMe, Space(1), Space(0)))
   If Len(useInMe) = 0 Then
      inMyList = False
   Else
      useInMe = "," & useInMe & ","
      useFindMe = "," & Trim(findMe) & ","
      inMyList = InStr(1, useInMe, useFindMe, 1) > 0
   End If
End Function
Function cReplace(ByVal SearchMe As String, ByVal c1 As String, ByVal c2 As String) As String
' Replace character (VB 4 has no "replace" command)
   Dim i, result, length
   Dim c As String
   If InStr(1, SearchMe, c1, 1) = 0 Then
      cReplace = SearchMe
      Exit Function    ' for efficiency no scan if not in
   End If
   result = Space(0)
   length = Len(SearchMe)
   If length > 0 Then
      For i = 1 To length
         c = Mid(SearchMe, i, 1)
         If LCase(c) = LCase(c1) Then
            result = result & c2
         Else
            result = result & c
         End If
      Next i
   End If
   cReplace = result
End Function
Function isBlank(ByVal checkme) As Boolean
   isBlank = (Len(Trim(checkme & "")) = 0)
End Function
Sub statusBar(ByVal msg As String)
   scguiConsole.statusBox.Text = msg
End Sub
Sub eventAct(formRef, waitSetting, eventName, Coverage, wid)
   ' act on event
   Dim useWait As Variant, boolWait As Boolean, i
   Dim formID
   waitCritical
   logStuff "Event", "wt=" & waitSetting & ",evt=" & eventName & ",cov=" & Coverage & ",wid=" & wid
   If Not isBlank(Coverage) And LCase(Coverage) <> "none" Then
   
      If inWait Then  ' already processing - cheap semaphore
         MsgBox "Event already in-progress. New events not accepted right now."
         Exit Sub
      End If
      If LCase(Trim(Coverage)) = "close" Then    ' local event: hide form
         formRef.Visible = False
         Exit Sub
      End If
      formID = formRef.Tag
      If isBlank(wid) Then wid = "form"
      useWait = LCase(Trim(waitSetting & ""))
      ' convert to Boolean
      boolWait = (Len(useWait) > 0 And inMyList("on,yes,true,1", useWait))
      Debug.Print "Event-Trace [frm,wait,evt,cov,wid]:  " & formID & "," & waitSetting & "[" & boolWait & "]," & eventName & "," & Coverage & "," & wid
      If boolWait Then
         inWait = True
         'MsgBox "hourglass on"
         statusBar "Processing 'wait event'"
         formRef.MousePointer = 11     ' hour glass
         waitCanceled = False
         msgCounter = msgCounter + 1
         startTag "event"     ' nest details in this event tag
         sendPair "eventid", msgCounter
         finishTag False
      End If
      startTag ""
      sendPair "formid", formID
      sendPair "event", eventName
      sendPair "coverage", Coverage
      sendPair "widgetid", wid
      finishTag True
      formRef.contentSender Coverage, formID, wid
      If boolWait Then
         startTag "/event"     ' end the event tag (see above)
         finishTag False
         sendAndWait msgCounter
         statusBar "Done with event"
         formRef.MousePointer = 0     ' regular
         inWait = False
      Else
         ' sendNoWait  [use timer instead]
      End If
   End If
End Sub
Sub startTag(tagName)  ' start an xml tag for sending
   If isBlank(tagName) Then
      sendText = sendText & "<scgui "
   Else
      sendText = sendText & "<" & Trim(tagName)
   End If
End Sub
Sub sendPair(Attrib, theValue)   ' send a attribute-value pair
   dim useValue
   useValue = cReplace(theValue, """", "`")
   sendText = sendText & Space(1) & Trim(Attrib) & "=" & Chr(34) & useValue & Chr(34)
End Sub
Sub finishTag(fullClose)   ' close off (see startTag)
   If fullClose Then
      sendText = sendText & "/>" & vbCrLf
   Else
      sendText = sendText & ">" & vbCrLf
   End If
End Sub
Sub sendAndWait(msgNum)
   Dim cntr, temp
   Call sendNoWait
   ' loop until proper event number received
   cntr = 0
   Do While receivedNumber <> msgCounter And Not waitCanceled
      DoEvents
      DoEvents
      cntr = cntr + 1
      If cntr > 5000 Then
         ' cheapo activity indicator
         temp = Mid(scguiConsole.altStatBox, 1, 2)
         If temp = ".|" Then
            scguiConsole.altStatBox = "|. - " & waitCount
         Else
            scguiConsole.altStatBox = ".| - " & waitCount
         End If
         cntr = 0
      End If
   Loop
   waitCount = 0   ' re-init
End Sub
Sub sendNoWait()   ' send xml queue to message file
   Dim tempFile, targetFile, textCopy, temp
   waitCritical
   tempFile = Trim(scguiConsole.pollPath) & "temp1.tmp"
   targetFile = Trim(scguiConsole.pollPath) & Trim(scguiConsole.msgFile)
   ' still exists? (if not picked up yet then dont overwrite)
   If isBlank(Dir(targetFile)) And Not isBlank(sendText) Then
      inCritical = True
      Call writeToFile(tempFile, sendText)
      textCopy = sendText  ' copy to write after
      sendText = Space(0)    ' reset queue
      inCritical = False
      If isBlank(Dir(tempFile)) Then
         MsgBox "Unknown file write error. msg472982"
      End If
      ' rename to avoid open-file collision
      Rem Kill targetFile
      Name tempFile As targetFile
      DoEvents
      logStuff "Sent", textCopy
   End If
End Sub
Function readFile(fileName)
   Dim b As Byte
   Dim collect As String
    collect = Space(0)
    Open fileName For Binary Access Read As #1
    Do While Not EOF(1)
        Get #1, , b
        collect = collect & Chr(b)
    Loop
    Close #1
    readFile = collect
End Function
Sub writeToFile(fileName, writeMe)
   Dim b As Byte, i As Long
   If Len(Trim(Dir(fileName))) > 0 Then   ' clear any prior
      Kill fileName
   End If
   If Len(Trim(writeMe)) <> 0 Then
      Open fileName For Binary Access Write As #1
      For i = 1 To Len(writeMe)
         b = Asc(Mid(writeMe, i, 1))
         Put #1, , b
      Next i
      Close #1
   End If
End Sub
Sub showTextBox(theText)
   textViewerForm.Textbox.Text = theText
   DoEvents
   Load textViewerForm
   textViewerForm.Visible = True
End Sub
Sub getIncoming()    ' get any incoming messages
   Dim targetFile, xml
   targetFile = Trim(scguiConsole.pollPath) & "msg2.dat"
   If Len(Trim(Dir(targetFile))) <> 0 Then
      statusBar "Incoming received at " & Now()
      xml = readFile(targetFile)
      If Len(xml) > 0 Then
         If Mid(xml, Len(xml), 1) = Chr(0) Then
            xml = Mid(xml, 1, Len(xml) - 1) ' chop off funny char
         End If
      End If
      logStuff "Incoming", xml
      If Trim(xml) = "<echo/>" Then
         gotEcho = True
         Debug.Print "Rcvd Echo."
      End If
      parse_reader2 xml
      Kill targetFile
   Else  ' no message file
      ' Alternate caps slightly to give change cue
      If scguiConsole.altStatBox = "noMsg" Then
         scguiConsole.altStatBox = "NoMsg"
      Else
         scguiConsole.altStatBox = "noMsg"
      End If
   End If
   ' Note that the creater of that file should use
   ' the Rename technique so that it is not open at
   ' any point during our read
End Sub
Sub initGlobals()
   ' init some globals, others in console startup
   msgCounter = 0
   inWait = False
   receivedNumber = 0
   waitCanceled = False
   waitCount = 0
   inCritical = False
End Sub
Sub logStuff(ByVal title, ByVal logMe)
  ' write stuff to log file for later review/tracing
  Dim b
  If scguiConsole.isLogFile.Value <> 1 Then
     Exit Sub     ' logging switched off
  End If
  b = vbCrLf & "************ " & title & " - " & Now() & vbCrLf
  b = b & logMe
  Open Trim(scguiConsole.pollPath) & "logfile.dat" For Append As #2
  Print #2, b
  Close #2
End Sub
Sub eraseFile(fileName)
   If Not isBlank(Dir(fileName)) Then
      Kill fileName
   End If
End Sub
Sub asciiDump(theString)    ' debugging util
  Dim i, c
  If Len(theString) > 0 Then
    For i = 1 To Len(theString) Step 1
      c = Mid(theString, i, 1)
      Debug.Print "[" & i & " : " & Asc(c) & " : " & c & "]"
    Next i
  Else
    Debug.Print "Zero Length"
  End If
End Sub
Sub waitCritical()
' wait on any critical event - I don't claim this a perfect semaphore
   Do While inCritical
     DoEvents
     DoEvents
   Loop
End Sub
