Attribute VB_Name = "parse1"
Option Explicit

Dim Attrib(25, 2) As String   ' attribute dictionary wannabe
Dim attribMax

Dim inTag, inTagName, inAttribName, tagName, attribName, inValue
Dim curForm, curWidget, errText, lastChar, lastNSchar, gotValue
Dim collectName, collectAttrib, CollectValue, inQuotes, tagCount
Dim charCount


Sub init_parse()
    inTag = False
    tagName = Space(0)
    inQuotes = False
    curForm = Space(0)
    curWidget = Space(0)
    errText = Space(0)
    tagCount = 0
End Sub

Sub parse_reader2(ByVal theString)
    Dim i, c

    If Len(theString) > 0 Then
      For i = 1 To Len(theString)
        c = Mid(theString, i, 1)
        Call parse1(c)
      Next
    End If
End Sub

Sub parse_reader(ByVal fileName)  ' NOT IN USAGE *******
    Dim b As Byte, c As String
    
    Debug.Print "-----------start of parse-------------"
    init_parse
    charCount = 0
    Open fileName For Binary Access Read As #1
    Do While Not EOF(1)
        charCount = charCount + 1
        Get #1, , b
        c = Chr(b)
        Call parse1(c)
        'Debug.Print charCount & "," & b & "," & c
    Loop
    Close #1
End Sub
'--------------------------
Sub init_tag()

   Dim i
   attribMax = 25
   For i = 1 To attribMax
      Attrib(i, 1) = Space(0)
      Attrib(i, 2) = Space(0)
   Next i
End Sub
Sub parse1(ByVal c)
' Use a bunch of 'in' flags to determine where we are and what to
' save.
   Dim atEnder

   If c = Chr(10) Or c = Chr(13) Or c = Chr(9) Then ' white space = blank
      c = Space(1)
   End If
   If Not inQuotes Then
      atEnder = (c = ">" Or (c = "/" And lastChar <> "<"))
      If c = "<" Then
         init_tag
         inTag = True
         inTagName = True
         collectName = Space(0)   ' re-inits
         tagName = Space(0)
         attribName = Space(0)
         gotValue = Space(0)
         collectName = Space(0)
         collectAttrib = Space(0)
         CollectValue = Space(0)
         inAttribName = False
         inValue = False
         tagCount = tagCount + 1
      End If
      
      ' Sanity checks
      If inAttribName And inValue Then
         MsgBox "ERROR: unknown XML parsing overlap error 8573: tag#" & tagCount
      End If

      If c = Space(1) Or atEnder Then
         If inTagName Then
            inTagName = False
            tagName = collectName
         End If
         If inValue Then
            inValue = False
            gotValue = CollectValue
            saveValue tagName, attribName, gotValue
            ' re-init attrib
            gotValue = Space(0)
            attribName = Space(0)
            collectAttrib = Space(0)
            CollectValue = Space(0)
         End If
      ElseIf c = Chr(34) Then    ' 34 is double quote
         inQuotes = True
      End If
      If (c = Space(1) Or c = "=" Or atEnder) And inAttribName Then
         inAttribName = False
         attribName = collectAttrib
      End If
      If inTag And c <> Space(1) And Not atEnder Then
         If lastNSchar = "=" Then
            inAttribName = False
            inValue = True
         End If
         If Not inTagName And Not inValue And Not inAttribName _
          And c <> "=" Then
            inAttribName = True
            collectName = Space(0)
            CollectValue = Space(0)
         End If
      End If
     
      If inTagName And c <> "<" Then
         collectName = collectName & LCase(c)
      End If
      If inAttribName Then
         collectAttrib = collectAttrib & LCase(c)
      End If
      If inValue Then
         CollectValue = CollectValue & c
      End If
      If atEnder Then
         inTag = False
         If c = ">" Then
            processTag
         End If
      End If
      
      '----
      lastChar = c
      If c <> Space(1) Then   ' last non-space char
         lastNSchar = c
      End If
   Else    ' in quotes
      CollectValue = CollectValue & c
      If c = Chr(34) Then inQuotes = False
   End If  ' not in quotes
   If False Then  ' tracing only
      Debug.Print "PARSE: c,inTag,inAttr,inVal,pos,inQuote: "; c; " "; inTag; inAttribName; inValue; " "; charCount; " ", inQuotes
   End If
End Sub
Sub saveValue(tagName, attribName, theValue)
' store attribute/value pair in dictionary (simulated or otherwise)
   Dim useVal, i, found, firstBlank, temp
   If False Then
      Debug.Print " in saveValue [tag,atr,vl] " & tagName & "," & attribName & "," & theValue
      Call Dump1
   End If
   useVal = theValue
   If Len(useVal) >= 2 Then
      If Mid(useVal, 1, 1) = Chr(34) Then  ' remove quotes
         useVal = Mid(useVal, 2)
         useVal = Mid(useVal, 1, Len(useVal) - 1)
      End If
      If Mid(useVal, 1, 1) = "'" Then      ' remove single quotes
         useVal = Mid(useVal, 2)
         useVal = Mid(useVal, 1, Len(useVal) - 1)
      End If
   End If
   
   'Debug.Print "SET: tagName,attrName,Val: " & tagName & "," & attribName & "," & useVal
   ' Update the corresponding value (a dictionary or table would be a better design if avail.)
   found = 0
   firstBlank = 0
   For i = 1 To attribMax
      If Attrib(i, 1) = attribName Then
         found = i
         Exit For
      End If
      If Attrib(i, 1) = Space(0) And firstBlank = 0 Then
         firstBlank = i
      End If
   Next i
   If found = 0 Then      ' not found, add new
      If firstBlank = 0 Then MsgBox "Error: xml attrib array full"
      Attrib(firstBlank, 1) = Trim(attribName)
      found = firstBlank
   End If
   
   Attrib(found, 2) = useVal
   
End Sub
Sub processTag()
   Dim i, attr, theVal, critList, temp
   
   If Not inMyList("scgui,form,widget,scguiform", tagName) Then
      'debug.print "trace: rejecting: " & tagName
      Exit Sub     ' ignore non relavant tags
   End If
   
   'Debug.Print "  in ProcessTag " & tagName
   If Len(Trim(tagName & "")) = 0 Then
      MsgBox "ERROR: Tag is missing name. Contact Admin. " & tagCount
   End If
   If tagName = "scgui" Then
      curWidget = Space(0)      'don't use prior if this tag
   End If
   ' first pass to see identity of widget or form, accepts both forms
   For i = 1 To attribMax
      attr = Attrib(i, 1)
      theVal = Attrib(i, 2)
      Rem If attr <> "" Then Debug.Print " SCAN: "; attr, theVal
      If theVal <> Space(0) Then
         If attr = "formid" Then curForm = theVal
         If attr = "widgetid" Then curWidget = theVal
         If (tagName = "form" Or tagName = "scguiform") And attr = "id" Then
            curForm = theVal
         End If
         If tagName = "widget" And attr = "id" Then curWidget = theVal
      End If
   Next i
   
   If Trim(curWidget) = Space(0) And tagName = "scgui" Then
      curWidget = "form"       ' default=form if widget ID not in tag
   End If
   ' Give priority to certain attribs (i sure miss TOP, i need more sorting priorities here)
   Dim topList1, toplist2, bottomList
   topList1 = "widgettype,type"
   toplist2 = "row,col"
   bottomList = "visible"
   ' top list first
   For i = 1 To attribMax
      attr = Trim(Attrib(i, 1))
      If False And attr <> "" Then     ' dictionary dump for tracing
         Debug.Print "dict dump: " & i & "," & attr & "," & Attrib(i, 2)
      End If
      If inMyList(topList1, attr) Then
         giveItem curForm, curWidget, Attrib(i, 1), Attrib(i, 2), tagCount, ""
      End If
   Next i
   ' top 2nd list first
   For i = 1 To attribMax
      attr = Trim(Attrib(i, 1))
      If inMyList(toplist2, attr) Then
         giveItem curForm, curWidget, Attrib(i, 1), Attrib(i, 2), tagCount, ""
      End If
   Next i
   ' regular ones
   For i = 1 To attribMax
      attr = Trim(Attrib(i, 1))
      If Not inMyList(topList1 & toplist2 & bottomList, attr) And Len(attr) > 0 Then
         giveItem curForm, curWidget, Attrib(i, 1), Attrib(i, 2), tagCount, ""
      End If
   Next i
   ' bottom list
   For i = 1 To attribMax
      attr = Trim(Attrib(i, 1))
      If inMyList(bottomList, attr) Then
         giveItem curForm, curWidget, Attrib(i, 1), Attrib(i, 2), tagCount, ""
      End If
   Next i
End Sub
Sub giveItem(ByVal formID, ByVal widgetID, ByVal attribName, _
             ByVal AttribValue, ByVal tagNo, ByVal other)
   Dim useAttrib, useValue, passwordFlag
   useAttrib = attribName
   useValue = AttribValue
   passwordFlag = False
   
   If inMyList("formid,widgetid,id", useAttrib) Then
      Exit Sub     ' we don't need these anymore because part of params
   End If
   If useAttrib = "id" Then MsgBox "ERROR: ID FILTER"
      
   ' translate some items for consistency
   If useAttrib = "type" And (tagName = "widget") Then
      useAttrib = "widgettype"
   End If
   ' plug pass-word type with a VB attribute (not sure this is the best place to do this)
   If useAttrib = "widgettype" And useValue = "password" Then
      useValue = "textbox"
      passwordFlag = True    ' to trigger VB setting *after* type is given
   End If

   ' Checking
   If isBlank(formID) Or isBlank(widgetID) Or isBlank(useAttrib) Then
      MsgBox "ERROR parsing tag: " & tagName & " (" & formID & "," & widgetID & "," & tagNo & ")(empty detect)"
   End If
   '
   'Debug.Print "--> Attrib: " & formID & "," & widgetID & "," & attribName & " = '" & useValue & "' "
   DoEvents
   scguiConsole.giveToForm formID, widgetID, useAttrib, useValue, tagNo & Space(1) & other
   If passwordFlag Then
      giveItem formID, widgetID, "passwordchar", "*", tagNo, other   ' recursive
   End If
End Sub
Sub Dump1()   ' debugging tool (I HATE arrays! Viva T.O.P.!)
   Dim i, attr
   Debug.Print "-----DUMP----"
   Debug.Print "(attribMax: " & attribMax & ")"
   For i = 1 To attribMax
      attr = Trim(Attrib(i, 1))
      If True And attr <> "" Then     ' dictionary dump for tracing
         Debug.Print "dict dump: " & i & "," & attr & "," & Attrib(i, 2)
      End If
   Next i
   Debug.Print "---[end dump]---"
End Sub
