 
<%
REM - XML Parsing and utils INCLUDE file

' regional variables used by this package
' 'Tag' and 'statement' are used interchangably, for good or bad.
Dim inTag, inTagName, inAttribName, tagName, attribName, inValue
Dim curForm, curWidget, errText, lastChar, lastNSchar, gotValue
Dim collectName, collectAttrib, CollectValue, inQuotes, tagCount
Dim charCount

'----------------------------------------
sub processStmt(tagName)  ' process a single statement
  dim i
  attribUpdate "tagname", tagName   'make the tag name a dict entry

  if false then  ' for testing only - echos attrib-value pairs
    hout "<br>----------"
    for each i in attribs
      hout "<br><b>" & i & "</b> = (" & attribs.item(i) & ")"
    next 
  end if

  call HandleStmt(attribs)

end sub
'----------------------------------------
sub testParse       ' for TESTING only
  temp = request("parseme")
  if temp <> "" then
    parse_reader2(temp)
    response.write  sendtext
  end if
  %>
  <!-- test box -->
  <form method=post action="scgui1.asp">
    <textarea name="parseme" rows=8 cols=65><%=request("parseme")%></textarea>
    <input type=submit>
  </form>
  <%
end sub
'--------------------------------
Sub parse_reader2(ByVal theString)
    Dim i, c

    if len(theString) > 0 then
      for i = 1 to len(theString)
        c = mid(theString, i, 1)
        Call parse1(c)
      next
    end if
End Sub
'--------------------------
Sub init_parse()

    inTag = False
    tagName = Space(0)
    inQuotes = False
    curForm = Space(0)
    curWidget = Space(0)
    errText = Space(0)
    tagCount = 0
End Sub
'--------------------------------
Sub init_stmt()
  attribs.removeall
End Sub
'---------------------------
Sub parse1(ByVal c)
' Use a bunch of 'in' flags to determine where we are and what to
' save.
   Dim atEnder

   If c = Chr(10) Or c = Chr(13) Or c = Chr(9) Then ' white space = blank
      c = Space(1)
   End If
   If Not inQuotes Then
      atEnder = (c = ">" Or (c = "/" And lastChar <> "<"))
      If c = "<" Then
         init_stmt
         inTag = True
         inTagName = True
         collectName = Space(0)   ' re-inits
         tagName = Space(0)
         attribName = Space(0)
         gotValue = Space(0)
         collectName = Space(0)
         collectAttrib = Space(0)
         CollectValue = Space(0)
         inAttribName = False
         inValue = False
         tagCount = tagCount + 1
      End If
      
      ' Sanity checks
      If inAttribName And inValue Then
         MsgBox "ERROR: unknown XML parsing overlap error 8573: tag#" & tagCount
      End If

      If c = Space(1) Or atEnder Then
         If inTagName Then
            inTagName = False
            tagName = collectName
         End If
         If inValue Then
            inValue = False
            gotValue = CollectValue
            saveValue tagName, attribName, gotValue
            ' re-init attrib
            gotValue = Space(0)
            attribName = Space(0)
            collectAttrib = Space(0)
            CollectValue = Space(0)
         End If
      ElseIf c = Chr(34) Then    ' 34 is double quote
         inQuotes = True
      End If
      If (c = Space(1) Or c = "=" Or atEnder) And inAttribName Then
         inAttribName = False
         attribName = collectAttrib
      End If
      If inTag And c <> Space(1) And Not atEnder Then
         If lastNSchar = "=" Then
            inAttribName = False
            inValue = True
         End If
         If Not inTagName And Not inValue And Not inAttribName _
          And c <> "=" Then
            inAttribName = True
            collectName = Space(0)
            CollectValue = Space(0)
         End If
      End If
     
      If inTagName And c <> "<" Then
         collectName = collectName & LCase(c)
      End If
      If inAttribName Then
         collectAttrib = collectAttrib & LCase(c)
      End If
      If inValue Then
         CollectValue = CollectValue & c
      End If
      If atEnder Then
         inTag = False
         If c = ">" Then
            processStmt  TagName
         End If
      End If
      
      '----
      lastChar = c
      If c <> Space(1) Then   ' last non-space char
         lastNSchar = c
      End If
   Else    ' in quotes
      CollectValue = CollectValue & c
      If c = Chr(34) Then inQuotes = False
   End If  ' not in quotes
   If False Then  ' tracing only
      'Debug.Print "PARSE: c,inTag,inAttr,inVal,pos,inQuote: "; c; " "; inTag; inAttribName; inValue; " "; charCount; " ", inQuotes
   End If
End Sub
'--------------------------------
Sub saveValue(tagName, attribName, theValue)
' store attribute/value pair in dictionary (simulated or otherwise)
   Dim useVal, i, found, firstBlank, temp
   If False Then
      Hout "<br> in saveValue [tag,atr,vl] " & tagName & "," & attribName & "," & theValue
      Call Dump1
   End If
   useVal = theValue
   If Len(useVal) >= 2 Then
      If Mid(useVal, 1, 1) = Chr(34) Then  ' remove quotes
         useVal = Mid(useVal, 2)
         useVal = Mid(useVal, 1, Len(useVal) - 1)
      End If
      If Mid(useVal, 1, 1) = "'" Then      ' remove single quotes
         useVal = Mid(useVal, 2)
         useVal = Mid(useVal, 1, Len(useVal) - 1)
      End If
   End If
   
   call AttribUpdate(attribName, useVal)
   
End Sub
'--------------------------------
Sub REMprocessStmt(tagName)   ' define in callee instead
   Dim i, attr, theVal, critList, temp
   
   If Not inMyList("scgui,form,widget,scguiform,event", tagName) Then
      'debug.print "trace: rejecting: " & tagName
      Exit Sub     ' ignore non relavant tags
   End If
   
   'Hout "<br>  in ProcessStmt " & tagName
   If Len(Trim(tagName & "")) = 0 Then
      MsgBox "ERROR: Tag is missing name. Contact Admin. " & tagCount
   End If

End Sub
'--------------------------------------------
Function inMyList(ByVal inMe, ByVal findMe)

   ' if in a comma-separated list
   Dim useInMe, useFindMe
   useInMe = Trim(Replace(inMe, Space(1), Space(0)))
   If Len(useInMe) = 0 Then
      inMyList = False
   Else
      useInMe = "," & useInMe & ","
      useFindMe = "," & Trim(findMe) & ","
      inMyList = InStr(1, useInMe, useFindMe, 1) > 0
   End If
End Function
'-------------------------------------------
sub attribUpdate(attribName, theValue)
  dim useAttr
  useAttr = lcase(trim(attribName))
  if len(useAttr) = 0 then
    exit sub
  end if
  if attribs.exists(useAttr) then
    attribs.item(useAttr) = theValue
  else
    attribs.Add  useAttr, thevalue
  end if
end sub
'-------------------------------------------
function dictGet(dict, attrib)
  ' to avoid checking existence when referencing a dict
  dim r
  r = space(0)
  if dict.exists(lcase(attrib)) then
    r = dict.item(attrib)
  end if
  dictGet = r
end function
'-------------------------------------------
Sub startTag(tagName)  ' start an xml tag for sending
   If isBlank(tagName) Then
      sendText = sendText & "<scgui "
   Else
      sendText = sendText & "<" & Trim(tagName)
   End If
End Sub
'-------------------------------------------
Sub sendPair(Attrib, theValue)   ' send a attribute-value pair
   dim useValue
   useValue = Replace(theValue & "","""","`")
   sendText = sendText & Space(1) & Trim(Attrib) & "=" & Chr(34) & useValue & Chr(34)
End Sub
'-------------------------------------------
Sub finishTag(fullClose)   ' close off (see startTag)
   If fullClose Then
      sendText = sendText & "/>" & vbCrLf
   Else
      sendText = sendText & ">" & vbCrLf
   End If
End Sub
'--------------------------------------------
function isBlank(theString)
  isBlank = (len(trim(theString & "")) = 0)
end function
'--------------------------------------------
sub Hout(byval theText)  ' short-cut for annoying OO syntax
  response.write theText
end sub
'------------------------------------------
function contains(byVal inMe, byval findMe)
' case-insensative in-string because instr is ugly and hard to follow
  contains = (instr(1,inMe,findMe,1) > 0)
end function
'------------------------------------------

%>
