
# HTTP communicator util (message to and from polling)
# Build Number: 2

import httplib, urllib, time, sys, os, string

#---------------------------
def main():

   global rootUrl, serverPath
   # get URL path files (from the VB application)
   rootUrl = readFile("serverpath.scg")
   subpath = readFile("subpath.scg")
   print "Looking for: " + rootUrl + subpath

   msg = ""

   print "(ctrl-C to exit)"
   
   while 1:
      if os.path.exists("msg1.dat"):
         msg = trim(readFile("msg1.dat"))
         os.remove     ("msg1.dat")
         print "READ: " + msg
      else:
         msg = ""

      if msg[0:10] == "(**stop**)":
         print "Stop requested."
         sys.exit()
      elif msg[0:7] == "<echo/>":
         print "Echo Command Requested"
         hdata = msg
         #print "Debug: " + hdata
      else:                     # query server
         hdata = httpReader(msg,rootUrl,subpath) 

      hdata = trim(hdata)
      if len(hdata) > 0:
         print "---Got: " + hdata          # tracing info

      # send the received contents
      if len(hdata) > 4:
         while os.path.exists("msg2.dat"):
            # the receiver hasn't picked up prior yet - wait
            print "(waiting for prior message pickup)"
            time.sleep(1)

         f = open("tmp2.tmp","w")
         f.write(hdata)
         f.close()
         # rename to target to avoid locks
         os.rename("tmp2.tmp", "msg2.dat")    
      else:
         print "(No new data rcvd)  (ctrl-C for Exit)"
   
      time.sleep(4)

#-----------------------------
def httpReader(msg, serverpath, subpath):

   h = httplib.HTTP(serverpath, 80)
   # create HTTP (cgi) variables
   params = urllib.urlencode({'scgui': msg, 'protocol': 'scgui'})
   h.putrequest("POST", subpath)
   h.putheader("Content-type", "application/x-www-form-urlencoded")
   h.putheader("Content-length", "%d" % len(params))
   h.putheader('Accept', 'text/plain')
   h.putheader('Host', serverpath)
   h.endheaders()
   h.send(params)
   reply, msg, hdrs = h.getreply()
   if reply != 200:
      print "ERROR: unexpected reply: " + reply
   hdata = h.getfile().read()       # get the raw HTML
   return(hdata)
#---------------------------
def readFile(fileName):       # returns file contents as a string
   f = open(fileName,"r")     # I might later add error handling
   result = f.read()
   f.close()
   return(trim(result))
#---------------------------
def trim(theString):      # shortcut for string.strip() (don't ask)
   return(string.strip(theString))
#---------------------------

main()

# end program 
