$Title problema de transporte

sets
i productores /p1, p2/
j consumidores /m1*m3/;

table d(i,j) distancia en kilometros
         m1      m2      m3
p1       2.0     1.6     1.8
p2       2.5     1.2     1.4;

scalar f costo de transporte /0.09/;

parameters
         a(i) produccion maxima de i
         /p1 300
          p2 500/

         b(j) demanda consumidor j
         /m1 100
          m2 200
          m3 300/

         c(i,j) costo transporte;

c(i,j)= f * d(i,j);

variables
         x(i,j) cantidad transportada entre i y j
         z costo total del transporte;

positive variable x;

equations
         costo           funcion objetivo
         maximo(i)       capacidad maxima productor i
         demanda(j)      demanda consumidor j;


         costo..         z =e= sum((i,j), c(i,j) * x(i,j));
         maximo(i)..     sum(j, x(i,j)) =l= a(i);
         demanda(j)..    sum(i, x(i,j)) =g= b(j);


model transporte /all/;

solve transporte using lp minimizing z;

display x.l;
