% Modelo gravimetrico 2-D
% Esta rutina genera la respuesta gravimetrica de un cuerpo definido
% graficamente con un contraste de densidad dado por el usuario.
% La forma de definir el cuerpo esta hecha de manera que los dos primeros
% puntos marcados quedan en superficie y los siguientes pueden definir la
% geometria del cuerpo en profundidad.
% Para la comparacion de este modelo con datos de terreno se debe generar
% un archivo de extension ".dat" que contenga en su primera columna las
% distancias al primer punto de medicion (x) y en la segunda columna los
% valores de gravedad relativa asociados a cada medida.

clear all;
datosterreno  =load (uigetfile ('*.dat'));
xterreno=datosterreno(:,1);
gterreno=datosterreno(:,2);
g = 0.00667;
rho=input('Densidad (gr/cc) [-0.3] ??');
if(isempty(rho));rho=-0.3; end;

% Definicion de area de trabajo

s0=input('Area de trabajo: x1,y1,x2,y2 (m) [ [0 0 4000 1000] ] ');
if(isempty(s0));s0=[0 0 4000 1000]; end;
xlim(1:2) = s0(1:2:3);
ylim(1:2) = s0(2:2:4);

figure;
axis([xlim(1) xlim(2) -ylim(2) -ylim(1)]);
grid on;
xlabel('x (m)','FontSize',12);
ylabel('profundidad (m)','FontSize',12);
% definicion de vertices. Usar boton izquierdo
% hasta finalizar definicion de cuerpo.
% 

nv = 0;
button = 1;
while button == 1,
   nv=nv+1
   [x(nv),y(nv),button]=ginput(1);
   y(1)=0;
   y(2)=0;
   if nv > 1,
      plot(x,y);
      axis([xlim(1) xlim(2) -ylim(2) -ylim(1)]);
      xlabel('x (m)','FontSize',12);
      ylabel('profundidad (m)','FontSize',12);
      grid on;
   end
end
x(nv) = x(1);
y(nv) = y(1);

plot(x,y);
axis([xlim(1) xlim(2) -ylim(2) -ylim(1)]);
grid on;
xlabel('x (m)','FontSize',12);
ylabel('profundidad (m)','FontSize',12);

npuntos = 100;
xperf   = linspace(xlim(1), xlim(2), npuntos);

for ll=1:npuntos,

      x0  = xperf(ll);
      z0  = 0.0;
      sum = 0;
      x1  =  x(1);
      z1  = -y(1);

      for i=2:nv,
         x2 =  x(i);
         z2 = -y(i);
         [grav] = ribbon_g(x0,z0,x1,z1,x2,z2);
         sum = sum + grav;
         x1  = x2;
         z1  = z2;
      end

      perf(ll)=sum*2*g*rho;

end
   
figure;

subplot(2,1,1),hold on, plot(xperf,perf), plot(xterreno,gterreno,'+r'), hold off;
xlabel('x (m)','FontSize',12);
ylabel('dg (mgal)','FontSize',12);
grid on;

subplot(2,1,2), plot(x,y,'g-');
axis([xlim(1) xlim(2) -ylim(2) -ylim(1)]);
xlabel('x (m)','FontSize',12);
ylabel('profundidad (m)','FontSize',12);
grid on;