% Calcul de FAir theorique selon Hackney et Featherstone 2003
% Lecture du fichier de donnees (station,x,y,h,Fa,T,Lat,Bul,GravAbs2)
% station = nom de station
% x = Coord. E UTM WGS'84
% y = Coord. N UTM WGS'84
% h = Hauteur WGS'84
% Fa = FAir calculee sur Geosoft
% T = Correcion de terrain avec rho=1.0
% Lat = Latitude geographique (GRS80) des stations
% Bul = Correction de Bullard d'apres Geosoft (Lafehr, 1971)
% GravAbs2 = DG(station) par rapport a base de reference
clear all;
Lat=load('latitud.txt');
%size(A);
%A(1,1:9);
%Lat=A(:,7);
% Calcul du gradient de correction de hauteur selon
% l'ellipsoide GRS 80 (en m/s-2)
%
% Valeurs d'apres Moritz (1980), 
% repris par Hackney & Featherstone (GJI 2003)
%
% a est le demi-axe majeur (en m)
a=6378137;
% c est le demi-axe mineur (en m)
c=6356752.3141;
% f est l'aplatissement de l'ellipsoide (a-c)/a
f=0.00335281068118;
% m est le rapport entre la force centrifuge et l'attraction terrestre
% (omega^2.a^2.c/GM)
m=0.00344978600308;
% ge est la pesanteur normale a l'equateur en m/s-2
ge=9.7803267715;
% gp est la pesanteur normale au pole en m/s-2
gp=9.8321863685;
% k
k=0.001931851353;
% e^2 = (a^2-c^2)/a^2
e=0.00669438002290;
% Omega= vitesse angulaire en rd/s
om=7292115e-011;
% GM constante gravitationnelle geocentrique
GM=3986005e008;
% Latitude geodesique
% phig=23.315454;
phi=atan((c./a).^2.*tan(Lat.*pi/180));
% phi=atan((c./a).^2.*tan(phig*pi/180));
Lat2=phi.*180/pi;
% La correction de hauteur provient de la premiere derivee
% de dg/dh avec g la pesanteur normale sur la surface d'un ellipsoide
% de reference geocentrique
gtheo=ge.*((1.+k.*sin(phi).^2)./(sqrt(1.-e.*sin(phi).^2)));
%sinus=sin(phi).^2; fac=2.5.*m-3.*f;
% Coefficients en m/s^2
%alpha=-2.*(ge./a).*(1+f+m+fac.*sinus);
%beta=3*ge/a^2;
%alpha2=alpha./1e-005;
%beta2=beta./1e-005;
% h= hauteur ellipsoidale
%h=A(:,4);
%a1=alpha2.*h;
%a2=beta2*h.^2;
%dgdh=a1+a2;
% % FAir classique 0.3086.h
% Fair=0.3086.*h;
% FAir Geosoft
% Fair=A(:,5);
% size(Fair);
% Diff=Fair+dgdh;
%Gabs=A(:,9);
%Fa=Gabs-gtheo-dgdh;
% FA1=A(:,5);
% Grav=FA1-Fair;
 %B0=[A(:,2)'; A(:,3)'; Fa'; A(:,4)'; A(:,6)'; A(:,8)'; A(:,1)']; size(B0);
 %B=B0'; size(B);
% Sauvegarde
 %save('Fin_Vn5_m.dat','B','-ASCII');
% save('Residus_m.dat','B', '-ASCII','-DOUBLE','-TABS');