%    Se resuelve el proceso de planificacion de un sistema elctrico
%    Formato  R. Palma, Apuntes EM735
%    Se analizan TRES centrales, TRES bloques
%    Se IMPONE que la central 3 genere una cantidad minima
%    Marcelo Cortes C.  
%    Ultima revision 06-09-2006
%    Min {Z = Costo Inversion + Costo Operacion}
%    Min {Z = (a1*C1 + a2*C2 + a3*C3) + [b1*(G11*N1 + G12*N2 + G13*N3) + 
%             + b2+(G21*N1 + G22*N2 + G23*N3) + b3+(G31*N1 + G32*N2 + G33*N3)]}
%    s.a.:
%    C1 + C2 + C3 >= Dmax
%    G11*N1 + G21*N1 + G31*N1 >= D1*N1
%    G12*N2 + G22*N2 + G32*N2 >= D2*N2
%    G13*N3 + G23*N3 + G33*N3 >= D3*N3
%    C1 - G11 >= 0
%    C1 - G12 >= 0
%    C1 - G13 >= 0
%    C2 - G21 >= 0
%    C2 - G22 >= 0
%    C2 - G23 >= 0
%    C3 - G31 >= 0
%    C3 - G32 >= 0
%    C3 - G33 >= 0
%    C3       >= alfa*Dmax
%    C1, C2, C3, G11, G12, G13, G21, G22, G23, G31, G32, G33 >= 0
%    Marcelo Corts C.
%    03-09-2006
%    =====================================================================
     clc; clear;
%    Datos
     r = 10;                         % tasa de descuento en %
     n = 30;                         % vida util proyecto en aos
     frc = (r*0.01)/(1-(1/(1+r*0.01)^n));   % factor de recuperacion del capital
     a1 = 1000;                      % Costo de inversion central 1 USS/kW
     a2 = 300;                       % Costo de inversion central 2 USS/kW
     a3 = 1500;                      % Costo de inversion central 3 USS/kW
     b1 = 5;                         % Costo operacion centra 1 USS/MWh
     b2 = 40;                        % Costo operacion centra 2 USS/MWh
     b3 = 0.1;                       % Costo operacion centra 2 USS/MWh
     D1 = 1000;                      % Altura primer bloque de curva de duracion
     N1 = 760;                       % N de horas primer bloque 
     N1 = 2121;                      % N de horas primer bloque (2121 optimo)
     D2 = 700;                       % Altura segundo bloque de curva de duracion
     N2 = 4000;                      % N de horas segundo bloque 
     D3 = 300;                       % Altura tercer bloque de curva de duracion
     N3 = 8760-N1-N2;                % N de horas tercer bloque 
     Dmax = D1*1.000;                % demanda mxima MW
     alfa = 0.15;                    % Porcentaje minimo que centra 3 debe generar
%    =====================================================================
%    Anualizaciones de los costos de inversion
     a1 = 1000*a1*frc;      % USS/MW anuales
     a2 = 1000*a2*frc;      % USS/MW anuales
     a3 = 1000*a3*frc;      % USS/MW anuales
%    Define funcion de costo     
     c = [a1 a2 a3 b1*N1 b1*N2 b1*N3 b2*N1 b2*N2 b2*N3 b3*N1 b3*N2 b3*N3];
%           C1 C2  C3 G11 G12 G13 G21 G22 G23 G31 G32 G33
     A = - [ 1  1   1   0   0   0   0   0   0   0   0   0;
             0  0   0  N1   0   0  N1   0   0  N1   0   0;
             0  0   0   0  N2   0   0  N2   0   0  N2   0;
             0  0   0   0   0  N3   0   0  N3   0   0  N3;
             1  0   0  -1   0   0   0   0   0   0   0   0;
             1  0   0   0  -1   0   0   0   0   0   0   0;
             1  0   0   0   0  -1   0   0   0   0   0   0;
             0  1   0   0   0   0  -1   0   0   0   0   0;
             0  1   0   0   0   0   0  -1   0   0   0   0;
             0  1   0   0   0   0   0   0  -1   0   0   0;
             0  0   1   0   0   0   0   0   0  -1   0   0;
             0  0   1   0   0   0   0   0   0   0  -1   0;
             0  0   1   0   0   0   0   0   0   0   0  -1;
             0  0   1   0   0   0   0   0   0   0   0   0];
     b =  -[Dmax D1*N1 D2*N2 D3*N3 0  0  0  0  0  0  0  0  0 alfa*Dmax];
     Min = [0 0 0 0 0 0 0 0 0 0 0 0];
     Max = [Dmax Dmax Dmax Dmax D2 D3 Dmax D2 D3 Dmax D2 D3];
     options = optimset('LargeScale', 'off', 'Simplex', 'on');
     [x, fval, exitflag, output, Lambda] = linprog(c, A, b, [], [], Min, [], [], options);
     Lam = [Lambda.ineqlin];
     PID = fopen('RPlan_Cen3C3B_I.res','w+');     
     fprintf(PID,'\n RESULTADOS DE PLANIFICACION DE PARQUE GENERADOR \n');
     fprintf(PID,' CASO : IMPONE GENERACION MINIMA A CENTRAL 3 \n');
     fprintf(PID,' =============================================== \n\n');
     fprintf(PID,'\n ANTECEDENTES GENERALES \n');
     fprintf(PID,' Costo de inversin anual central 1              : %8.2f U$$/MW \n', a1);
     fprintf(PID,' Costo de operacin central 1                    : %8.2f U$$/MWh \n', b1);
     fprintf(PID,' Costo de inversin anual central 2              : %8.2f U$$/MW \n', a2);
     fprintf(PID,' Costo de operacin central 2                    : %8.2f U$$/MWh \n', b2);
     fprintf(PID,' Costo de inversin anual central 3              : %8.2f U$$/MW \n', a3);
     fprintf(PID,' Costo de operacin central 3                    : %8.2f U$$/MWh \n', b3);
     fprintf(PID,' Demanda Mxima                                  : %8.2f MW \n', Dmax);
     fprintf(PID,' Demanda del bloque 1                            : %8.2f MW \n', D1);
     fprintf(PID,' Duracin del bloque 1                           : %8.2f Hr \n', N1);
     fprintf(PID,' Demanda del bloque 2                            : %8.2f MW \n', D2);
     fprintf(PID,' Duracin del bloque 2                           : %8.2f Hr \n', N2);
     fprintf(PID,' Demanda del bloque 3                            : %8.2f MW \n', D3);
     fprintf(PID,' Duracin del bloque 3                           : %8.2f Hr \n', N3);
     fprintf(PID,'\n RESULTADOS DE LA OPTIMIZACION \n');
     fprintf(PID,' Capacidad central 1                             : %8.2f MW \n', x(1));
     fprintf(PID,' Capacidad central 2                             : %8.2f MW \n', x(2));
     fprintf(PID,' Capacidad central 3                             : %8.2f MW \n', x(3));
     fprintf(PID,' Potencia Generada por central 1 en bloque 1     : %8.2f MW \n', x(4));
     fprintf(PID,' Potencia Generada por central 1 en bloque 2     : %8.2f MW \n', x(5));
     fprintf(PID,' Potencia Generada por central 1 en bloque 3     : %8.2f MW \n', x(6));
     fprintf(PID,' Potencia Generada por central 2 en bloque 1     : %8.2f MW \n', x(7));
     fprintf(PID,' Potencia Generada por central 2 en bloque 2     : %8.2f MW \n', x(8));
     fprintf(PID,' Potencia Generada por central 2 en bloque 3     : %8.2f MW \n', x(9));
     fprintf(PID,' Potencia Generada por central 3 en bloque 1     : %8.2f MW \n', x(10));
     fprintf(PID,' Potencia Generada por central 3 en bloque 2     : %8.2f MW \n', x(11));
     fprintf(PID,' Potencia Generada por central 3 en bloque 3     : %8.2f MW \n', x(12));
     fprintf(PID,' Precio dual para Dmax                           : %8.2f US$/MW \n', Lam(1));
     fprintf(PID,' Precio dual para Energa bloque 1               : %8.2f US$/MWh \n', Lam(2));
     fprintf(PID,' Precio dual para Energa bloque 2               : %8.2f US$/MWh \n', Lam(3));
     fprintf(PID,' Precio dual para Energa bloque 3               : %8.2f US$/MWh \n', Lam(4));
     fprintf(PID,' Precio dual para alfa*Dmax                      : %8.2f US$/MWh \n', Lam(14));
     fprintf(PID,'\n BALANCE DE COSTOS \n');
     fprintf(PID,' =============================================== \n\n');
     CAIC1 = a1*x(1)/1e6;
     CAOC1 = b1*(x(4)*N1 + x(5)*N2 + x(6)*N3)/1e6;
     CAIOC1 = CAIC1 + CAOC1;
     CAIC2 = a2*x(2)/1e6;
     CAOC2 = b2*(x(7)*N1 + x(8)*N2 + x(9)*N3)/1e6;
     CAIOC2 = CAIC2 + CAOC2;
     CAIC3 = a3*x(3)/1e6;
     CAOC3 = b3*(x(10)*N1 + x(11)*N2 + x(12)*N3)/1e6;
     CAIOC3 = CAIC3 + CAOC3;
     CAI = CAIC1 + CAIC2 + CAIC3;
     CAO = CAOC1 + CAOC2 + CAOC3;
     CAIO = CAI + CAO;
     fprintf(PID,' Costo Anual de Inversin Central 1              : %8.3f MMUS$ \n', CAIC1);
     fprintf(PID,' Costo Anual de Operacin Central 1              : %8.3f MMUS$ \n', CAOC1);
     fprintf(PID,' Costo Anual de Inversin y Operacin Central 1  : %8.3f MMUS$ \n', CAIOC1);
     fprintf(PID,' Costo Anual de Inversin Central 2              : %8.3f MMUS$ \n', CAIC2);
     fprintf(PID,' Costo Anual de Operacin Central 2              : %8.3f MMUS$ \n', CAOC2);
     fprintf(PID,' Costo Anual de Inversin y Operacin Central 2  : %8.3f MMUS$ \n', CAIOC2);
     fprintf(PID,' Costo Anual de Inversin Central 3              : %8.3f MMUS$ \n', CAIC3);
     fprintf(PID,' Costo Anual de Operacin Central 3              : %8.3f MMUS$ \n', CAOC3);
     fprintf(PID,' Costo Anual de Inversin y Operacin Central 3  : %8.3f MMUS$ \n', CAIOC3);
     fprintf(PID,' Costo Total de Inversin del Parque             : %8.3f MMUS$ \n', CAI);
     fprintf(PID,' Costo Total de Operacin Parque                 : %8.3f MMUS$ \n', CAO);
     fprintf(PID,' Costo Total de Inversin y Operacin Parque     : %8.3f MMUS$ \n', CAIO);
     fprintf(PID,'\n BALANCE DE INGRESOS A TARIFAS MARGINALES \n');
     fprintf(PID,' =============================================== \n\n');
     IAPC1 = Lam(1)*x(1)/1e6;
     IAEC1 = (x(4)*N1*Lam(2) + x(5)*N2*Lam(3) + x(6)*N3*Lam(4))/1e6;
     IAPEC1 = (IAPC1 + IAEC1);
     IAPC2 = Lam(1)*x(2)/1e6;
     IAEC2 = (x(7)*N1*Lam(2) + x(8)*N2*Lam(3) + x(9)*N3*Lam(4))/1e6;
     IAPEC2 = (IAPC2 + IAEC2);
     IAPC3 = Lam(1)*x(3)/1e6;
     IAEC3 = (x(10)*N1*Lam(2) + x(11)*N2*Lam(3) + x(12)*N3*Lam(4))/1e6;
     IAPEC3 = (IAPC3 + IAEC3);
     IAP = (Lam(1)*(x(1)+x(2)+x(3)))/1e6;
     IAE = (Lam(2)*D1*N1 + Lam(3)*D2*N2 + Lam(4)*D3*N3)/1e6;
     IAPE = (IAP + IAE);
     fprintf(PID,' Ingreso Anual por potencia Central 1            : %8.3f MMUS$ \n', IAPC1);
     fprintf(PID,' Ingreso Anual por energa Central 1             : %8.3f MMUS$ \n', IAEC1);
     fprintf(PID,' Ingreso Anual por potencia y energa Central 1  : %8.3f MMUS$ \n', IAPEC1);
     fprintf(PID,' Ingreso Anual por potencia Central 2            : %8.3f MMUS$ \n', IAPC2);
     fprintf(PID,' Ingreso Anual por energa Central 2             : %8.3f MMUS$ \n', IAEC2);
     fprintf(PID,' Ingreso Anual por potencia y energa Central 2  : %8.3f MMUS$ \n', IAPEC2);
     fprintf(PID,' Ingreso Anual por potencia Central 3            : %8.3f MMUS$ \n', IAPC3);
     fprintf(PID,' Ingreso Anual por energa Central 3             : %8.3f MMUS$ \n', IAEC3);
     fprintf(PID,' Ingreso Anual por potencia y energa Central 3  : %8.3f MMUS$ \n', IAPEC3);
     fprintf(PID,' Ingreso Anual por potencia Parque               : %8.3f MMUS$ \n', IAP);
     fprintf(PID,' Ingreso Anual por energa parque                : %8.3f MMUS$ \n', IAE);
     fprintf(PID,' Ingreso Anual por potencia y energa Parque     : %8.3f MMUS$ \n', IAPE);
     fclose(PID);
     