#include <GL/glut.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <stdio.h>
#include <math.h>
#include <unistd.h>     // Header File For sleeping.

#include "esfera.h"
#define NOMBRE "Clase 4"

/* ASCII code for the escape key. */
#define ESCAPE 27
#define PAGE_UP 73
#define PAGE_DOWN 81
#define UP_ARROW 72
#define DOWN_ARROW 80
#define LEFT_ARROW 75
#define RIGHT_ARROW 77

/* The number of our GLUT window */
int window;


/* Variables para nuestra cámara */
GLfloat posicion_x, posicion_y, posicion_z;
GLfloat angulo_x, angulo_y, angulo_z;

/* variables para los planetas */
GLfloat angulo_tierra, angulo_luna;
 
/* nuestra esferita amiga */
Esfera *esfera;

/* para la luz */
GLfloat LightAmbient[]= { 0.1f, 0.1f, 0.1f, 1.0f }; 				// Ambient Light Values ( NEW )
GLfloat LightDiffuse[]= {0.7f, 0.7f, 0.7f, 1.0f };	
GLfloat LightPosition[]= { 0.0f, 0.0f, 0.0f, 1.0f };
GLfloat LightSpecular[] = { 0.3f, 0.3f, 0.3f, 1.0f};	
GLfloat LightDirection[] = { 0.0f, 0.0f, -1.0f, 0.0f };
GLfloat angle[] = { 180.0f };

/* para el material */

GLfloat mat_specular[] = { 0.0f, 0.0f, 0.0f, 1.0f };
GLfloat mat_shininess[] = { 1.0f };

/* colores */

GLfloat rojo[] = { 1.0f, 0.0f, 0.0f, 1.0f };
GLfloat verde[] = { 0.0f, 1.0f, 0.0f, 1.0f};
GLfloat azul[] = { 0.0f,0.0f, 1.0f, 1.0f};
GLfloat gris[] = { 0.4f,0.4f, 0.4f, 1.0f};
GLfloat blanco[] = { 1.0f,1.0f, 1.0f, 1.0f};
/* No tocar. */

void destroyGL(GLvoid)
{
    delete esfera; 
};

/* The function called when our window is resized (which shouldn't happen, because we're fullscreen) */
void ReSizeGLScene(int width, int height)
{
	if (height==0)										// Prevent A Divide By Zero By
	{
		height=1;										// Making Height Equal One
	}

	glViewport(0,0,width,height);						// Reset The Current Viewport

	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glLoadIdentity();									// Reset The Projection Matrix

	// Calculate The Aspect Ratio Of The Window
	gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,0.1f,300.0f);

	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glLoadIdentity();									// Reset The Modelview Matrix
};

void update()
{	   
	   /* además variables que cambian siempre */
	   
	   angulo_tierra += 0.4f;
	   angulo_luna += 1.2f;
};

void dibujaPlaneta(GLfloat distancia, GLfloat angulo, GLfloat proporcion, GLfloat* color, int luna)
{
	glPushMatrix();
	glRotatef(angulo, 0.0f, 0.0f, 1.0f); // se rota en torno al eje z
	glTranslatef(distancia, 0.0, 0.0);
	
    glPushMatrix();    	
	  glScalef(proporcion, proporcion, proporcion); 
      esfera->graficarLista(color); // el planeta
    glPopMatrix();
    
    // ¿ por qué tuvimos que aplicar push/pop para escalar la esfera?
    // ¿ no bastaba con aplicarla una vez?
    
	if (luna > 0)
	{
		dibujaPlaneta(2.0f, angulo_luna, 0.1f, gris, luna - 1);
	}

    glPopMatrix();
};

void DrawGLScene()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear Screen And Depth Buffer
	glLoadIdentity();									// Reset The Current Modelview Matrix 
    
    /* movemos nuestro sistema de coordenadas para ubicar nuestra cámara */ 
    glTranslatef(posicion_x,posicion_y,posicion_z);
	glRotatef(angulo_x, 0.0f, 0.0f, -1.0f);
	glRotatef(angulo_z, 0.0f, -1.0f, 0.0f);
	glRotatef(angulo_y, -1.0f, 0.0f, 0.0f);

	/* OJO: tenemos la posición de la luz pero en coordenadas de la escena, y la requerimos
	 * respecto a nuestra vista. Debido a esto la posición de la luz debe actualizarse
	 * cada vez que se dibuja, para que se le aplique la matriz de transformación de cámara
	 * al igual que a todo lo que se dibuja. */
	
	glColor4fv(verde);
	glPointSize(10.0f);
	glBegin(GL_POINTS);
		glVertex4fv(LightPosition);
	glEnd();
    glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);
	glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
    glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
 
	/* SOL */    
    glDisable(GL_LIGHTING);
	glColor4fv(blanco);
	esfera->graficarLista(blanco); // ¿ por qué lo hacemos así? ¿existe otro método alternativo?
	// ¿por qué tuve que llamar a glColor? //
	glEnable(GL_LIGHTING);
	
	/* TIERRA */
    dibujaPlaneta(10.0f, angulo_tierra, 0.25f, azul, 3);

	/* MARTE */
	dibujaPlaneta(15.0f, angulo_tierra*2.0f, 0.15f, rojo, 0);

	/* Actualización de variables */
    update();

	/* Se utilizan dos buffers. La idea es ir intercambiándolos con el fin de hacer más
	 * rápido el proceso de dibujado (y no tener que dibujar uno y luego dibujar 
	 * inmediatamente encima */
	glutSwapBuffers();
}


void InitGL()          // We call this right after our OpenGL window is created.
{
    /* no tocar esta parte */
	glShadeModel(GL_SMOOTH);							// Enable Smooth Shading
	glClearColor(0.0f, 0.0f, 0.3f, 1.0f);				// Black Background
	glClearDepth(1.0f);									// Depth Buffer Setup
	glEnable(GL_DEPTH_TEST);							// Enables Depth Testing
	glDepthFunc(GL_LEQUAL);								// The Type Of Depth Testing To Do
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Really Nice Perspective Calculations
	/* fin del no tocar */
	
	/* luz */
	
	glLightfv(GL_LIGHT1, GL_SPECULAR, LightSpecular);
    glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);				// Setup The Ambient Light
    glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);				// Setup The Diffuse Light
    glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);			// Position The Light
    glLightfv(GL_LIGHT1, GL_SPOT_CUTOFF, angle);
    glLightfv(GL_LIGHT1, GL_SPOT_DIRECTION, LightDirection);
    
    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT1);	

	/* aquí inicializan sus variables. por supuesto que deben ser globales. */
	
	/* nuestra esfera */
    esfera = new Esfera(5.0f,32);

    /* cámara */
    posicion_x = posicion_y = posicion_z = angulo_x = angulo_y = angulo_z = 0.0f;
    posicion_z = -40.0f;	
    angulo_x = 0.0f;
    angulo_z = 0.0f;
    
    /* ángulos del planeta y de la luna */
    angulo_tierra = 0.0;
    angulo_luna = 0.0;
}

void keyPressed(unsigned char key, int x, int y)
{
	/* sleep to avoid thrashing this procedure */
//	usleep(100);

	/* If escape is pressed, kill everything. */
	if (key == ESCAPE)
	{
		/* shut down our window */
		glutDestroyWindow(window);
		destroyGL();
		/* exit the program...normal termination. */
		exit(0);
	}
	if (key == 'D') posicion_x -= 1.5f;
    if (key == 'A') posicion_x += 1.5f;
    if (key == 'W') posicion_y -= 1.5f;
    if (key == 'X') posicion_y += 1.5f;
	if (key == 'E') posicion_z -= 1.5f;
	if (key == 'Z') posicion_z += 1.5f;
	if (key == 'S') { posicion_x = 0.0f; posicion_y = 0.0f; posicion_z = -40.0f; }
	if (key == 'F') angulo_x -= 1.5f;
	if (key == 'H') angulo_x += 1.5f;
	if (key == 'T') angulo_y -= 1.5f;
	if (key == 'B') angulo_y += 1.5f;
	if (key == 'Y') angulo_z -= 1.5f;
    if (key == 'V') angulo_z += 1.5f;
	if (key == 'G') { angulo_x = 0.0f; angulo_y = 0.0f; angulo_z = 0.0f; }   
	if (key == 'I') LightPosition[0] += 1.5f;
	if (key == 'K') LightPosition[0] -= 1.5f;
	if (key == 'J') LightPosition[1] += 1.5f;
	if (key == 'L') LightPosition[1] -= 1.5f;
	if (key == 'O') LightPosition[2] += 1.5f;
	if (key == 'M') LightPosition[2] -= 1.5f;
	
}
/* The function called whenever a normal key is pressed. */
void specialKeyPressed(int key, int x, int y)
{

	/* avoid thrashing this procedure */
	//usleep(100);
	switch (key) {
		case GLUT_KEY_PAGE_UP:
			break;
		case GLUT_KEY_PAGE_DOWN:
			break;
		case GLUT_KEY_UP:
			mat_shininess[0] += 0.1f;
			break;
		case GLUT_KEY_DOWN:
			if (mat_shininess[0] > 0.0) mat_shininess[0] -= 0.1f;
			break;
		case GLUT_KEY_LEFT:
			if (mat_specular[0] < 1.0)
			{
				mat_specular[0] += 0.1f;
				mat_specular[1] += 0.1f;
				mat_specular[2] += 0.1f;
			}
			break;
		case GLUT_KEY_RIGHT: 
			if (mat_specular[0] > 0.0)
			{
				mat_specular[0] -= 0.1f;
				mat_specular[1] -= 0.1f;
				mat_specular[2] -= 0.1f;
			}
			break;
		default:
			break;
	}
}

int main(int argc, char **argv)
{
  /* Initialize GLUT state - glut will take any command line arguments that pertain to it or 
     X Windows - look at its documentation at http://reality.sgi.com/mjk/spec3/spec3.html */
  glutInit(&argc, argv);

  /* Select type of Display mode:   
     Double buffer 
     RGBA color
     Alpha components supported 
     Depth buffer */
  glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_ALPHA | GLUT_DEPTH);

  /* get a 640 x 480 window */
  glutInitWindowSize(640, 480);

  /* the window starts at the upper left corner of the screen */
  glutInitWindowPosition(0, 0);

  /* Open a window */
  window = glutCreateWindow(NOMBRE);

  /* Register the function to do all our OpenGL drawing. */
  glutDisplayFunc(&DrawGLScene);

  /* Go fullscreen.  This is as soon as possible. */
  //glutFullScreen();

  /* Even if there are no events, redraw our gl scene. */
  glutIdleFunc(&DrawGLScene);

  /* Register the function called when our window is resized. */
  glutReshapeFunc(&ReSizeGLScene);

  /* Register the function called when the keyboard is pressed. */
  glutKeyboardFunc(&keyPressed);
	/* Register the function called when special keys (arrows, page down, etc) are pressed. */
	glutSpecialFunc(&specialKeyPressed);
			
  /* Initialize our window. */
  InitGL();

							
  /* Start Event Processing Engine */
  glutMainLoop(); 
  return 1;

}

