#ifndef ESFERA
#define ESFERA 1

#include <GL/gl.h>			// Header File For The OpenGL32 Library
#include <GL/glu.h>			// Header File For The GLu32 Library
#include <list>
#include <cmath>

#include "cara.h"

using namespace std;


class Esfera 
{
	
	private:
	list<Cara *> caras;
	float radio;
	int division;
	GLuint id_lista;

	public:
	Esfera(){ radio = 0.0; division = 0; };
	Esfera(float r, int detalle)
	{
		radio = r;
		division = detalle;

		Cara *tmp;
		Vertice *polo_norte, *polo_sur;
		Vertice *v1, *v2, *v3, *v4;
		polo_norte = new Vertice(0.0, 0.0, radio);
		polo_norte->setNorm(0.0,0.0,1.0);
		polo_sur = new Vertice(0.0, 0.0, -radio);
		polo_sur->setNorm(0.0,0.0,-1.0);
		float deltap = 2.0f*3.1415f/division;
		float deltat = 3.1415f/division;
		float teta = 3.1415f/2.0f;
		float phi = 0.0f;
		float x, y, z, norma;
		for (int i = 0; i < division; i++)
		{
			teta -= deltat;
			for (int j = 0; j < division; j++)
			{
				tmp = new Cara();
				
				if (i == 0)
				{ // todas las caras utilizan el polo norte
                    x = radio*cos(teta)*cos(phi); y = radio*cos(teta)*sin(phi); z = radio*sin(teta);
                    norma = 1.0/sqrt(x*x + y*y + z*z);
					v1 = new Vertice(x, y, z);
					v1->setNorm(x*norma, y*norma, z*norma);
					
					x = radio*cos(teta)*cos(phi+deltap); y = radio*cos(teta)*sin(phi+deltap); z = radio*sin(teta);
					norma = 1.0/sqrt(x*x + y*y + z*z);
					v2 = new Vertice(x, y, z);
					v2->setNorm(x*norma, y*norma, z*norma);
					
					tmp->agregarVertice(polo_norte);
					//tmp->agregarVertice(polo_norte);
					tmp->agregarVertice(v2);
					tmp->agregarVertice(v1);
					caras.push_back(tmp);
				}
				else if (i == (division-1))
				{ 
                    x = radio*cos(teta-deltat)*cos(phi); y = radio*cos(teta-deltat)*sin(phi); z = radio*sin(teta-deltat);
					v1 = new Vertice(x, y , z);
					norma = 1.0/sqrt(x*x + y*y + z*z);
					v1->setNorm(x*norma, y*norma, z*norma);
					
					x = radio*cos(teta-deltat)*cos(phi+deltap); y = radio*cos(teta-deltat)*sin(phi+deltap); z =  radio*sin(teta-deltat);
					v2 = new Vertice(x, y, z);
					norma = 1.0/sqrt(x*x + y*y + z*z);
					v2->setNorm(x*norma, y*norma, z*norma);
					
					tmp->agregarVertice(polo_sur);
					//tmp->agregarVertice(polo_sur);
					tmp->agregarVertice(v1);
					tmp->agregarVertice(v2);
					caras.push_back(tmp);		
				}
				else
				{ 
                    x = radio*cos(teta)*cos(phi); y = radio*cos(teta)*sin(phi); z = radio*sin(teta);
					v1 = new Vertice(x, y, z);
					norma = 1.0/sqrt(x*x + y*y + z*z);
					v1->setNorm(x*norma, y*norma, z*norma);
					
					x = radio*cos(teta)*cos(phi+deltap); y = radio*cos(teta)*sin(phi+deltap); z = radio*sin(teta);
                    v2 = new Vertice(x, y, z);
                    norma = 1.0/sqrt(x*x + y*y + z*z);
					v2->setNorm(x*norma, y*norma, z*norma);
					
                    x = radio*cos(teta+deltat)*cos(phi+deltap); y = radio*cos(teta+deltat)*sin(phi+deltap); z = radio*sin(teta+deltat);
                    v3 = new Vertice(x, y, z);
                    norma = 1.0/sqrt(x*x + y*y + z*z);
					v3->setNorm(x*norma, y*norma, z*norma);
					
					x = radio*cos(teta+deltat)*cos(phi); y = radio*cos(teta+deltat)*sin(phi); z = radio*sin(teta+deltat);
                    v4 = new Vertice(x, y, z);
                    norma = 1.0/sqrt(x*x + y*y + z*z);
					v4->setNorm(x*norma, y*norma, z*norma);
					
                    tmp->agregarVertice(v1);
					tmp->agregarVertice(v2);
					tmp->agregarVertice(v3);
					tmp->agregarVertice(v4);
					caras.push_back(tmp);		
				}
				phi += deltap;

			}

		} // end for
		/* creamos nuestra lista */
		id_lista = glGenLists(1);
		glNewList(id_lista, GL_COMPILE);
		this->graficar();
        glEndList();
		
	};
	void graficar(/*GLfloat *color*/)
	{
			list<Cara *>::iterator iterador;
			//glMaterialfv(GL_FRONT, GL_DIFFUSE, color);
			for (iterador = caras.begin(); iterador != caras.end(); iterador++)
				(*iterador)->graficar();
	};
	void graficarLista(GLfloat *color)
	{
            glMaterialfv(GL_FRONT, GL_DIFFUSE, color);
			glCallList(id_lista);
	}
	~Esfera()
	{
			list<Cara *>::iterator iterador;
			for (iterador = caras.begin(); iterador != caras.end(); iterador++)
				delete *iterador;
	}
};

#endif
