<?

/** Clase que maneja la conexin y consultas a la base de datos. Debe ser
 *  extendida para cada base de datos
 * @version     Workflow Asistente 1.0: BaseDatos.php
 */

class BaseDatos {

	var $conexion;
	var $host;
	var $usuario;
	var $password;
	var $bd;

	/** Constructor, setea los parmetros de conexin
	 * @param       string $host
	 * @param       string $usuario
	 * @param       string $password
 	 * @param       string $bd
	 * @return      object BaseDatos
	 */
	function BaseDatos($host, $usuario, $password="", $bd) {
		$this->host=$host;
		$this->usuario=$usuario;
		$this->password=$password;
		$this->bd=$bd;
	}

	/** Ejecuta una consulta y devuelve un cursor con el resultado
	 * @param       string $sql - consulta
	 * @return      int - identificador de resultado
	 */
	function consultar($sql) {
		$this->conectar();
		return mysql_query ($sql, $this->conexion);
	}

	/** Indica la cantidad de filas del resultado de una consulta
	 * @param       int $res - identificador de resultado
	 * @return      int - nmero de filas del resultado de la consulta
	 */
	function cantidad($res) {
  		return mysql_num_rows ($res);
	}

	/** Indica la cantidad de filas afectadas por una consulta
	 * @param       int $res - identificador de resultado
	 * @return      int - nmero de filas afectadas
	 */
	function afectadas() {
  		return mysql_affected_rows($this->conexion);
	}

	/** Devuelve el ltimo id autonumrico insertado en la base de datos
	 * @return      int - ltimo id insertado
	 */
	function getInsertId(){
		return mysql_insert_id($this->conexion);
	}

	/** Devuelve un arreglo con una fila del resultado de una consulta (un arreglo asociativo
	 *  con los nombres y nmeros de campo como llaves (cada campo aparece dos veces)
	 * @param		int $res - identificador de resultado
	 * @return 		array - arreglo asociativo con la fila de la consutla
	 */
	function resultado($res) {
  		return mysql_fetch_array($res);
	}

	/** Libera una consulta
	 * @param		int $res - identificador de resultado
	 */
	function liberarConsulta ($res) {
  		mysql_free_result ($res);
	}

	/** Cierra la base de datos
	 * @return		boolean - verdadero si hubo xito, falso si no
	 */
	function cerrarBD(){
		if($this->ping()){
	  		return mysql_close($this->conexion);
		}
	}

	/** Chequea si la conexin con la base de datos est abierta
	 * @return		boolean - verdadero si est conectado, falso si no
	 */
	function ping(){
		if(!@mysql_select_db($this->bd,$this->conexion)){
			return false;
		}
		return true;
	}

	/** Establece la conexin a la base de datos
	 */
	function conectar(){
		if(!$this->ping()){
			$this->conexion = mysql_connect ($this->host, $this->usuario, $this->password);
			if($this->conexion){
				$ele = mysql_select_db ($this->bd, $this->conexion);
				if (!$ele){
					trigger_error("No se pudo conectar");
				}
			}
		}
	}

	/** Devuelve un string con una funcin SQL para entregar una fecha
	 *  formateada en dd-mm-yyyy
	 * @param		string $campo - nombre del campo a formatear
 	 * @return		string  - funcin de formateo de fecha
	 */
	function bdfecha($campo) {
  		return "date_format($campo, '%d-%m-%Y')";
	}

}
?>
