import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class Problema1 extends Frame implements ActionListener{

	Button ordenarTiempo,ordenarNombre,examinar,abrir;
	ScrollPane lista;
	TextField ruta;
	Label info;
	
	String[] atletas;
	int[] tiempos;
	
	
	public Problema1(){
		
		super("Ordenador");
		
		//para cerrar ventana con X
	    this.addWindowListener(new WindowAdapter(){ 
	        public void windowClosing(WindowEvent e) { 
	          setVisible(false);
	          dispose(); 
	          System.exit(0); 
	        }
	    } );
	    
	    //armo la interfaz
	    
	    Panel pnorth = new Panel();
	    Panel cargaArchivo = new Panel();
	    Panel botones = new Panel();
	    
	    cargaArchivo.setLayout(new GridBagLayout());
	
		setLayout(new BorderLayout());
		
		examinar = new Button("Examinar...");
		examinar.addActionListener(this);
		cargaArchivo.add(examinar);
		
		ruta = new TextField(60);
		cargaArchivo.add(ruta);
		
		abrir = new Button("Abrir");
		abrir.addActionListener(this);
		cargaArchivo.add(abrir);
		
		botones = new Panel();
		botones.setLayout(new GridLayout(1,2));
		
		ordenarNombre = new Button("Nombre");
		ordenarNombre.addActionListener(this);
		botones.add(ordenarNombre);
		
		ordenarTiempo = new Button("Tiempo");
		ordenarTiempo.addActionListener(this);
		botones.add(ordenarTiempo);
		
		pnorth.setLayout(new GridLayout(2,1));
		pnorth.add(cargaArchivo);
		pnorth.add(botones);
		
		add(pnorth,"North");
		
		
		//inicio listas para ordenar
		atletas = new String[0];
		tiempos = new int[0];
		lista = new ScrollPane();
		add(lista, "Center");
		
		info = new Label("");
		add(info,"South");
		
		setSize(560,600);
		
		setVisible(true);
	}
	
	public static void main(String[] args) {
		new Problema1();
		
	}

	public void actionPerformed(ActionEvent e) {
		
		if(e.getSource()== examinar){
			
			//abro ventana para obtener archivo
			FileDialog fd = new FileDialog(new Frame(), "Abrir Archivo...", FileDialog.LOAD);
			       fd.setVisible(true);
			       if ( fd.getFile() != null )
			       {			       
			         String path=fd.getDirectory() + fd.getFile();
			         
			         //dejo la ruta en el textfield de la ventana principal
			         ruta.setText(path);
			       } 
		}
		
		else if(e.getSource()== abrir){
			abrirArchivo();
		}
		else if(e.getSource()== ordenarNombre){
			ordenarPorNombre(atletas, tiempos, 0, atletas.length -1);
			mostrarListas();
			info.setText("Ordenado por Nombre de atleta");
		}
		else if(e.getSource()== ordenarTiempo){
			ordenarPorTiempo(atletas, tiempos, 0, atletas.length-1);
			mostrarListas();
			info.setText("Ordenado por Tiempo de atleta");
		}
			
		
	}

	static private void ordenarPorNombre(String[] atletas, int[] tiempos, int desde, int hasta) {
		//quickSort recursivo
		
		//caso base
		if(desde >= hasta)
			return;
		
		String guia = atletas[desde];
		
		int indi = desde+1;
		for(int i = desde +1; i <= hasta ; i++){
			if(guia.compareTo(atletas[i]) > 0){
				//intercambio valores
				intercambiar(atletas,tiempos, indi, i);
				indi++;
			}	
		}
		
		intercambiar(atletas,tiempos, desde, --indi);
		ordenarPorNombre(atletas,tiempos, desde, indi -1);
		ordenarPorNombre(atletas,tiempos, indi+1, hasta);
		
	}
	
	private static void intercambiar(String[] atletas, int[] tiempos, int i, int j) {
		String aux = atletas[j];
		int aux2 = tiempos[j];
		
		//intercambio valores
		atletas[j] = atletas[i];
		tiempos[j] = tiempos[i];
		
		atletas[i] = aux;
		tiempos[i] = aux2;
		
	}

	static private void ordenarPorTiempo(String[] atletas, int[] tiempos, int desde, int hasta) {
		//Mergesort recursivo
		
		//caso base
		if(desde >= hasta)
			return;
		
		ordenarPorTiempo( atletas, tiempos, desde, (desde+hasta)/2);
		ordenarPorTiempo( atletas, tiempos, (desde+hasta)/2 + 1, hasta );
		
		//merge
		
		mezclar( atletas, tiempos, desde, hasta, (desde+hasta)/2 );
		
		
		int guia = tiempos[desde];
		
		int indi = desde+1;
		for(int i = desde +1; i <= hasta ; i++){
			if(guia > tiempos[i]){
				//intercambio valores
				intercambiar(atletas,tiempos, indi, i);
				indi++;
			}	
		}
		
		intercambiar(atletas,tiempos, desde, --indi);
		ordenarPorTiempo(atletas,tiempos, desde, indi -1);
		ordenarPorTiempo(atletas,tiempos, indi+1, hasta);
		
	}
	
	
	static public void mezclar(String[] atletas, int[] tiempos, int desde, int hasta, int medio){
		
		int[] t2=new int[hasta-medio];
		int[] t1=new int[medio-desde+1];
		String[] a2=new String[hasta-medio];
		String[] a1=new String[medio-desde+1];
		
		
		for(int l=desde;l<=medio;++l){
			t1[l-desde]=tiempos[l];
			a1[l-desde]=atletas[l];
		}
		for(int l=medio+1;l<=hasta;++l){
			t2[l-medio-1]=tiempos[l];
			a2[l-medio-1]=atletas[l];
		}
		
		int i1=0,i2=0;
		
		while(true){
			if(i1>t1.length-1 && i2>(hasta-medio-1))break;
			if(i1>t1.length-1){
				tiempos[desde]=t2[i2];
				atletas[desde]=a2[i2];
				++desde;++i2;
				continue;
			}
			
			if(i2>(hasta-medio-1)){
				tiempos[desde]=t1[i1];
				atletas[desde]=a1[i1];
				++desde;++i1;
				continue;
			}
			
			if(t1[i1]>t2[i2])
			{
				tiempos[desde]=t2[i2];
				atletas[desde]=a2[i2];
				++desde;++i2;
			}else{
				tiempos[desde]=t1[i1];
				atletas[desde]=a1[i1];
				++desde;++i1;
			}
		}
		
	}

	private void abrirArchivo() {
		try{
			BufferedReader r = new BufferedReader(new FileReader(ruta.getText()));
			
			//cuento cuantas lineas hay 
			int nlineas = 0;
			while(r.readLine()!= null)
				nlineas++;
			r.close();
			
			//ahora guardo datos del archivo en los arreglos
			atletas = new String[nlineas];
			tiempos = new int[nlineas];
			
			
			r = new BufferedReader(new FileReader(ruta.getText()));
			String linea;
			int cont = 0;
			
			while((linea = r.readLine())!=null){
				atletas[cont] = linea.substring(7);
				tiempos[cont] = Integer.parseInt(linea.substring(0,7));
				cont++;
			}
			
			mostrarListas();
			info.setText("Archivo cargado exitosamente");
			
		}
		catch(FileNotFoundException e){
			info.setText("Archivo no encontrado");
		}
		catch(Exception e){
			info.setText("Error al leer Archivo");
		}
		
	}

	private void mostrarListas() {
		this.lista.removeAll();
		
		Panel pan = new Panel();
		pan.setLayout(new GridLayout(atletas.length,2));
		
		for(int i = 0; i < atletas.length ; i++){
			pan.add(new Label (atletas[i]));
			pan.add(new Label (""+ tiempos[i]));
			
			
		}
		
		this.lista.add(pan);
		
		setVisible(true);
	}

}
