package aux9;

import java.awt.*;
import java.awt.event.*;

public class Moleculas extends Frame implements ActionListener {
	
	Canvas canvas;
	Panel panel;
	Label label1, label2;
	Choice gases;
	TextField temperatura;
	Button graficar, iniciar, salir;
	//numeros usados para calcular coordenadas
	int anchoCanvas, altoCanvas;
	int y0, x0;
	double escalaX, escalaY, largoX, largoY;
	//masas
	final int masa[] = { 2, 32, 28, 4, 10, 18 };
	double cociente;
	//numero de moleculas
	final int N = 10000;
	//conjunto de colores
	int nGrafica = -1;
	static final Color color[] = { new Color(255, 0, 0), new Color(0, 255, 0), 
		new Color(0, 0, 255), new Color(0, 255, 255), 
		new Color(255, 0, 255), new Color(255, 255, 0), 
		new Color(128, 0, 0), new Color(255, 128, 0), 
		new Color(0, 64, 64), new Color(128, 128, 255), 
		new Color(128, 0, 64), new Color(255, 0, 128), 
		new Color(192, 192, 192), new Color(128, 128, 0) };
	
	
	
	public Moleculas() {
		
		setLayout(new BorderLayout());
		
		canvas = new Canvas();
		canvas.setSize(600, 600);
		panel = new Panel();
		label1 = new Label("Gas");
		label2 = new Label("Temperatura (K)");
		temperatura = new TextField("500", 5);
		
		graficar = new Button("Graficar");
		graficar.addActionListener(this);
		iniciar = new Button("Iniciar");
		iniciar.addActionListener(this);
		salir = new Button("Salir");
		salir.addActionListener(this);
		
		gases = new Choice();
		gases.addItem("Hidrgeno (H2)");
		gases.addItem("Oxgeno (O2)");
		gases.addItem("Nitrgeno (N2)");
		gases.addItem("Helio (He))");
		gases.addItem("Nen (Ne)");
		gases.addItem("Argn (Ar)");
		
		
		panel.setLayout(new FlowLayout());
		panel.setBackground(Color.lightGray);
		panel.add(label1);
		panel.add(gases);
		panel.add(label2);
		panel.add(temperatura);
		panel.add(graficar);
		panel.add(iniciar);
		panel.add(salir);
		
		add("Center", canvas);
		add("South", panel);
		
		anchoCanvas = canvas.getWidth();
		altoCanvas = canvas.getHeight();
		escalaX = (double) (anchoCanvas - x0 - 50) / 3000;
		escalaY = (double) (altoCanvas - y0 - 50) / 20;

		
		x0 = 20;
		y0 = altoCanvas - 20;
		
		pack();
		setVisible(true);
	}
	
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == salir)
			System.exit(0);
		else if (e.getSource() == iniciar) {
			dibujaEjes();
			iniciar.setLabel("Borrar");
		}
		else if (e.getSource() == graficar) {
			double temp = Double.valueOf(temperatura.getText()).doubleValue();
			int indice = gases.getSelectedIndex();
			setNuevo(temp, indice);
		}
		
	}
	//limpia el canvas
	void limpiar() {
		Graphics g = canvas.getGraphics();
		g.setColor(canvas.getBackground());
		g.fillRect(0, 0, anchoCanvas, altoCanvas);
	}
	//dibuja los ejes en el canvas
	void dibujaEjes() {
		Graphics g = canvas.getGraphics();
		//limpiar el canvas
		limpiar();
		g.setColor(Color.black);
		//eje horizontal
		g.drawLine(x0 - 5, y0, anchoCanvas, y0);
		g.drawString("v(m/s)", anchoCanvas - 35, y0 - 5);
		int x1, y1;
		for (int i = 0; i <= 3; ++i) {
			x1 = x0 + (int) (1000 * i * escalaX);
			g.drawLine(x1, y0 + 5, x1, y0 - 5);
			String str = Integer.toString(i * 1000);
			if (i == 0) str = "   0";
			g.drawString(str, x1 - 15, y0 + 15);
			if (i == 3)
				break;
			for (int j = 1; j < 5; j++) {
				x1 = x0 + (int) ((1000 * i + (double) (1000 * j) / 5) * escalaX);
				g.drawLine(x1, y0 + 2, x1, y0 - 2);
			}
		}
		//	eje vertical
		g.drawLine(x0, 0, x0, y0 + 5);
		g.drawString("dn/dv", x0 + 5, 15);
		for (int i = 0; i <= 20; i += 5) {
			y1 = y0 - (int) (i * escalaY);
			g.drawLine(x0 + 5, y1, x0 - 5, y1);
			String str = String.valueOf(i);
			g.drawString(str, x0 - 20, y1 + 5);
			if (i == 20)
				break;
			for (int j = 1; j < 5; j++) {
				y1 = y0 - (int) ((i + (double) (j)) * escalaY);
				g.drawLine(x0 + 2, y1, x0 - 2, y1);
			}
		}
	}
	
	void setNuevo(double temp, int indice) {
		cociente = (1.67e-27 * masa[indice]) / (2 * temp * 1.38e-23);
		//cambia color para pintar
		nGrafica++;
		if (nGrafica > 13) {
			nGrafica = 0;
		}
		//graficar
		dibujaFuncion();
	}
	//grafica la funcion
	void dibujaFuncion() {
		Graphics g = canvas.getGraphics();
		int x1 = x0, y1 = y0, x2, y2;
		g.setColor(color[nGrafica]);

		for (double v = 0; v < 3000; v += 10) {
			y2 = y0 - (int) (f(v) * escalaY);
			x2 = x0 + (int) (v * escalaX);
			g.drawLine(x1, y1, x2, y2);
			x1 = x2;
			y1 = y2;
		}
		g.dispose();
	}
	//funcion
	double f(double v) {
		double y = 4 * N * Math.PI * Math.pow(cociente / Math.PI, 1.5)
				* Math.exp(-cociente * v * v) * v * v;
		return y;
	}
	
	public static void main(String[] args) {
		Moleculas m = new Moleculas();
	}
}
