import java.io.*;
public class Problema2 {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		try{
			//defino archivos a leer
			BufferedReader rectangulos = new BufferedReader(new FileReader("Rectangulos.txt"));
			BufferedReader puntos = new BufferedReader(new FileReader("Puntos.txt"));
			
			//defino archivos a escribir
			PrintWriter res = new PrintWriter(new FileWriter("Resultados.txt"));
			
			while(true){
				String l1 = rectangulos.readLine();
				String l2 = puntos.readLine();
				
				//si alguno es nul, es que llegamos al final del archivo
				if(l1 == null || l2 == null)
					break;
					
				//obtengo rectangulo y punto con los datos leidos
				Rectangulo rect = fabricaRectangulo(l1);
				Punto p = fabricaPunto(l2);
				
				//imprimo en el archivo de resultado
				res.println(rect.lugarPunto(p));
			}
			
			//cuando los archivos al terminar
			rectangulos.close();
			puntos.close();
			res.close();
			
		}
		catch(FileNotFoundException e){
			System.out.println("no se encuentra el archivo");
			System.out.println(e.getMessage());
		}
		catch(IOException e){
			System.out.println("Se produjo un error al leer o escribir los archivos");
			System.out.println(e.getMessage());
		}

	}

	
	//crea un nuevo Punto a partir de la linea del archivo
	private static Punto fabricaPunto(String l2) {
		int gato = l2.indexOf('#');
		double x = (new Double(l2.substring(0,gato))).doubleValue();
		double y = (new Double(l2.substring(gato+1))).doubleValue();
		
		return new Punto(x,y);
	}
	
	//crea un nuevo rectangulo a partir de la linea del archivo
	private static Rectangulo fabricaRectangulo(String l1) {
		int gato1 = l1.indexOf('#');
		int gato2 = l1.indexOf('#',gato1+1);
		int gato3 = l1.indexOf('#',gato2+1);
		
		Punto vert = fabricaPunto(l1.substring(0,gato2));
		
		double alto = (new Double(l1.substring(gato2+1,gato3))).doubleValue();
		double ancho = (new Double(l1.substring(gato3+1))).doubleValue();
		
		return new Rectangulo(vert,alto,ancho);
	}

}
