class Nodo{
	public String valor;
	public Nodo izq, der;
	public Nodo(String x, Nodo y, Nodo z){ valor=x; izq=y; der=z; }
}
class Auxiliar3
{
	static public int hojas(Nodo x){
		if(x==null) return 0;
		if(x.izq == null && x.der == null) return 1;
		return hojas(x.izq) + hojas(x.der);
	}
	static public int altura(Nodo x){
		if(x==null) return 0;
		return 1 + (int)Math.max(altura(x.izq), altura(x.der));
	}
	static public String sucesor(Nodo x){
		if(x==null || x.der==null) return null;
		Nodo r;
		for(r=x.der; r.izq!=null; r=r.izq); // bajar por el lado izquierdo
		return r.valor;
	}
	static public boolean esABB(Nodo x){
		if(x==null || (x.izq==null && x.izq==null)) return true;
		if(x.izq==null) return x.valor.compareTo(x.der.valor)<0 && esABB(x.der);
		if(x.der==null) return x.valor.compareTo(x.izq.valor)>0 && esABB(x.izq);
		return x.valor.compareTo(x.izq.valor)>0 && x.valor.compareTo(x.der.valor)<0 && esABB(x.izq) && esABB(x.der);
	}
	public static void main(String[] args) 
	{
		Nodo raiz=new Nodo("C", new Nodo("B",null,null), new Nodo("D",null, new Nodo("F",null,null)));
		System.out.println("hojas = " + hojas(raiz));
		System.out.println("altura = " + altura(raiz));
		System.out.println("sucesor = " + sucesor(raiz));
		System.out.println("es ABB? " + esABB(raiz));
	}
}
