import java.io.*;


abstract class FilaTabla
{
abstract public void separarColumnas(String x);
abstract public String juntarColumnas();
abstract public int largo();

public boolean leer(BufferedReader x)
throws IOException{
    String linea = x.readLine();
    if(linea==null) return false;
    separarColumnas(linea);
    return true;
}
public void escribir(PrintWriter x)
throws IOException{
    x.println(juntarColumnas());
}


public boolean leer(RandomAccessFile x)
throws IOException{
   if(x.getFilePointer()>=x.length())return false;
    separarColumnas(U.leerString(x,largo()/2));
    return true;
}
public void escribir(RandomAccessFile x)
throws IOException{
    U.escribirString(x,juntarColumnas());
}
public boolean leer(RandomAccessFile x,int y)
throws IOException{
    x.seek(y*largo()); return leer(x);
}
public void escribir(RandomAccessFile x,int y)
throws IOException{
x.seek(y*largo()); escribir(x);
}
}


class U{
static public String rellenar(String x,int n){
  return n<=x.length()?
    x.substring(0,n) : rellenar(x+" ",n);
}
static public void escribirString(
RandomAccessFile x,String y)throws IOException{
  for(int i=0; i<y.length(); ++i)
    x.writeChar(y.charAt(i));
}
static public String leerString(
RandomAccessFile x,int l)throws IOException{
  String s="";
  for(int i=0; i<l; ++i)
    s+=x.readChar();
  return s;
}

static public String recorte(String x, int y){
        return ((x.toUpperCase()).trim()+"                                                  ").substring(0,y);
    }
}


class Libro extends FilaTabla
{
public String id,titulo,autor,editorial,fecha;
public static final int LI=20,LT=50,LA=50,LE=20,LF=8;
public Libro(){id=titulo=autor=editorial=fecha=null;}
public int largo(){return 2*(LI+LT+LA+LE+LF);}
public void separarColumnas(String x){
    int i=0;//indice de comienzo de columna
    id              = x.substring(i,i+=LI);
    titulo      = x.substring(i,i+=LT);
    autor           = x.substring(i,i+=LA);
    editorial   = x.substring(i,i+=LE);
    fecha           = x.substring(i,i+=LF);
}
public String juntarColumnas(){
  return U.rellenar(id,LI)+U.rellenar(titulo,LT)
  + U.rellenar(autor,LA)+U.rellenar(editorial,LE)
  + U.rellenar(fecha,LF);
}
}


class Lector extends FilaTabla
{
public String id,nombre,direccion,fono,email;
public static final int LI=10,LN=50,LD=50,LF=10,LE=20;
public Lector(){id=nombre=direccion=fono=email=null;}
public int largo(){return 2*(LI+LN+LD+LF+LE);}
public void separarColumnas(String x){
    int i=0;//indice de comienzo de columna
    id              = x.substring(i,i+=LI);
    nombre      = x.substring(i,i+=LN);
    direccion   = x.substring(i,i+=LD);
    fono            = x.substring(i,i+=LF);
    email           = x.substring(i,i+=LE);
}
public String juntarColumnas(){
  return U.rellenar(id,LI)+U.rellenar(nombre,LN)
  + U.rellenar(direccion,LD)+U.rellenar(fono,LF)
  + U.rellenar(email,LE);
}
}


class Prestamo extends FilaTabla
{
public String idLibro,idLector,fecha;
public static final int LI=Libro.LI,LE=Lector.LI,LF=8;
public Prestamo(){idLibro=idLector=fecha=null;}
public int largo(){return 2*(LI+LE+LF);}
public void separarColumnas(String x){
    int i=0;//indice de comienzo de columna
    idLibro = x.substring(i,i+=LI);
    idLector    = x.substring(i,i+=LE);
    fecha       = x.substring(i,i+=LF);
}
public String juntarColumnas(){
  return U.rellenar(idLibro,LI)
  + U.rellenar(idLector,LE)
  + U.rellenar(fecha,LF);
}
}
