/* 	
	PROBLEMA 1
	
	Auxiliar CC10A Seccion 1 - 9 de Agosto de 2006
	
	Angie Perez Medina
	Gabriel Moreno Calderon
*/

import java.awt.*;
import java.awt.event.*;
import java.io.*;

class Dic extends Frame implements ActionListener{
	
	private Diccionario D;
	
	private Button 	buscar,
					agregar,
					borrar,
					cambiar,
					quit;
					
	private TextField	palabra,
						significado;
	
	private Label mensaje;
	
	static public void main(String[] args) throws IOException, DiccLleno{
		new Dic(args[0]).show();
		}
		
	
	public Dic(String x) throws IOException, DiccLleno{
		
		BufferedReader A = new BufferedReader(new FileReader(x));
		D = new Diccionario();
		
		//Llenar diccionario
		String linea;
		
		while((linea = A.readLine()) != null){
		
			D.agregar(linea.substring(0,linea.indexOf(":")),
					  linea.substring(linea.indexOf(":") + 1));
			}
		
		A.close();
		
		//Armar ventana
		
		//Crear botones
		buscar = new Button("Buscar");
		agregar = new Button("Agregar");
		borrar = new Button("Borrar");
		cambiar = new Button("Cambiar");
		quit = new Button("Quit");
		
		//Crear TextFields
		palabra = new TextField();
		significado = new TextField();
		
		//Crear Label
		mensaje = new Label("");
		
		//Diagramar ventana
		setLayout(new GridLayout(2,5));
		setSize(400,70);
		
		add(buscar); add(agregar); add(borrar); add(cambiar); add(quit);
		add(new Label("Palabra")); add(palabra); add(new Label("Significado"));
		add(significado); add(mensaje);
		
		//Escuchadores
		buscar.addActionListener(this);
		agregar.addActionListener(this);
		borrar.addActionListener(this);
		cambiar.addActionListener(this);
		quit.addActionListener(this);
		}
		
	public void actionPerformed(ActionEvent x){
	
		if(x.getSource() == quit){
			System.exit(0);
		}
		
		else if(x.getSource() == buscar){
			String s = (String)D.buscar(palabra.getText());
			if(s == null){
				mensaje.setText("Entrada no existe");
			}else{
				significado.setText(s);
				mensaje.setText("OK");
				}
		}
		
		else if(x.getSource() == agregar){
			try{
				boolean b = D.agregar(palabra.getText(),significado.getText());
				if(b == true)
					mensaje.setText("OK");
				else
					mensaje.setText("Entrada ya existe");
			}catch(DiccLleno e){
				mensaje.setText("No se pudo agregar. Dic lleno");
			}
		}
		
		else if(x.getSource() == borrar){
			if(D.borrar(palabra.getText()) == true)
				mensaje.setText("OK");
			else
				mensaje.setText("Entrada no existe");
			
		}
		else if(x.getSource() == cambiar){
			if(D.cambiar(palabra.getText(),significado.getText()) == true)
				mensaje.setText("OK");
			else
				mensaje.setText("Entrada no existe");
			}
		}
}
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
		
		
		