%CArgo los datos y calculo los parametros del modelo
% a1=0.3;
% a2=0.5;
% b1=1;
% b2=0.5;
% b3=1.2;
% y(i)=a1*y(i-1)+a2*y(i-2)+b1*u(i-1)+b2*u(i-2)+b3*u2(i-1)+1.5*randn;

load('datos.mat');

%Defino la estructura del modelo
Na=2;  %numero de autoregresivos
Nb=[2 1];  %numero de parametros en la entrada 
Nk=[1 1];  %retardo minimo en la entrada

%Calculo los parametros
mod=arx([y u u2],[Na Nb Nk]);

mod
%mod.a entrega los parametros autoregresivos
%mod.b entrega los parametros de la entrada
%mod.da y mod_1.db la desv.estandar de la estimacion de los parametros

%Estimacion a un paso
yest_1=predict([y u u2],mod,1);
figure
plot([y yest_1])
legend('y','yest_1')
title('Prediccion a un 1 paso')
e1=y-yest_1;
rms1=mean(e1.*e1);

%Utilizo el modelo como sensor virtual
yest=idsim([u u2],mod);
figure
plot([y yest])
legend('y','yest');
title('Sensor virtual')
e=y-yest;
rms=mean(e.*e);



%Supongamos que proponemos otra estructura
Na=1;
Nb=[1 1 1];
Nk=[1 2 1];

L=length(y);
u3=ones(L,1);

mod_1=arx([y u u2 u3],[Na Nb Nk]);

mod_1

yest_1=predict([y u u2 u3],mod_1,1);
figure
plot([y yest_1])
legend('y','yest_1')
title('Prediccion a un paso, con otra estructura');
e1=y-yest_1;
rms1=mean(e1.*e1);

yest=idsim([u u2 u3],mod_1);
figure
plot([y yest])
legend('y','yest');
title('Sensor vitual, con otra estructura');
e=y-yest;
rms=mean(e.*e);

