function [res,net_res,hue]=entRed(datos,n_neuronas,p_train,p_val,maxFail)
%Funcion que recibe como parametros de entrada el conjunto de datos, 
%el numero de neuronas, porcentaje (0 - 1) para conjunto de train y de
%validacion y el numero maximo de errores en el entrenamiento. Y como
%salida da la eficiencia, la configuracion de la red, un objeto que
%almacena los valores de media y d.estandar para transformar los datos
%antes de ejecutar la red seleccionada

data=datos;

%ptrain y pval son parametros de entrada
p_test=1-p_train-p_val;  %La diferencia corresponde a la proporcion del conjunto de test

[n_samples,n_feat]=size(data); %Calculamos las dimensiones de la matriz de datos
n_feat=n_feat-1; %Restamos uno a los atributos puesto que la ultima columna es el target
for i=1:10                          %Iteramos N veces una red
    data0=desorden(data);           %Deesordenamos con la funcion desorden
       
    %ahora saco los datos balanceados
    u=minmax(data0(:,n_feat+1)');
    %Calculo de que clase hay mas e igualo dos conjuntos. La clase que
    %tenga menos objetos determinara el tamao de la matriz
    data_c1=data0(find(data0(:,n_feat+1)==u(1)),:); 
    data_c2=data0(find(data0(:,n_feat+1)==u(2)),:);    
    [la1,nada]=size(data_c1);
    [la2,nada]=size(data_c2);
    %Si hay mas de la clase 1
    if la1 > la2
        la1=la2;
        data_c1=data_c1(1:la2,:);
    else
    %mas de la clase 2
        data_c2=data_c2(1:la1,:);
    end
    %Junto los conjuntos de cada clase en una misma matriz
    data_bala=desorden([data_c1;data_c2]);
    
    %ahora discretizo los valores. Entrego la matriz y la clase. Como
    %salida tengo los datos transformados y los valores de las medias y d.e. (cada uno es un vector
    %por atributo) para los conjuntos de entrenamiento y test
    [pn,meanp,stdp,tn,meant,stdt]=prestd(data_bala(:,1:n_feat)',data_bala(:,n_feat+1)');
    
    %ahora saco los subconjuntos a traves de la generacion de tres indices
    s_i=1:floor(2*la1*p_train);
    s_ii=floor(2*la1*p_train)+1:floor(2*la1*(p_train+p_val));
    s_iii=floor(2*la1*(p_train+p_val))+1:2*la1;
    %Conjunto para entrenar, validar y testear
    P=pn(:,s_i);
    val.P=pn(:,s_ii);
    test.P=pn(:,s_iii);
    T=tn(s_i);
    val.T=tn(s_ii);
    test.T=tn(s_iii);
    
    %Estoy listo para entrenar las redes
    net=newff(minmax(P),[n_neuronas 1],{'tansig','tansig'},'trainscg');
    net.trainParam.epochs=300;
    net.trainParam.show=inf; %para que no muestre los graficos de error
    net.trainParam.goal=1e-2; %Convergencia
    net.trainParam.max_fail=maxFail; 
    %Entreno
    [net,tr]=train(net,P,T,[],[],val,test);
    %Transformo el conjunto de entrenamiento con los parametros encontrados
    datan=trastd(data(:,1:n_feat)',meanp,stdp); 
    %Pruebo la red con los adtos transformados
    an=sim(net,datan);
    %Redondeo y transformo a valore originales el conjunto de test
    a=round(poststd(an,meant,stdt));
    %Busco la mejor eficiencia
    res(i)=mean(a==data(:,n_feat+1)');
    
    %Guardo los valores de media y d.e. para esa configuracion (y
    %aplicarsela a futuros datos)
    if res(i)==max(res)
        net_res=net;
        hue.mp=meanp;
        hue.sp=stdp;
        hue.mt=meant;
        hue.st=stdt;
    end
end

