%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Este programa Mij2nd.m calcula a partir del 
%(strike,dip,rake)
% de un mecanismo focal de un terremoto las coordenadas
% en el sistema de referencia geografica
% 1 = Norte
% 2 = Este
% 3 = Vertical positiva abajo
% del vector normal al plano de falla y del
% vector desplazamiento (slip) en sobre este plano de falla
% Denis Legrand, DGF, Septiembre 2005
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
 
% Entradas:
 strike=input('Strike ');
 dip=input('Dip ');
 rake=input('Rake ');
 
 radian = pi / 180;
 strike = strike * radian;
 dip = dip * radian;
 rake = rake * radian;
 
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%%%%%%
 % Calculo de la coordenadas del vector normal en el
 % sistema de referencia geografico:
 
 n(1) = - sin(dip) * sin(strike);
 n(2) = + sin(dip) * cos(strike);
 n(3) = - cos(dip);
 % Normalizacion de este vector:
 nnorm = sum (n .* n)
 nnorm = sqrt ( nnorm );
 n(1) = n(1) / nnorm;
 n(2) = n(2) / nnorm;
 n(3) = n(3) / nnorm;
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%%%%%%
 
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%%%%%%
 % Calculo de la coordenadas del vector dislocacion en el
 % sistema de referencia geografico:
 
 d(1) =  cos(rake) * cos(strike) + cos(dip) * sin(rake) * sin (strike);
 d(2) =  cos(rake) * sin(strike) - cos(dip) * sin(rake) * cos (strike);
 d(3) = -sin(rake) * sin(dip);
 % Normalizacion de este vector:
 
 dnorm = sum (d .* d)
 dnorm = sqrt ( dnorm );
 d(1) = d(1) / dnorm;
 d(2) = d(2) / dnorm;
 d(3) = d(3) / dnorm;
 
 %Calculo del azimut:
  azimut=180/pi*atan2(d(2),d(1))
 
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%%%%%%
 
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%%%%%%
 % Calculo del tensor de momentos sismicos:
 for i =1:3
     for j=1:3
         m(i,j) = n(i)*d(j) + n(j)*d(i);
     end
 end
 
 n
 d
 m
