(: called with galax-run -var q=<integer> all.xq :)

declare variable $q as xs:integer external;

(:
   Query q-2.xq
   ============
:)

declare function local:query2() {
   "For each food component (as found in daily-values), output the ten first food elements order by their decreasing quantity of the component",

   document  {
      element best-of {
         for $c in fn:doc("food.xml")//daily-values/*
         let $n := local-name($c)
         return
            element { $n } {
               for $f at $p in (: only way to sort and select the ten first :)
                  for $f in fn:doc("food.xml")//food
                  order by xs:double($f/*[local-name(.) eq $n]) descending
                  return $f
               let $q := $f/*[local-name(.) eq $n]
               where $p <= 10
               return <food>{$f/name/text()} from {$f/mfr/text()} with {$q/text()}{string($c/@units)}</food>
               }
      }
   }
};


(: Query q-3.xq :)

declare function local:query3() {
   "Put the units back into the food components (ie, each food component in the output document must have a “units” attribute whose value is found in daily-values)",

for $f in fn:doc("food.xml")//food
return
   element food {
      for $c in $f/node()
      let $ref := fn:doc("food.xml")//daily-values/*[local-name($c)=local-name(.)]
      return if (fn:empty($ref)) then $c
      else element { local-name($c) } { $ref/@units ,$c/node() }

   }
};


(: Query q-4.xq :)

declare function local:query4() {
   "Consider a menu (file “menu.xml” in the same directory as “food.xml”). The format of the file is: <menu><food from=""manufacturer"" quantity=""integer value"">product name</food><food …>…</food></menu>. Does the menu exceeds the recommanded daily-values for any of the different food components?",

   let $doc := <menu><food from="Thomas'" quantity="10">Bagels, New York Style </food><food from="Armour" quantity="1">Beef Frankfurter, Quarter Pound </food></menu> (: should be: fn:doc("menu.xml") :)

   let $foods :=
      for $x in $doc/food
      let $f := fn:doc("food.xml")//food[name eq $x/text() and mfr eq $x/@from]
      return element food { $x/@quantity, $f/node() }

   return some $ref in fn:doc("food.xml")//daily-values/*
   satisfies sum(for $f in $foods return $f/@quantity * $f/*[local-name() eq local-name($ref)]) > $ref/text()
};

(: Query q-5.xq :)

declare function local:query5() {
   "With the same “menu.xml” value, output all the food elements that I can eat without exeeding the recommend daily values.",

   let $doc := <menu><food from="Thomas'" quantity="1">Bagels, New York Style </food><food from="Armour" quantity="1">Beef Frankfurter, Quarter Pound </food></menu>


   let $foods :=
      for $x in $doc/food
      let $f := fn:doc("food.xml")//food[name eq $x/text() and mfr eq $x/@from]
      return element food { $x/@quantity, $f/node() }

   let $s :=
   for $ref in fn:doc("food.xml")//daily-values/*
   return element { local-name($ref) } { $ref/text() - sum(for $f in $foods return $f/@quantity * $f/*[local-name() eq local-name($ref)]) }

   return if (every $y in $s satisfies $y >= 0)
   then ("Menu below daily values",
   for $f in fn:doc("food.xml")//food
   where every $y in $s, $x in $f/*[local-name() = local-name($y)] satisfies $y - $x >= 0
   return $f)
   else "Menu already exceeds daily values"
};

(: Query q-6.xq :)

declare function local:fact($x as xs:integer) as xs:integer {
   if ($x > 0) then local:fact($x - 1) * $x
   else 1
};

declare function local:query6() {
   "Write the factorial function and output the list of the ten first factorial values (0!, 1!, …, 10!) within “fact” elements",
   for $i in (1 to 10) return element fact { attribute n { $i }, local:fact($i) }
};



if ($q eq 2) then local:query2()
else if ($q eq 3) then local:query3()
else if ($q eq 4) then local:query4()
else if ($q eq 5) then local:query5()
else if ($q eq 6) then local:query6()
else ("Unknown question ",$q)
