#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <fcntl.h>

#define TESTBAD 0
#define TESTOK 	1

char file [1024]= "/dev/ndev";
char texto1[1024]= "Mensaje en una botella \0";
char texto2[1024]= "Si usted puede leer esto, no necesita anteojos \0";

void nDevSend(pid_t pid, char *str, int length){
	char buf[1024];
	int fp,n;
	
	if((fp=open(file, O_WRONLY))<0){
		printf("Error no puedo abrir %s para escritura.\n", file);
		exit(1);
	}

	memcpy(buf, &pid, sizeof(pid_t));
	memcpy(buf+sizeof(pid_t), str, length);
	
	n=sizeof(pid_t)+length; 
	
	if(write(fp, buf, n)!=n	){
		printf("Error en write\n");
		exit(1);
	}
	
	close(fp);
	printf("Escritor: to:%d buf:%s total=%d\n",pid,str,length);
}

int nDevRead(char *dest){
	int total=0;
	int fp,n;

	if( (fp= open(file,O_RDONLY))<0){
		printf("Error no puedo abrir %s para lectura.\n", file);
		exit(1);
	}
	while((n=read(fp, dest, 4096))>0)
		total+=n;
	
	if(close(fp)<0){
		printf("Error en close %s para lectura.\n",file);
		exit(1);
	}

	return total;
}

/* Padre lee del hijo. */
int LectorCode(char *orig){
	int msg_length,status;	
	char buf[4096];
	memset(buf, 0, 4096);

	/* Si nadie ha escrito, bloqueamos? */
	
	msg_length = nDevRead(buf);
	
	printf("Lector:  pid:%d buf:%s total=%d\n",getpid(), buf,msg_length);
	if(strcasecmp(orig, buf)==0)
		return TESTOK;
	return TESTBAD;
}
	
void TestI(){

	pid_t hijo;

	printf(" Envio de mensaje entre 2 procesos.\n");
	
	if((hijo=fork())<0){
		printf("Error cant fork\n");
		exit(1);
	}

	if(hijo==0){
		nDevSend(getppid(), texto1, strlen(texto1)+1);
		exit(0);
	}
	else{
		if(LectorCode(texto1)==TESTBAD){
			printf("Error, mensaje enviado distinto de recibido.\n");
			exit(1);
		}
		exit(0);
	}

}

void TestII(){
	
	pid_t hijo;

	printf(" Borrado de Mensajes despues de leer.\n");
	
	if((hijo=fork())<0){
		printf("Error cant fork\n");
		exit(1);
	}

	if(hijo==0){
		nDevSend(getppid(), texto1, strlen(texto1)+1);
		nDevSend(getppid(), texto2, strlen(texto2)+1);
		exit(0);
	}
	else{
		if(LectorCode(texto1)==TESTBAD){
			printf("Error, mensaje enviado distinto de recibido.\n");
			exit(1);
		}
		if(LectorCode(texto2)==TESTBAD){
			printf("Error, mensaje leido no borrado.\n");
			exit(1);
		}
		exit(0);
	}

}

void TestIII(){
	pid_t hijo;

	printf(" Envio de multiples mensajes a un proceso.\n");
	
	if((hijo=fork())<0){
		printf("Error can't fork\n");
		exit(1);
	}

	if(hijo==0){
		int lector=getppid();
		int nieto,status_nieto;
		
		if((nieto=fork())<0){
			printf("Error can't fork\n");
			exit(1);
		}
		if(nieto==0){
			nDevSend(lector, texto1, strlen(texto1)+1);
			exit(0);
		}
		else { /*hijo*/
			/* Espero que el hijo escriba para que se encolen en orden */
			wait(&status_nieto);
			
			if(WIFEXITED(status_nieto) && WEXITSTATUS(status_nieto)){
				printf("Error en status de nieto escritor\n");
				exit(1);
			}
			nDevSend(lector, texto2, strlen(texto2)+1);
		}
		exit(0);
	}
	else{
		if(LectorCode(texto1)==TESTBAD){
			printf("Error, mensajes enviado distinto de recibido.\n");
			exit(1);
		}
		if(LectorCode(texto2)==TESTBAD){
			printf("Error, segundo mensaje enviado distinto de recibido.\n");
			exit(1);
		}
		exit(0);
	}
}

void TestIV(){
	pid_t hijo;

	printf(" Envio de mensaje por /dev/ndevX distintos.\n");
	
	if((hijo=fork())<0){
		printf("Error can't fork\n");
		exit(1);
	}

	if(hijo==0){
		pid_t lector=getppid();
		pid_t nieto;
		
		if((nieto=fork())<0){
			printf("Error can't fork\n");
			exit(1);
		}
		if(nieto==0){ /* nieto */
			strcpy(file, "/dev/ndev3");
			nDevSend(lector, texto2, strlen(texto1)+1);
			exit(0);
		}
		else { /*hijo*/
			strcpy(file, "/dev/ndev2");
			nDevSend(lector, texto1, strlen(texto2)+1);
		}
		exit(0);
	}
	else{
		strcpy(file, "/dev/ndev2");
		if(LectorCode(texto1)==TESTBAD){
			printf("Error, mensajes enviado distinto de recibido.\n");
			exit(1);
		}
		strcpy(file, "/dev/ndev3");
		if(LectorCode(texto2)==TESTBAD){
			printf("Error, segundo mensaje enviado distinto de recibido.\n");
			exit(1);
		}
		exit(0);
	}
}
	

int TestExec(void (*Test)()) {
	pid_t hijo;
	int status;

	if( (hijo=fork())<0){
		printf("Error can't fork Test()");	
		exit(1);
	}
	
	if( hijo==0){
		(*Test)();		
	}
	else{
		wait(&status);

		if(WIFEXITED(status) && WEXITSTATUS(status)){
			return TESTBAD;
		}
		return TESTOK;
	}

}

int main(int argc, char *argv[]){

	int i,total=3, numtest=4;
	void *Test[]={(void *)TestI, (void *)TestII, (void *)TestIII, 
			(void *)TestIV};
	int nota[]={1, 1, 1, 1};
	
	for(i=0;i<numtest;i++){
		printf("Test %d." , i+1);fflush(stdout);
		if(TestExec(Test[i])==TESTOK){
			printf("Test %d. Aprobado +%d.0\n\n",i+1,nota[i]);
			total+=nota[i];
		}
		else
			printf("Test %d. Error\n\n",i+1);
	}

	printf("\nNota Final:%d.0\n\n",total);

	system("lsmod | grep Module");
	system("lsmod | grep ndev");
	
	
	printf("\nAdvertencia: Si el modulo ndev tiene un 'Used by' !=0 despues de los test,\n");
	printf("la nota final no es valida y Ud. obtendra una nota final == 1.0\n\n");

	printf("Al corregir, nos reservamos el derecho de correr los test simultaneamente.\n");
	
	return 0;
}
