/* main.c
 * Programa de prueba para verificar la correcta descompresin
 *
 * Francisco Claude F.
 * fclaude@dcc.uchile.cl
 */

#include <stdio.h>
#include <stdlib.h>
#include "filegen.h"
#include "cmp.h"

char *encode_cmd, *decode_cmd;
char * encode, *decode;

void uso(char * cmd)
{
	printf("Uso: %s <encode_cmd> <decode_cmd>\n",cmd);
	printf("     Ejemplo: %s \"./encode \" \"./decode \"\n",cmd);
	exit(0);
}

void test(char * f, int size, int subt, int (*testfn)())
{
	int c;
	printf("* Iniciando Subtest %d\n",subt);
	testfn(f,size);
	sprintf(encode_cmd,"%s %s %s.c > /dev/null\n",encode,f,f);
	printf(" Comprimiendo el archivo...");
	c=system(encode_cmd);
	if(!c) printf("[OK]\n");
	else printf("[ERR]\n");
	sprintf(decode_cmd,"%s %s.c %s.d > /dev/null\n",decode,f,f);
	printf(" Descomprimiendo el archivo...");
	c=system(decode_cmd);
	if(!c) printf("[OK]\n");
	else printf("[ERR]\n");
	sprintf(encode_cmd,"%s.d",f);
	printf(" Comparando los resultados...");
	if(cmp(encode_cmd,f)!=0)
		printf("[ERR]\n");
	else
		printf("[OK]\n");
	printf("\n");
	sprintf(encode_cmd,"rm -rf %s",f);
	system(encode_cmd);
	sprintf(encode_cmd,"rm -rf %s.c",f);
	system(encode_cmd);
	sprintf(encode_cmd,"rm -rf %s.d",f);
	system(encode_cmd);
}

int main(int argc, char ** argv)
{
	if(argc!=3)
		uso(argv[0]);
	encode_cmd = (char *)malloc(sizeof(char)*(strlen(argv[1])+256));
	decode_cmd = (char *)malloc(sizeof(char)*(strlen(argv[2])+256));
	encode = argv[1];
	decode = argv[2];
	printf("Iniciando Test 1\n");
	printf("================\n\n");

	test("test_file_nrnd",512,1,gentest1);
	test("test_file_nrnd",1024*1024,2,gentest1);
	test("test_file_nrnd",1024*1024*10,3,gentest1);

	printf("Iniciando Test 2\n");
  printf("================\n\n");

  test("test_file_rnd",512,1,gentest1);
  test("test_file_rnd",1024*1024,2,gentest1);
  test("test_file_rnd",1024*1024*10,3,gentest1);
}
