/* CC31A - Programacin de Software de Sistemas
Pauta Pregunta 4 Examen Primavera 2005
por: Luis Len Crdenas Graide (lcardena [at] dcc . uchile . cl)
*/

#include <stdio.h> /* printf */
#include <stdlib.h> /* atoi, malloc, free, EXIT_* */
#include <pthread.h> /* threads, mutex, detach, attr, self */
#include <unistd.h> /* read, write, close */

#include "jsockets.h" /* socket, bind, accept, listen */

/* Comentarios que comiencen con /** son evaluados */

void servir(int port);

/** En caso de usar parmetros para la funcin del thread, asegurarse de
hacerlo bien: usar struct o bien pasar un puntero a un campo simple */
typedef struct {
	pthread_mutex_t *lock;
	int socket_cliente;
} cliente_args;
void *cliente(void *args);

int main(int argc, char *argv[]) {
	int port;
	if (argc != 2) {
		printf("Uso: %s puerto\n", argv[0]);
		return EXIT_SUCCESS;
	}
	port = atoi(argv[1]);
	servir(port);
	return EXIT_FAILURE;
}

void servir(int port) {
	int socket_cliente, socket_servidor = j_socket();/** Crea socket */
	/** Lock del servidor. Podran hacerlo global */
	pthread_mutex_t lock;
	/** Atributos para todos los threads. Si no se hace as, hay que esperar a
	los threads */
	pthread_attr_t atributos;

	if (j_bind(socket_servidor, port)) {/** Prepara puerto */
		printf("No se pudo bind al puerto %i.\n", port);
		return;
	}

	/** Inicializa el lock */
	pthread_mutex_init(&lock, NULL);
	/** Inicializa los atributos de los threads */
	pthread_attr_init(&atributos);

	/** No interesa lo que retornen los threads, as que se marcan para ignorar
	su retorno. Si no se hace esto, hay que esperarlos */
	pthread_attr_setdetachstate(&atributos, PTHREAD_CREATE_DETACHED);

	printf("Esperando clientes en socket %i y puerto %i\n", socket_servidor, port);
	/** Acepta conexiones en el socket correcto */
	while ((socket_cliente = j_accept(socket_servidor)) >= 0) {
		pthread_t pth_id;/* ID del thread (para depuracin) */
		/** Los threads deben recibir punteros a argumentos vlidos. Cuidado con
		apuntar al stack */
		cliente_args *args = malloc(sizeof *args);
		/** Los threads deben poder ver el lock. Puede ser global */
		args->lock = &lock;
		/** Cada thread debe saber con quin habla */
		args->socket_cliente = socket_cliente;

		printf("Atendiendo a cliente en socket %i\n", socket_cliente);
		/** Crear thread con parmetros correctos del thread y de la funcin */
		pthread_create(&pth_id, &atributos, cliente, args);
		printf("Thread %u creado para cliente en socket %i\n", pth_id, socket_cliente);
	}
	printf("Terminando servidor\n");
	/* Libera recursos si algo falla */
	pthread_attr_destroy(&atributos);
	pthread_mutex_destroy(&lock);
	close(socket_servidor);
}

/** Forma correcta de la funcin de un thread */
void *cliente(void *args) {
	/** Recibe y enva 'l' o 'u' */
	char mensaje;
	/** Recuerda si tiene o no el lock en caso de desconexin de cliente */
	int bloqueado = 0;

	/** Permite al thread conocer sus parmetros */
	cliente_args my_args = *(cliente_args *)args;
	pthread_t self = pthread_self();/* Para depuracin */
	/** En alguna parte hay que liberarlos. Cuidado con Memory Leaks */
	free(args);

	printf("Entrando en thread %u para cliente en socket %i\n", self, my_args.socket_cliente);
	/** Espera mensaje del cliente y valida desconexin */
	while (read(my_args.socket_cliente, &mensaje, sizeof mensaje) > 0) {
		printf("%u < %c\n", self, mensaje);
		/* Supuesto: clientes "educados".
		Despus de 'l' slo viene 'u' o desconexin
		Despus de 'u' slo viene 'l' o desconexin */
		switch(mensaje) {
			case 'l':/** Bloquea */
				pthread_mutex_lock(my_args.lock);
				bloqueado = 1;
				break;
			case 'u':/** Desbloquea */
				pthread_mutex_unlock(my_args.lock);
				bloqueado = 0;
				break;
			default:/* Depuracin */
				printf("%u : Ignorando mensaje %c\n", self, mensaje);
				continue;
		}
		printf("%u > %c\n", self, mensaje);
		/** Responde al cliente despus de cumplir peticin y valida desconexin */
		if (write(my_args.socket_cliente, &mensaje, sizeof mensaje) < sizeof mensaje) {
			printf("Error write %c en thread %u\n", mensaje, self);
			break;
		}
	}
	printf("Error read en thread %u\n", self);
	close(my_args.socket_cliente);/** Cierra socket ante desconexin */
	/** Se asegura de desbloquear SI ES QUE HAY DESCONEXIN */
	if (bloqueado) {
		printf("Desbloqueando lock bloqueado al morir thread %u\n", self);
		pthread_mutex_unlock(my_args.lock);
	}
	/** Si no se espera resultado, NULL. Si se espera, retornar algo adecuado */
	return NULL;
}

/* Penalizaciones: (* = Errores [conceptuales] graves)

-0.5: No crear socket
-0.5: No preparar puerto (bind)
-1.0:*Acepta conexiones en el socket equivocado o no acepta
-2.0:*No soporta mltiples clientes concurrentes
-1.0:*Bomba thread
-1.0:*El lock del servidor no es nico
-0.3: No inicializar el lock
-0.5: Pasar mal parmetros a funcin del thread (incluye confundir punteros)
-1.0:*Coherencia entre detachar threads, esperar su retorno y retornar
-0.3: No inicializar los atributos de los threads
-0.5: Acceso incorrecto de los threads al lock (copiar lock o no verlo)
-1.0:*Confusin entre cada thread y su interlocutor
-0.5: Recuperar mal parmetros en el thread
-1.0:*Descoordinacin en la liberacin de parmetros del thread (stack/heap)
-0.5: Memory leak
-0.3: Encabezado incorrecto de la funcin de un thread
-1.0:*No esperar mensaje del cliente
-0.5: No verificar desconexin al leer. Puede no hacerse al escribir
-1.0:*No bloquear ante peticin
-1.0:*No desbloquear ante peticin
-0.5: No responder al cliente al bloquear
-0.5: No responder al cliente al desbloquear
-1.0:*No recibir mltiples peticiones desde un mismo cliente
-0.5: No liberar lock de cliente bloqueado que se desconecta
-0.5: Liberar lock de cliente desbloqueado que se desconecta
-0.5: No cerrar socket al desconectar
-0.3: Errores de C leves
-0.5: Errores de C significativos

*/
