/* Control 3 2005
Pregunta 3: Sockets y Comunicacin en Red
Pauta por Luis Len Crdenas Graide
lucarden@ing.uchile.cl, lcardena@dcc.uchile.cl

Se pide implementar un servidor de red de tipo chat, que reciba conexiones
desde mltiples clientes en el puerto PORT. Cada vez que llegan bytes por el
socket de algn cliente, debe enviar esos mismos bytes a todos los dems
clientes, evitando responder al mismo emisor.

Implemntelo con select y sin crear procesos. Puede suponer un mximo de
MAXCLIENTS clientes. No olvide cerrar los sockets de las conexiones una vez
terminadas.

Supuestos: No fallan las creaciones de sockets ni el escuchar en un puerto ni
el aceptar conexiones ni las operaciones de I/O.
*/

#include <stdlib.h>
#include <stdio.h>

#include <unistd.h>
#include <sys/select.h>

#include "jsockets.h"

#define MAX_CLIENTS (8)

int servidor(int puerto);
int atender(int socket);

int main(int argc, char *argv[]) {
	int puerto;
	if (argc != 2) {
		printf("Uso: %s puerto\n", argv[0]);
		return EXIT_SUCCESS;
	}
	puerto = atoi(argv[1]);
	return servidor(puerto);
}

int servidor(int puerto) {
	int socket, ok;
	/* Crea un socket */
	if ((socket = j_socket()) < 0) {
		/* Verifica error [NO EVALUADO] */
		printf("No se pudo crear socket.\n");
		return EXIT_FAILURE;
	}
	/* Liga el puerto */
	if ((j_bind(socket, puerto))) {
		/* Si error [NO EVALUADO] */
		printf("No se pudo hacer bind al puerto %i\n", puerto);
		close(socket);
		return EXIT_FAILURE;
	}
	ok = atender(socket);
	/* Al terminar, cierra los sockets iniciales [NO EVALUADO] */
	close(socket);
	return ok;
}

int atender(int socket) {
	int n, sockets[MAX_CLIENTS]; /* Tiene los sockets de los clientes */
	for (n = 0; n < MAX_CLIENTS; ++n) {
		/* Inicializa los sockets de clientes */
		sockets[n] = -1; /* Significa "no conectado" */
	}
	for (;;) {
		fd_set lect;
		int max_fd = socket;

		FD_ZERO(&lect);/* Inicializa el conjunto vaco */
		FD_SET(socket, &lect);
		/* Recorre socket escucha + clientes (por eso parte de 0) */
		for (n = 0; n < MAX_CLIENTS; ++n) {
			if (sockets[n] >= 0) {/* Si est conectado */
				FD_SET(sockets[n], &lect);/* Se prepara para escuchas si socket */
				if (sockets[n] > max_fd) {/* Recuerda el socket ms grande */
					max_fd = sockets[n];
				}
			}
		}
		printf("?"); fflush(stdout);
		/* Espera por actividad de lectura (ie, escritura de los clientes) */
		if (select(1 + max_fd, &lect, NULL, NULL, NULL) < 0) {
			printf("~\n"); fflush(stdout);
			/* Si error, cierra los abiertos y termina [NO EVALUADO] */
			for (n = 0; n < MAX_CLIENTS; ++n) {
				if (sockets[n] >= 0) {
					printf("Cerrando slot %i socket %i\n", n, sockets[n]);
					close(sockets[n]);
				}
			}
			return EXIT_FAILURE;
		}
		printf("!\n"); fflush(stdout);
		/* Pregunta por conexiones entrantes */
		if (FD_ISSET(socket, &lect)) {/* Si hay conexin entrante */
			printf("Nueva conexin.\n");
			/* Busca dnde hay espacio vaco */
			for (n = 0; n < MAX_CLIENTS && sockets[n] >= 0; ++n)
				;
			if (n < MAX_CLIENTS) {/* Si hay espacio vaco */
				printf("Slot %i", n);
				sockets[n] = j_accept(socket);/* Acepta conexin */
				printf(" socket %i\n", sockets[n]);
			} else { /* Si no hay espacio vaco, se deja en espera */
				printf("No hay espacio.\n");
			}
		}
		/* Revisa dnde efectivamente se puede leer */
		for (n = 0; n < MAX_CLIENTS; ++n) {
			/* Si un cliente quiere escribir */
			if (sockets[n] >= 0 && FD_ISSET(sockets[n], &lect)) {
				char c; int m;
				/* Lee lo que escribi */
				if (read(sockets[n], &c, sizeof c) != sizeof c) {
					/* Si falla la lectura, est desconectado. SUPUESTO: No hay errores */
					printf("Error lectura: cerrando cliente %i\n", n);
					close(sockets[n]);/* Se cierra su socket */
					sockets[n] = -1;/* Se marca como cerrado */
					continue;/* Se busca a otro que quiera escribir */
				}
				printf("%c\n", c);
				/* Aqu se encuentra en c lo ledo desde 1 cliente */
				for (m = 0; m < MAX_CLIENTS; ++m) {/* Propaga lo ledo a los otros */
					/* Si est conectado y no es el emisor */
					if (sockets[m] >= 0 && m != n) {
						/* Enva contenido al otro cliente.
						SUPUESTO: Clientes siempre leen */
						printf("%i:%i -> %c\n", m, sockets[m], c);
						if (write(sockets[m], &c, sizeof c) != sizeof c) {
							/* Si error, el cliente se desconect */
							printf("Error escritura: cerrando cliente %i\n", m);
							close(sockets[m]);/* Cierra su socket */
							sockets[m] = -1;/* Lo marca como desconectado */
						}
					}
				}/* Siguiente cliente lector */
			}
		}/* Siguiente cliente emisor */
	}/* Siguiente ciclo de lectura */
}

/* Puntuacin (+1.0 base)
0.5 Crear Socket.
0.5 Ligar Socket a puerto PORT.
0.5 Esperar datos en socket BIND
0.5 Esperar datos en sockets clientes.
0.5 Recordar sockets clientes.
0.5 Omitir exceso de clientes.
1.0 Leer desde todos los clientes conectados.
1.0 Escribir lo ledo hacia todos los clientes, salvo el emisor.
1.0 Cerrar desconexiones e ignorar despus a desconectados.
*/
