#!/usr/local/bin/perl -w

# Apunte de Perl - CC31A Programacin de Software de Sistemas
# por Luis Len Crdenas Graide - lcardena [at] dcc [dot] uchile [dot] ce ele
# Por favor, avisar errores u omisiones.

# INTRODUCCIN:

# Slo hay comentarios de lnea y comienzan con "#". La extensin del archivo
# es '.pl', pero es optativo.

# La primera lnea es necesaria para que se pueda ejecutar bajo UNIX (La
# secuencia #! deben ser los primeros bytes en el archivo). La opcin "-w" hace
# que se muestren los warnings (MUY recomendable).

# Sintaxis similiar a C, pero ms parecida a PHP. Los ciclos deben ir entre
# {...} aunque sean de 1 sola instruccin. La ltima instruccin de un bloque
# puede no terminarse con ";". En ese sentido, ";" es un separador de
# instrucciones ms que un terminador de instrucciones (como ocurre en C).

# Hay recoleccin automtica de basura, as que no hay que hacer free() como en
# C. OJO: Se usa "Reference Counter", as que cuidado con las estructuras que
# tengan referencias cclicas (grafos, listas circulares, etc.): debe romperse
# la cadena a mano porque si no, no se recuperar la memoria (esto no ocurre en
# Java porque se usa "Mark and Sweep").

# Si no se especifica lo contrario, todas las variables son globales y se
# crean en su primer uso, inicializadas con 0, "" o () segn corresponda.

# Prctica MUY recomendable: Pedirle al lenguaje que restrinja el uso del
# lenguaje a 'buenas' prcticas:

use strict;

# Perl es un lenguaje dbilmente tipado y las variables casi no tienen tipo,
# slo los objetos contenidos en ellas. Hay tres tipos de variables:
# escalares, arreglos (listas) y hashes. Estos son los tipos de variables
# bsicas en Perl. Un escalar puede ser: un nmero (entero o flotante),
# un String o una referencia.

# ESCALARES:

# Las variables locales se declaran con "my" (MUY recomendable: NO usar
# variables globales). Los nombres de variables escalares comienzan con "$",
# los de arreglos, con "@" y los de hashes con "%".

my $variable_escalar;
my @un_arreglo;
my %un_hash;

# Las variables pueden inicializarse al momento de declararlas:

my $entero = 0;
my $decimal = 7.0;
my $enteroHex = 0x7F;
my $enteroOct = 0777;
my $enteroSeparadorDeMiles = 2_000_100_293;
my $string1 = "hola";
my $string2 = 'hola';

# Las variables escalares pueden contener indistintamente enteros, flotantes
# o strings. La interpretacin de los datos se hace segn el uso que se haga
# de ellos y el contexto en el que se den.

# Las operaciones bsicas son las mismas que C: +, -, *, /, ++, --, +=, -=,
# *=, /=, %, %=, &, &&, |, ||, &=, |=, ^, ^=, !, !=, ~, ~=, >, <, >>, <<,
# >>=, <<=, ==. Esto es para los tipos numricos. Los strings se pueden
# comparar con eq, lt, gt, lte, gte, ne. Las potencias son con **.

# Los strings se concatenan con el operador ".". Tambin existe el operador
# '.=' que concatena y asigna un string.

my $str = 'hola ' . 'y' . ' chao'; # Ac $str vale 'hola y chao'
$str .= ' le dijo'; # Ahora $str cale 'hola y chao le dijo'

# Para realizar comparaciones de orden (por ejemplo, en algoritmos de
# ordenamiento), existen operadores que retornan 1, 0  -1 segn el orden
# relativo de los comparandos. Para nmeros, dicho operador es "<=>". Para
# strings, es "cmp".

# Las sentencias de control son idnticas a C (ms algunas extensiones que
# se vern despus). Para sus condiciones de loop, los valores falsos son: 0,
# "" y "0". Todo lo dems se considera verdadero.

# INTERPOLACIN DE ESCALARES DENTRO DE STRINGS:

# Si en un string se usa '', se deja todo tal cual adentro del string. El
# caracter de escape es \ (como en C) y dentro de un string '' se puede escapar
# \' y \\. Si en un string se usa "", dentro de l se interpolan los valores de
# variables (reemplazo de los valores de las variables dentro del string).
# Dentro de un string '' se puede usar " tranquilamente y viceversa porque no
# hay confusin. Consejo: Usar " slo si se va a necesitar interpolar algo
# adentro; si no, usar ' (por claridad al depurar).

my $str = 'este signo: "$", es el signo de pesos';
my $inter = "ac va el valor '$str' de la variable \$str";

# Si el nombre de una variable se puede confundir con el texto, su nombre se
# encierra entre llaves despus del "$". Si el "$" se escapa con \, se usa
# como caracter normal y no como variable:

my $p = "(letra p)"; #Si no se usa interpolacin, da lo mismo " que '
my $traba = "pedro pablo prez $pereira, ${p}obre \$pintor portugus";

# Aqu $traba vale:
# "pedro pablo prez %ERROR% (letra p)obre $pintor portugus"
# El ERROR se produce porque no existe la variable $pereira.
# ${p} se interpola por "(letra p)".
# \$ escapa a "$" y no se interpreta como variable a "$pintor".

# Si se necesita generar string grande con un texto, se puede hacer "in
# situ". Ac hay un ejemplo en C:

char s[] = "Este texto es muy largo "
"y necesita ser escrito "
"en varias lneas "
"abriendo y cerrando comillas "
"a cada rato, en cambio en "
"Perl se puede hacer ms "
"simple.\n";

# Dentro de los strings, si son con ", se interpolan los caracteres
# especiales \n (newline), \t (tab), etc...

# En Perl se puede hacer lo siguiente:

my $texto = <<"FIN_DE_TEXTO"
Este texto es muy largo
y necesita ser escrito
en varias lneas
abriendo y cerrando comillas
a cada rato, en cambio en
Perl se puede hacer ms
simple.\n
FIN_DE_TEXTO
;

# Aqu, la secuencia '<<"FIN_DE_TEXTO"' es reemplazada por todo lo que venga
# a continuacin hasta encontrar el token 'FIN_DE_TEXTO'. Ojo con terminar la
# instruccin con un ; despus. Si el token se encierra entre "", las
# variables se interpolan en el texto (ideal para formularios web). Si el
# token se encierra entre '', no se interpola nada. Este mecanismo del "<<"
# se llama "Here Doc" (tambin se usa en las Shell).

# Otra similitud con las Shells es el uso de comillas graves para ejecutar
# comandos y capturar su salida (mtodo ineficiente, pero til en ocasiones):

my $e = `echo hola`;

# Esto ejecuta el comando "echo hola" y captura toda su salida estndar. Si hay
# newlines, los reemplaza por espacios simples. Luego, retorna ese string (el
# obtenido de toda su salida estndar). As que aqu $e vale "hola". Dentro de
# los acentos grave puede ir cualquier comando de Shell (ojo con escapar los
# caracteres especiales).

# Adems, las variables escalares se interpretan segn su uso,
# independientemente de si contienen enteros, flotantes o strings:

my $str = '13'; # El string "13"
my $i = 3; # El entero 3
my $r = ($str + $i) / 2; # Da (13 + 3) / 2 = 8

# Si los operandos son enteros, el resultado intenta ser entero, pero si se
# necesitara precisin, se hace decimal.

my $s = $str / 2; # Da 13 / 2 = 6.5

# Y los nmeros se cambian por strings tambin, trivialmente:

my $dream = "Tengo $i autos"; # Da "Tengo 3 autos"
my $concatenaciones = 'letra' . $i . $s; # Da "letra32.5"

# Las idas y vueltas son para cualquier parte:
my $n = 'Son ' . ((('1' . '3') + 1) / 2) . ' das'; # $n vale "Son 7 das"

# Si se intenta usar como nmero un string invlido, da 0:
my $m = 'hola' + 3; # Da 3

# Se pueden alterar los strings:

my $s = "hola\n";
my $t = "chao";
chop $t; # Remueve el ltimo caracter. Ahora $t = "cha".
chomp $s; # Remueve el ltimo caracter si es "\n". Ahora $s = "hola".
chomp $t; # $t sigue siendo "cha" porque 'a' ne "\n".

#  Las funciones en Perl pueden invocarse de dos formas:
# funcin param1, param2, param3, ..., paramN
# funcin(param1, param2, param3, ..., paramN)
#  Las funciones en Perl reciben siempre 1 argumento, donde ese argumento es
# una lista de parmetros. Si se encierran entre parntesis, se marca el fin de
# sus parmetros y as no hay confusiones de prioridad si hay muchas funciones
# evalundose en una misma expresin.

# Ejemplo: Supnganse las funciones "suma" y "potencia". Aqu hay ambigedad:
my $n = suma 2, 3, 5, potencia 2, 3, 9;

# La lista (2, 3, 9) Perl la interpreta como los argumentos de "potencia", que
# puede no ser lo que se quiere. Si se desea clarificar qu argumentos son de
# quin, se puede hacer:
my $n = suma 2, 3, 5, potencia(2, 3), 9;

# Aqu: $n = 2 + 3 + 5 + 8 + 9 = 27

# ARREGLOS Y LISTAS:

# Un arreglo (o lista) se declara anteponindole "@" a su nombre en vez de
# "$":

my @arr;

# Tambin se pueden preinicializar:
my @a = (2, 3, 5, 7, 11);

# Nadie dijo que los elementos deben ser del mismo tipo:
my @arr = (2, '3', 'cinco', 7, '11 se escribe "once"');

# Los elementos se subindican con [] (partiendo de 0 y terminando en el largo
# menos uno) y el resultado debe ser un escalar (por eso se antepone "$"):
my $t = ($arr[0] + $arr[1] * $arr[3]) . $arr[2]; # $t vale '23cinco'

# Estas expresiones tambin se pueden interpolar dentro de un string:
my $s = "La semana tiene $arr[3] das.";

# Los arreglos son del tamao que necesiten ser. Si se subindican ms all de
# su capacidad, el arreglo crece y se llena con valores 'undef':

$a[6] = 'extra'; # Ahora @a == (2, 3, 5, 7, 11, undef, 'extra')

# El valor 'undef' es una constante similar a 'NULL' en C, aunque ms similar a
# 'null' en Java.

# La expresin #$arr da el ndice del ltimo elemento del arreglo @arr:
my $k = $arr[#$arr]; #Ahora $k == 11

# El valor que retorne el uso de un arreglo depende del contexto en el que se
# use. Los contextos son "escalar" y "lista" (o arreglo). As, lo siguiente da
# resultados distintos:

# Aqu @copiaDelArreglo tambin contiene (2, 3, 5, 7, 11, undef, 'extra')
my @copiaDelArreglo = @a;

# Ac, @a se evala en contexto escalar, as que retorna su tamao
my $numeroElementos = @a; # $numeroElementos == 7

# OJO: @copiaDelArreglo != @a porque son dos encarnaciones distintas del
# arreglo. Son copias de contenido, no de referencias.

$copiaDelArreglo[6] = 13;
my $c = ($copiaDelArreglo[6] == $a[6]); # $c vale 0 (falso)

# En contexto escalar, la constante undef se evala como el string '', lo que
# da falso si se usa en como condicin lgica en un if, while, for, etc.

# Se puede forzar la evaluacin de una expresin en contexto escalar con la
# funcin scalar().

my $r = scalar(@copiaDelArreglo) * 2;
# Fuerza que @copiaDelArreglo se evale como escalar, as que da su tamao, que
# es 7, por lo que $r vale 14.

# Los arreglos tambin son listas:
push @copiaDelArreglo, 15; # Apila el valor al final del arreglo
#Ac: @copiaDelArreglo = (2, 3, 5, 7, 11, undef, 'extra', 15)

my $ultimo = pop @copiaDelArreglo; # Desapila el ltimo elemento del arreglo.
#Ac: @copiaDelArreglo = (2, 3, 5, 7, 11, undef, 'extra') y $ultimo = 15

my $primero = shift @copiaDelArreglo; # Saca el primer elemento del arreglo.
#Ac: @copiaDelArreglo = (3, 5, 7, 11, undef, 'extra') y $primero = 15

unshift @copiaDelArreglo, 1; # Inserta elementos delante del arreglo
#Ac: @copiaDelArreglo = (1, 3, 5, 7, 11, undef, 'extra')

# Las funciones push y unshift permiten una lista de valores en vez de uno, de
# modo que se realicen varias inserciones en vez de una sola.

# Se pueden hacer reemplazos de elementos al interior de un arreglo en forma
# trivial con la funcin splice:
splice ARRAY,OFFSET,LENGTH,LIST
splice ARRAY,OFFSET,LENGTH
splice ARRAY,OFFSET
splice ARRAY

# Esto reemplaza la lista LIST en la lista ARRAY a partir de la posicin OFFSET
# de ARRAY, considerando LENGTH elementos. Por ejemplo:

my @array = (2, 3, 5, 7, 11, 13);
my @list = (-3, -5, -7);
splice @array, 1, 4, @list;

# Ahora @array = (2, -3, -5, -7, 13)

# OJO: LENGTH no tiene por qu ser igual que scalar(@list). Puede ser de
# cualquier tamao. Ntese que @list no tiene por qu ser una variable, puede
# ser perfectamente el resultado de otra expresin que retorne una lista.

# Esta funcin toma el arreglo ARRAY y reemplaza en l LENGTH elementos a
# partir de OFFSET por la lista LIST, la que puede ser de cualquier tamao.
# As, las funciones push, pop, shift y unshift podran expresarse de la
# siguiente forma (por cierto, menos eficiente):
push(@a,$x,$y)      splice(@a,@a,0,$x,$y)
pop(@a)             splice(@a,-1)
shift(@a)           splice(@a,0,1)
unshift(@a,$x,$y)   splice(@a,0,0,$x,$y)
$a[$x] = $y         splice(@a,$x,1,$y)

# Lamentablemente, no hay arreglos multidimensionales, as que hay que hacer
# arreglos de referencias a arreglos, lo que se ver despus.

# HASHES (ARREGLOS ASOCIATIVOS):

# Los hashes son arreglos asociativos donde la llave puede ser cualquier valor
# escalar y el valor asociado puede ser cualquier otro escalar.

my %hash; # Declara un hash vaco.

# Sus llaves se subindican entre llaves {...}. Ntese que se obtiene un escalar.
$hash{'pedro'} = 24; # Asocia 24 a 'pedro'
$hash{'paola'} = 20; # Asocia 20 a 'paola'

my $e = $hash{'pedro'} + $hash{'paola'}; # Da 44

# La llave puede ser cualquier escalar: enteros, referencias, strings,
# flotantes.

# Como la llave del hash va entre llaves, puede omitirse las comillas para los
# strings si no se presta para confusiones.

my $e = $hash{pedro} + $hash{paola}; # Da 44

# Los hashes pueden preinicializarse al momento de declararlos. Eso se hace
# igual que con un arreglo, pero la lista debe tener una cantidad PAR de
# elementos, donde cada par de elementos representa al par llave/valor:

%hash = ('2', 2, '3', 'f'); # Asocia '2' => 2 y '3' => 'f'

# La llave usada suele ser un string (aunque puede ser otra cosa). Como puede
# ser engorroso tener que poner las comillas a cada llave cuando son muchas, se
# puede provee la siguiente sintaxis equivalente, evitando las comillas de los
# strings cuando son llaves:

%hash = (2 => 2, 3 => 'f', casa => 'pedro');
# Asocia: '2' => 2, '3' => 'f', 'casa' => 'pedro'

# Tambin un valor en un hash puede interpolarse dentro de un string:
my $str = "La sexta letra es '$hash{3}'"; # Da "La sexta letra es 'f'"

# Se puede borrar un par llave/valor del hash indicando la llave:

delete $hash{casa}; # Borra el par ('casa', 'pedro').
# Ahora %hash = (2 => 2, 3 => 'f')

# Y se puede preguntar por la existencia de una llave en un hash:

exists $hash{2}; # Da verdadero
exists $hash{casa}; # Da falso

# Se puede obtener la lista de llaves del hash y la lista de valores:
my @llaves = keys %hash; # Da ('2', '3')
my @valores = values %hash; # Da (2, 'f')

# Los hashes soportan hasta 32767 pares llave/valor.

# REFERENCIAS:

# Se puede obtener una referencia a cualquier cosa: a un escalar, a un arreglo,
# a un hash o a otra referencia (porque es un escalar). Para ello se usa el
# caracter \ (es anlogo al & de C). Una referencia es un escalar.

my $n = 10;
my $e = \$n; # $e es una referencia a $n
my $l = \@llaves; # $r es una referencia al arreglo @llaves
my $h = \%hash; # $h es una referencia al hash %hash

# Una referencia se puede desreferenciar de dos formas: recuperando el objeto
# apuntado o accediendo a l indirectamente.

# Recuperacin de los objetos apuntados
my $ee = $$e; # $ee contiene al valor de $n = 10
my @ll = @$l; # @ll contiene al arreglo apuntado por $l
my %hh = %$h; # %hh contiene al hash apuntado por $h

# Las variables se pueden modificar indirectamente:
$$e = 11; # Ahora $n = 11

# Se puede acceder a los objetos en forma indirecta con el operador -> (igual
# que en C). Esto sirve para hashes y arreglos:

$l->[1] = 99; # Ahora @llaves = (2, 99)
$h->{'3'} = 'hola'; # Ahora %hash = (2 => 2, 3 => 'hola')

# Por comodidad, se puede generar una referencia a un arreglo o a un hash en
# forma inmediata (sin aplicar \):

# Ntense los corchetes: [...]
my $refArr = [2, 3, 5, 7, 11];
# Ntense las llaves: {...}
my $refHash = {a => 1, b => 2, 3 => c, arr => $refArr};

# Se puede preguntar si un escalar es o no referencia:
ref $refArr; # Da verdadero

# Se puede preguntar si el resultado de una expresin es o no undef:
defined $refArr->[2]; # Da true
defined $refArr->[100]; # Da false

# Una variable se puede indefinir:
undef $refArr;
# Ahora $refArr no sirve para nada ms y se puede reutilizar su nombre.
# Hacer uso de esto es una muy mala prctica de programacin porque ofusca el
# cdigo.

# Una variable se puede inicializar con un valor indefinido:
my $u = undef;

# Con referencias, se pueden hacer arreglos "multidimensionales" (o sea,
# arreglos de arreglos):

my @a = ([1, 2], [3, 4], [5, 6]);
# Arreglo de 3 referencias a arreglos de 2 enteros

# Y se puede acceder a sus elementos:
$a[1]->[0] # Da 3

# Por cierto que se pueden construir en tiempo de ejecucin y no slo
# predefinidos:

my @a, @b, @c, @d; # my soporta listas de declaraciones e inicializaciones
$b[0] = 1; $b[1] = 2; # Se puede hacer de varias formas
@c = (3, 4);
@d = (5, 6);
$a[0] = \@b;
pop @a, \@c, \@d;

# Se pueden rescatar los valores de un arreglo que sean interesantes:
my @z = (10, 20, 30, '40', 'cincuenta');
my ($a, $b, undef, $d) = @z; # Rescata 10, 20 y '40'.
# Los no usados se descartan ('cincuenta'). Con undef se ignora un valor (30).
# Los valores que sobren tambin se ignoran.

# CONTROL DE FLUJO:

# Para controlar el flujo de un programa, existen sentencias de control muy
# similares a las de C:

if (condicin) {# Las llaves son obligatorias
	# ...
} elsif (condidin) {
	# ...
} elsif (condicin) {
	#...
# ...
} else { # Optativo

}

# Ojo: una condicin es un escalar. Si hay una lista, se fuerza su evaluacin
# en contexto escalar, lo que da su tamao y ese nmero se utilizar como
# condicin. Un hash en contexto de lista se interpreta como la lista de pares
# llave/valor.

# Hay una forma alternativa:
hacer_esto if condicin;

# Tambin existe la negacin ("a menos que"):
unless (condicin) {
	# ...
}

# Que equivale a:
if (!condicin) {
	# ...
}

# Y que se puede usar como:
hacer_esto unless condicin;

# Para las expresiones lgicas, con el fin de ahorrar parntesis, hay sinnimos
# de los operadores lgicos de alta prioridad &&, || y !, con baja prioridad:
# and, or y not. As, lo siguiente se puede escribir de dos formas:
if ((cond1 && cond2) || (cond3 && cond4)) { ... }
if (cond1 && cond2 or cond3 && cond4) { ... }

# Para hacer ciclos:
while (condicin) { # Llaves obligatorias
	# ...
}

# Hay tres instrucciones de salto al interior de un ciclo:
last; # Termina el ciclo: Es como break de C.
next; # Ejecuta los incrementadores si se trata de un ciclo for, evala la
      #  condicin y vuelve a ejecutar el ciclo si da verdadero. Es como
      #  continue de C.
redo; # Repite el ciclo sin evaluar la condicin ni ejecutar los incrementos.

# Los ciclos pueden ser etiquetados con un label (como en C) y se puede
# especificar a qu ciclo aplicar el last/next/redo indicando el label.

L1: while (...) {
        ...
	L2: for (...;...;...) {
		...
		if (...) {
			...
			next L1;
		}
		...
	}
	...
}

# El ciclo for es igual a C:
for (inicializaciones; condicin; incrementos) {
	# ...
}

# Las inicializaciones pueden incluir a my para variables locales.
for (my $i = 0; $i < scalar(@lista); $i++) {
	# Algo con $lista[$i]
}

# Dado que es comn iterar sobre listas, se puede hacer con:
foreach declaracin_iterador (lista) {
	# ...
}

# Ejemplo: $l va tomando cada valor de la lista @arr. Con my se hace local.
foreach my $l (@arr) {
	# Algo con $l
}

# Aqu tambin operan next (siguiente elemento de la lista), last (rome el
# ciclo) y redo (repite el ciclo con el elemento actual).

# FUNCIONES BSICAS:

chr NUMBER
chr
# Retorna un string de un caracter cuyo cdigo ASCII es NUMBER

hex EXPR
hex
# Convierte el string EXPR que representa un nmero hexagesimal y lo convierte
# a entero.

index STR,SUBSTR,POSITION
index STR,SUBSTR
# Retorna el ndice a partir de POSITION desde el que est contenido SUBSTR
# dentro de STR. Los caracteres de los strings parten enumerndose desde 0.

lc EXPR
lc
# Retorna el string EXPR convertido a minsculas.

length EXPR
length
# Retorna el largo del string EXPR. Ojo: ac no se usa el '\0' final.

oct EXPR
oct
# Interpreta EXPR como un string octal y retorna el entero equivalente.

ord EXPR
ord
# Retorna el cdigo ASCII del string EXPR de un slo caracter.

rindex STR,SUBSTR,POSITION
rindex STR,SUBSTR
# Anlogo a index, pero de derecha a izquierda.

substr EXPR,OFFSET,LENGTH,REPLACEMENT
substr EXPR,OFFSET,LENGTH
substr EXPR,OFFSET
# Retorna un substring del string EXPR a partir de OFFSET y de largo LENGHT.

uc EXPR
uc
# Anlogo a lc, pero a maysculas.

split /PATTERN/,EXPR,LIMIT
split /PATTERN/,EXPR
split /PATTERN/
split
# Toma el string EXPR y lo divide en tantos tokens como calce PATTERN,
# retornando una lista con los tokens resultantes (es un StringTokenizer de
# Java, pero que adems soporta expresiones regulares). OJO: Se salta los
# separadores que se encuentren juntos.

join EXPR,LIST
# Retorna un string producido mediante la concatenacin de todos los elementos
# de LIST, intercalando EXPR.

reverse LIST
# Da vuelta la lista LIST

sort SUBNAME LIST
sort BLOCK LIST
sort LIST
# Ordena la lista LIST (ascendentemente). Si se especifica, se usa la funcin
# comparadora SUBNAME. Si se especifica un bloque BLOCK in situ, se usa lo que
# retorne para comparar (1, 0  -1). Dentro del bloque, hay dos variables $a y
# $b que tienen los elementos comparados.

# Ejemplo:
my @ar = (3, 1, 5);

# Primera forma:
my @b = sort @ar;

# Segunda forma: Cada par de elementos que se compare se dejan en unas
# variables llamadas $a y $b.
my @b = sort {if ($a > $b) { 1 } elsif ($a < $b) { -1 } else { 0 }} @ar;
# El valor retornado por un bloque es el ltimo valor evaluado en l.

# Tercera forma:
my @b = sort {$a - $b} @ar;

# Cuarta forma:
my @b = sort {$a <=> $b} @ar;
# Si hubieran sido strings, se habra usado cmp. Si se quisiera orden inverso,
# se intercambia $a con $b. El caso con funciones se ver despus.

each HASH
# Permite iterar sobre un hash. En cada iteracin retorna una lista de dos
# elementos: una llave y su valor asociado. Al acabar con todos los pares,
# retorna la lista vaca.

# Ejemplo:
%hash = (hugo => 10, paco => 20, luis => 30);
while (my ($llave, $valor) = each %hash) {
	# Algo con $llave y $valor
}
# Al acabar el hash, la lista vaca en contexto escalar retorna cero (su
# tamao), lo que es falso y termina el while.

die LIST
# Termina el programa mostrando el mensaje de error resultante de la
# concatenacin de los elementos de la lista LIST.

exit EXPR
# Termina el programa retornando el cdigo de error EXPR. Tpicamente 0 indica
# que todo sali OK.

# Otra similitud con las Shells es el uso de operadores lgicos por
# cortocircuito para evaluar expresiones:

# or es la versin de baja prioridad de || y evala lo de la derecha si lo de
# la izquierda da falso (caso de error):
haz_esto_importante or haz_esto_otro_si_lo_anterior_falla;

# Uso tpico (versiones similares):
haz_esto_importante or die 'No se pudo hacer eso importante';
die 'error' if esto_importante_falla;
die 'error' unless esto_importante_funcione;

# and es la versin de baja prioridad de && y evala lo de la derecha si lo
# de la izquierda da verdadero (caso de xito):
haz_esto and haz_esto_otro_si_lo_anterior_funciona;

# PARMETROS DEL PROGRAMA:

# Al comenzar el programa hay un arreglo @ARGV con el listado de parmetros,
# sin incluir el nombre del programa. Tambin hay un hash %ENV con las
# variables de entorno. As, $ENV{'HOME'} dara el string con la ruta del
# directorio home del usuario actual.

# Hay una variable global para uso general: $_. En ella, algunas funciones
# dejan su resultado por defecto. Muchas funciones utilizan automticamente a
# $_ como parmetro si no se les indica ninguno (ver en el listado anterior de
# las funciones que tienen versiones con y sin parmetros). Asimismo, hay
# funciones que hacen lo mismo con el arreglo por defecto @_.

# FUNCIONES:

# La forma tpica de una funcin es:
sub nombre_funcion {
  # Las funciones siempre reciben listas variables de parmetros. No tienen una
  # cantidad fija de parmetros. Es responsabilidad del usuario el llamar a las
  # funciones con los parmetros correctos. No hay sobrecarga de funciones. Es
  # la funcin la que debe saber comportarse segn el nmero (y tipo) de
  # parmetros con los que la invoquen. Los parmetros de la funcin vienen en
  # el arreglo por defecto @_ y ella debe rescatarlos. Tpicamente, se hace:

  my ($param1, $param2, ..., $paramN) = @_;

  # Esto sirve para una cantidad fija (o conocida) de parmetros. Si se tiene
  # algo variable, se pueden ir rescatando los valores con shift y pop
  # aplicados a @_.

  # ... Cuerpo de la funcin

  return algo; # Optativo segn la funcin
}

# TODAS las funciones retornan algo. Si una funcin no incluye la clusula
# return, retorna el ltimo valor evaluado. Por ltimo, por claridad, se puede
# hacer que las funciones de "tipo void" (que no existen en Perl), retornen
# undef.

# TODAS las funciones deben ser declaradas antes de usarse (como en C). Eso se
# consigue bien sea con:

  sub nombre_funcion; # Aqu se declara

  # Aqu se usa

  sub nombre_funcion { # Aqu se define
    #...
  }

# O bien, definindola desde un comienzo:

  sub nombre_funcin {

  }

  # Aqu se usa.

# Si se quiere usar una funcin antes de declararla, se le debe anteponer & al
# nombre (recomendable). Por simplicidad, basta con poner siempre '&' al nombre
# de cada funcin al momento de llamarla y as se evita el tener que
# preocuparse de haberla definido previamente (si ya fue predefinida, no hay
# problema con usar '&'). Una funcin puede invocarse sin parntesis: slo
# listando sus parmetros a continuacin. Se debe usar parntesis si puede
# haber conflictos de prioridad con funciones cuyos valores de retorno se usen
# como parmetros de otra funcin.

# Se puede obtener un puntero a una funcin con \nombre_funcin. Dicho puntero
# se puede guardar en una variable escalar. Se pueden definir funciones dentro
# de funciones y se pueden retornar punteros a esas funciones definidas
# localmente. Tambin pueden haber funciones annimas que se apliquen
# inmediatamente.

# Ejemplo:

# Funcin de prueba. Recibe un arreglo de valores. Toma el primero y lo
# interpreta como un factor multiplicativo con el que pondera el resto de los
# nmeros de la lista, retornando su suma.
sub sumador {
	my $factor = shift @_;
	my $suma = 0;
	foreach my $x (@_) {
		$suma += $factor * $x;
	}
	return $suma;
}

my @lista = (2, 3, 4, 5);
my $refFunc = \&sumador; # Referencia a la funcin
my $suma = &$refFunc(2, @lista); # &$refFunc es la funcin. Retorna 28.

# Ntese que la concatenacin de listas es trivial: Al expresar una lista
# formada por listas, cada una de las listas que la componen se expande y se
# concatenan automticamente dando como resultado a la lista unida.

my @a = (1, 2, 3); my @b = (7, 8, 9, 10);
my @c = (0, @a, 4, 5, 6, @b, 11);
# Ac @c = (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)

# Hay una funcin que redibe dos parmetros: una funcin y una lista. Luego
# aplica la funcin a cada elemento de la lista y retorna una lista con los
# resultados de la aplicacin de la funcin a cada elemento:
map BLOCK LIST
map EXPR,LIST

# Ejemplo:
my @doble = map {2 * $_} (2, 3, 4); # Da (4, 6, 8)
# Ntese que cuando se especifica el bloque, el elemento de la lista que se
# est evaluando se guarda en la variable por defecto: $_

my @alfabeto = map chr, (65..90); # Da ('A'..'Z')
# La expresin 65..90 genera la lista que contiene los nmeros desde 65 a 90.
# Tambin sirve para strings (genera strings consecutivos). Los extremos pueden
# ser variables. Si en vez de () se usa [] se genera una referencia a la lista.

# Ejemplo: Ordenar las llaves de un hash segn su valor asociado:

my %h = (2 => 'a', 3 => 'd', 1 => 'b');

sub comparador {
	my ($izq, $der) = @_;

	return $izq cmp $der; # Compara strings
}

my @llaves = sort {&comparador $h{$a}, $h{$b}} keys %h;

# Tambin podra hacerse:
my @llaves = sort {$h{$a} cmp $h{$b}} keys %h;

# Ejemplo: Ordenar personas por apellido:

my $personas = { # Referencia a un hash
	10326763-7 => { # Par: rut -> referencia a hash
		nombre => Andrs,
		apellido => Jimnez
	},
	15498135-5 => {
		nombre => Andrea,
		apellido => Torres
	},
	 5489465-4 => {
		nombre => Claudio,
		apellido => Prez
	}
};

my @lista = sort {$personas->{$a}->{apellido} cmp $personas->{$b}->{apellido}} keys %$personas;
# Ahora @lista = ('10326763-7', '5489465-4', '15498135-5')

# En cualquier expresin, se puede preguntar el contexto en el que se est
# evaluando para saber si se est pidiendo un arreglo o un escalar. Ejemplo:

sub preguntadora {
	# wantarray dice en qu contexto se est evaluando la funcin
	if (wantarray) {
		return ('se', 'quiere', 'un', 'arreglo');
	} else {
		return 'se quiere un escalar';
	}
}

my @a = preguntadora(); # @a = ('se', 'quiere', 'un', 'arreglo')
my $b = preguntadora(); # $b = 'se quiere un escalar'

# ENTRADA/SALIDA:

# El operador de lectura es '<>'. Si no se especifica nada, lee de la entrada
# estndar. Si se evala en contexto escalar, lee una lnea (incluyendo
# newline). OJO: Los newline no son los mismos en Unix/Linux ("\n") que en
# Windows ("\r\n") ni Mac ("\r"). chomp puede comportarse "extraa". Si <> se
# evala en contexto de lista lee TODA la entrada estndar y retorna una lista
# donde cada elemento es una lnea. Al llegar a EOF retorna undef.

my $linea = <>; # Lee una lnea de la entrada estndar
my @lineas = <>; # Lee TODA la entrada estndar (una lnea por elemento)

# Al comenzar el programa hay tres filehandles abiertos por defecto: STDIN,
# STDOUT y STDERR (correspondientes a la entrada estndar, salida estndar y
# salida de error, respectivamente). Para leer de un filehandle especfico, se
# puede usar <MI_FILEHANDLE>, donde MI_FILEHANDLE es un filehandle para lectura
# (por ejemplo, STDIN). As que <> es una abreviacin para <STDIN>, salvo un
# pequeo detalle: Si se usa <> y @ARGV tiene parmetros, lo que Perl hace
# automticamente es ir interpretando los elementos de @ARGV como nombres de
# archivo y los va abriendo uno tras otro, mientras que <> va leyendo de cada
# archivo hasta finalizar con ellos, retornando undef cuando se llega al EOF
# del ltimo archivo. Adems, si el resultado de <> no se asigna a nada, su
# resultado queda guardado en la variable por defecto $_.

# Para dar salida a los programas existe la funcin print, que recibe,
# optativamente, un filehandle al cual escribir (si no se especifica, usa por
# defecto a STDOUT) y a continuacin una lista, cuyos elementos interpreta como
# string, imprimiendo sus elementos uno tras otro (como si se concatenaran).

# Ejemplos:
print; # Imprime $_ (por STDOUT)
print 'hola'; # Imprime 'hola' sin "\n" al final (por STDOUT)
print "hola\n"; # Imprime 'hola' seguido de "\n" (por STDOUT)
print 'hola', "\n"; # Imprime 'hola' seguido de "\n" (por STDOUT)
print STDOUT "hola\n"; # dem
print STDERR "error\n"; # Imprime 'error' seguido de "\n" por STDERR
# Imprime 'hola qu tal' seguido de "\n" por STDOUT
print STDOUT 'hola ' . 'qu' . ' tal', "\n";

# Con esto, se puede implementar el comando 'cat' de UNIX trivialmente:

# Versin 1: Lee de entrada estndar
while (my $linea = <STDIN>) {
	print STDOUT $linea;
}

# Versin 2: Lee de los parmetros. Si no hay, lee de entrada estndar
while (my $linea = <>) {
	print $linea;
}

# Versin 3: Usando variables por defecto:
while (<>) {
	print;
}

# Versin 4: Usando MUCHA memoria:
my @lineas = <>;
print @lineas;

# Versin 5: El cat ms corto del mundo (y que usa ms memoria):
print <>;

# Versin 6: Aprovechndose del cat del sistema (usando mucha memoria):
print `cat`;

# OJO: El filehandle que se antepone a la lista de parmetros de print no es un
# parmetro, es un modificador de la funcin.

# MANEJO ARCHIVOS:

# Nota: Los filehandles se escriben EN MAYSCULAS y son globales al programa.

# Para abrir archivos se usa tpicamente la funcin open:
open FILEHANDLE,MODE,LIST
open FILEHANDLE,EXPR       # El que ms se usa
open FILEHANDLE

# Ejemplos:
open ENTRADA, "<archivo"; # Puede haber interpolacin en el string
# Abre el archivo 'archivo' para lectura y habilita el filehandle ENTRADA para
# leer desde l.

open SALIDA, ">archivo";
# Abre el archivo 'archivo' para excritura y habilita el filehandle SALIDA para
# escribir en l. Si el archivo ya exista, lo reemplaza.

open SALIDA, ">>archivo";
# Similar al caso anterior, pero si exista, escribe desde el final.

open PIPEOUT, "|programa";
# Ejecuta el programa 'programa' y habilita el filehandle PIPEOUT para escribir
# a la entrada estndar del programa.

open PIPEIN, "programa|";
# Ejecuta el programa 'programa' y habilita el filehandle PIPEIN para leer
# desde la salida estndar del programa.

open READWRITE, "+<archivo";
open READWRITETRUNC, "+>archivo";
# Permite leer y escribir al archivo mediante el filehandle. En el segundo caso
# primero trunca el archivo a tamao 0. OJO: Se requiere que el archivo sea
# binario para accesos a travs de registros de largo fijo.

# open retorna undef en caso de error. En caso de xito, retorna distinto de
# cero. Si se abre un pipe, retorna el pid del proceso ejecutado.

# Uso tpico:
open LEER, '<archivo' or die 'No se pudo abrir el archivo.';

# Si se desea abrir un archivo cuyo nombre contiene alguno de los carcteres
# especiales '>', '<', '>>', '+<', '+>', '|', etc., se puede usar la funcin
# sysopen que no interpreta estas secuencias como especiales:

sysopen FILEHANDLE,FILENAME,MODE
sysopen FILEHANDLE,FILENAME,MODE,PERMS

# A continuacin se presentan otras funciones de entrada/salida:

binmode FILEHANDLE, DISCIPLINE
binmode FILEHANDLE
# Hace que las subsecuentes operaciones de lectura o escritura sobre el
# filehandle se realicen en modo binario y no en modo texto. Debe ser la
# primera operacin realizada sobre el filehandle (antes de cualquier otra
# operacin de I/O).

close FILEHANDLE
close
# Cierra el filehandle. Vaca los buffers si es que estn llenos.

eof FILEHANDLE
eof ()
eof
# Informa si la siguiente operacin de lectura sobre FILEHANDLE ser sobre el
# fin del archivo o no. eof sin parmetros informa sobre el fin del archivo
# actualmente abierto por <>. eof() pregunta sobre el ltimo archivo.

getc FILEHANDLE
getc
# Lee un caracter del FILEHANDLE (por defecto, STDIN). No retornar nada hasta
# que el usuario ingrese una lnea completa.

flock FILEHANDLE,OPERATION
# Bloquea el recurso manejado por FILEHANDLE (tpicamente un archivo) de modo
# que otros procesos no puedan leer/escribir en l.

fileno FILEHANDLE
# Retorna el file descriptor asociado al FILEHANDLE. Si dos filehandles tienen
# el mismo file descriptor, son el mismo recurso.

seek FILEHANDLE,POSITION,WHENCE
# Permite desplazarse dentro del archivo controlado por FILEHANDLE.

tell FILEHANDLE
tell
# Retorna la posicin actual dentro de FILEHANDLE  -1 en caso de error.
# Tpicamente retorna -1 sobre sockets, pipes, etc.

truncate FILEHANDLE,LENGTH
truncate EXPR,LENGTH
# Trunca el tamao del archivo al largo especificado.

chmod LIST
# Cambia los permisos de la lista de archivos. El primer elemento de la lista
# debe ser el modo (numrico), el que puede ser un octal y que NO debe ser un
# string de dgitos octales. 0644 est bien. '0644' NO est bien. Retorna el
# nmero de archivos exitosamente cambiados.

# Me aburr de traducir. Ahora en ingls:

chown LIST
# Changes the owner (and group) of a list of files. The first two elements of
# the list must be the numeric uid and gid, in that order. A value of -1 in
# either position is interpreted by most systems to leave that value unchanged.
# Returns the number of files successfully changed.

chroot FILENAME
chroot
# This function works like the system call by the same name: it makes the named
# directory the new root directory for all further pathnames that begin with a
# / by your process and all its children. (It doesn't change your current
# working directory, which is unaffected.) For security reasons, this call is
# restricted to the superuser. If FILENAME is omitted, does a chroot to $_.

# Bueno, basta por ahora. Para continuar, chenle una mirada a las funciones:
-X, chdir, closedir, gmtime, link, localtime, lstat, mkdir, open, opendir,
printf, read, readdir, readlink, rename, rewinddir, rmdir, seekdir, stat,
symlink, syscall, sysread, syswrite, syswrite, telldir, time, times, umask
unlink, utime, vec, warn, write

# EXPRESIONES REGULARES:

# Un string se puede calzar con una expresin regular. Una expresin regular
# puede contener los siguientes caracteres especiales:

#    \   Quote the next metacharacter
#    ^   Match the beginning of the line
#    .   Match any character (except newline)
#    $   Match the end of the line (or before newline at the end)
#    |   Alternation
#    ()  Grouping
#    []  Character class

# Las expresiones regulares se pueden cuantificar:

#    *      Match 0 or more times
#    +      Match 1 or more times
#    ?      Match 1 or 0 times
#    {n}    Match exactly n times
#    {n,}   Match at least n times
#    {n,m}  Match at least n but not more than m times

# Se pueden calzar tipos de caracteres:

#    \w  Match a "word" character (alphanumeric plus "_")
#    \W  Match a non-"word" character
#    \s  Match a whitespace character
#    \S  Match a non-whitespace character
#    \d  Match a digit character
#    \D  Match a non-digit character
#    \pP Match P, named property.  Use \p{Prop} for longer names.
#    \PP Match non-P
#    \X  Match eXtended Unicode "combining character sequence",
#        equivalent to C<(?:\PM\pM*)>
#    \C  Match a single C char (octet) even under utf8.

# El operador de pattern-matching es =~ (y el de no calce es !~):

while (my $string = <>) {
	if ($string =~ m/-?[0-9]*\.[0-9]+/) {
		print "$string es un nmero decimal\n";
	}
}

# Vamos por partes:
# 1) =~ retorna verdadero si el string calza con la expresin regular.
# 2) m indica que el siguiente caracter ('/' en este caso) ser el que indicar
#      el inicio o trmino de la expresin regular. Si dentro de la expresin
#      regular se quiere usar un '/', habra que escaparlo con \. Se puede
#      usar cualquier otro caracter para encerrar la expresin regular, el
#      cual debe seguir a 'm'. Esto permite expresar cmodamente expresiones
#      regulares que usan '/' de modo que no tenga que escaparse a cada rato.
# 3) A continuacin del ltimo '/' se puede anexar una serie de caracteres que
#    pueden modificar el comportamiento de =~. Dichos caracteres son:

# i
# Do case-insensitive pattern matching. If use locale is in effect, the case
# map is taken from the current locale. See the perllocale manpage.
# m
# Treat string as multiple lines. That is, change ``^'' and ``$'' from matching
# the start or end of the string to matching the start or end of any line
# anywhere within the string.
# s
# Treat string as single line. That is, change ``.'' to match any character
# whatsoever, even a newline, which normally it would not match. The /s and /m
# modifiers both override the $* setting. That is, no matter what $* contains,
# /s without /m will force ``^'' to match only at the beginning of the string
# and ``$'' to match only at the end (or just before a newline at the end) of
# the string. Together, as /ms, they let the ``.'' match any character
# whatsoever, while still allowing ``^'' and ``$'' to match, respectively, just
# after and just before newlines within the string.
# x
# Extend your pattern's legibility by permitting whitespace and comments.

# Si se desea rescatar patrones dentro de una expresin regular, dichos patrones
# deben encerrarse entre parntesis, lo que permitir despus rescatarlos. En
# tal caso, =~ retorna el nmero de patrones rescatados:

while (1) {
	print 'Ingrese una fecha (dd/mm/aaaa): ';
	# Lee una lnea de la entrada estndar
	my $string = <>;
	# Le saca el newline
	chomp $string;
	# Termina si no est definido o si no se ingresa nada
	last unless (defined $string and $string gt '');
	# Calza el string rescatando $1 = da, $2 = mes, $3 = ao
	if ($string =~ m%^(\d?\d)/(\d?\d)/(\d\d\d\d)$%) {
		print "Ao = $3, Mes = $2, Da = $1\n";
	} else {
		print "'$string' no es una fecha vlida.\n";
	}
}

# 1) Por comodidad, la expresin regular se encerr entre '%' en vez de '/' ya
# que la fecha contiene '/'s.
# 2) El patrn calzado por (\d?\d) queda en la variable $1. El patrn calzado
# por (\d?\d) queda en $2 y (\d\d\d\d) queda en $3.
# 3) ^ y $ calzan con el comienzo y el fin del string, respectivamente. Si no
# se especificara, se calzara el patrn %^(\d?\d)/(\d?\d)/(\d\d\d\d)$% en
# cualquier parte del string, lo que no se quiere porque pasaran caracteres no
# deseado al comienzo y al final.

# Se pueden realizar reemplazos en strings usando expresiones regulares. Para
# ello se debe anteponer 's' (sustitute) en vez de 'm' (match).

while (1) {
	print 'Ingrese un nombre de archivo: ';
	# Lee una lnea de la entrada estndar
	my $string = <>;
	# Le saca el newline
	chomp $string;
	# Termina si no est definido o si no se ingresa nada
	last unless (defined $string and $string gt '');
	# Calza el string rescatando $1 = da, $2 = mes, $3 = ao
	$string =~ s/ /_/g;
	print "$string\n";
}

# 1) El calce realizado con 's' costa de dos partes: /primera/segunda/. La
# primera indica qu reemplazar (aquello con lo que calce) y la segunda indica
# con qu reemplazar.
# 2) El modificador 'g' se usa para que realice TODOS los calces que pille. Si
# no se especificara, reemplazara slo el primer calce.

while (1) {
	print 'Ingrese un texto con espacios seguidos: ';
	# Lee una lnea de la entrada estndar
	my $string = <>;
	# Le saca el newline
	chomp $string;
	# Termina si no est definido o si no se ingresa nada
	last unless (defined $string and $string gt '');
	# Calza el string rescatando $1 = da, $2 = mes, $3 = ao
	$string =~ s% +% %g;
	print "$string\n";
}

# Esto reemplaza todos los espacios consecutivos por uno slo.

# Dnde encontrar ms ayuda?
# % perldoc
