#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <errno.h>
#include <sys/types.h>
#include <pthread.h>

void producer(unsigned int *arg);
void consumer(unsigned int *arg);
unsigned int count, data, consumed, produced;

int main(int argc, char *argv[]) {
	unsigned int n = ((argc == 2) ? atoi(argv[1]) : 1);
	pthread_t t1, t2;

	count = data = consumed = produced = 0;

	if (pthread_create(
		&t1,
		(pthread_attr_t *)NULL,
		(void * (*)(void *))producer,
		(void *)&n)
	) {
		perror("pthread_create");
		exit(1);
	}
	if (pthread_create(
		&t2,
		(pthread_attr_t *)NULL,
		(void * (*)(void *))consumer,
		(void *)&n)
	) {
		perror("pthread_create");
		exit(1);
	}

	pthread_join(t1, NULL);
	pthread_join(t2, NULL);
	fprintf(stdout, "%d %d\n", produced, consumed);
	return 0;
}


void producer(unsigned int *arg) {
	unsigned int i, n = *arg;
	for (i=1; i<=n; i++) {
		data = i;
		count = 1;
		printf("Se produjo %u\n", data);
		produced++;
	}
}


void consumer(unsigned int *arg) {
	unsigned int i = 0, n = *arg;
	for (;;) {
		i = data;
		count = 0;
		printf("Se consumi %u\n", data);
		consumed++;
		if (i == n)
			return;
	}
}
