#include "dict.h"
#include <stdio.h>

int hash(char *s, int n) {
    int h = 0;
    
    while(*s) 
	h += *s++;

    return h%n;
}

DICT *init_dict(int n) {
    DICT *p;
    int i;

    p = (DICT *)malloc(sizeof(DICT)+(n*sizeof(struct nodo *)));
    p->n = n;
    for(i = 0; i < n; i++) p->table[i] = NULL;
    return p;
}

void add_dict(DICT *dict, char *llave, void *val) {
    int i = hash(llave, dict->n);
    struct nodo *p;

    p = dict->table[i];
    while(p != NULL) {
	if(strcmp(p->llave, llave) == 0) {
	    p->val = val;
	    return;
	}
	p = p->next;
    }

    p = (struct nodo *)malloc(sizeof(struct nodo));
    p->llave = llave; p->val = val;
    p->next = dict->table[i];
    dict->table[i] = p;
}

void *search_dict(DICT *dict, char *llave) {
    int i = hash(llave, dict->n);
    struct nodo *p;

    p = dict->table[i];
    while(p != NULL) {
	if(strcmp(p->llave, llave) == 0)
	    return p->val;
	p = p->next;
    }

    return NULL;
}

void free_list(struct nodo *l) {
    if(l == NULL) return;
    free_list(l->next);
    free(l);
}

void free_dict(DICT *dict) {
    int i;

    for(i=0; i<dict->n; i++)
	free_list(dict->table[i]);

    free(dict);
}


void map_list(struct nodo *l, void (*f)(char *, void *)) {
    if(l == NULL) return;
    f(l->llave, l->val);
    map_list(l->next, f);
}

void map_dict(DICT *dict, void (*f)(char *, void *)) {
    int i;

    for(i=0; i<dict->n; i++)
	map_list(dict->table[i], f);
}
