#include "strtokens.h"
#include <stdio.h>

#define TRUE 1
#define FALSE 0

#define min(a, b) (((a) < (b)) ? (a) : (b))

/* Funciones auxiliares
 * findsep(s, seps): ve si s apunta a un char separador o no
 * findop(s, ops): ve si s apunta un string operador, retorna su largo
 */

int findsep(char *s, char *seps) {
    while(*seps)
	if(*s == *seps++) return TRUE;

    return FALSE;
}

int findop(char *s, char **ops) {
    int i = 0;

    while(ops[i] != NULL) {
	if(strncmp(s, ops[i], strlen(ops[i])) == 0)
	    return strlen(ops[i]);
	i++;
    }

    return 0;
}

int strtokens(char *s, char *seps, char *sops, char **ops, int *tok_ops, char **toks, int maxtoks, int maxstr) {
    int ntoks = 0;
    int i;
    char *p;
    enum {NORMAL, TOKEN} estado = NORMAL;

    while(*s != '\0' && ntoks < maxtoks) {
	if(estado == NORMAL) {
	    /* Saltarse los separadores */
	    if( findsep(s, seps) ) s++;
	    /* Veamos si es un operador */
	    else if( findsep(s, sops) ) {
		tok_ops[ntoks] = TRUE;
		toks[ntoks][0] = *s++;
		toks[ntoks++][1] = '\0';
	    }
	    else {
		/* Estoy al comienzo de un token */
		estado = TOKEN;
	 	p = s++; 
	    }
	}
	else { /* TOKEN */
	    /* Si viene un separador debo volver a normal */
	    if( findsep(s, seps) || findsep(s, sops) ) {
		strncpy(toks[ntoks], p, min(maxstr, s-p));
		toks[ntoks][min(maxstr, s-p)] = '\0';

	        if( findop(toks[ntoks], ops) )
		    tok_ops[ntoks] = TRUE;
		else
		    tok_ops[ntoks] = FALSE;

		ntoks++;
		estado = NORMAL;
	    }
	    else s++;
	}
    }

    if( estado == TOKEN ) {
	strncpy(toks[ntoks], p, min(maxstr, s-p));
	toks[ntoks][min(maxstr, s-p)] = '\0';

	if( findop(toks[ntoks], ops) )
  	    tok_ops[ntoks] = TRUE;
	else
	    tok_ops[ntoks] = FALSE;

	ntoks++;
    }

    return ntoks;
}
