/*
Probador Diccionario Tarea 2
por Luis Len Crdenas Graide

Compilacin:
% make

Ejecucin:
./matadict

Recompilacin (en caso de que lo anterior no funcione despus de editar los .c):
% make cleanall all

Activar modo de depuracin:
% make debug

Por favor, reportar por las news los errores que detecten en el probador.

OJO: El que este probador no detecte fallas no implica que la tarea est buena,
sino que simplemente dicha falla no fue detectada.

*/

#include <strings.h>
#include <string.h>
#include <math.h>
#include <float.h>
#include <time.h>
#include <stdlib.h>
#define _GNU_SOURCE
#include <stdio.h>

#include "dict.h"

#ifdef __DEBUGGING__
#define DEBUG(bloque) {bloque;}
#else
#define DEBUG(bloque) ;
#endif

typedef int bool;

#define FALSE ((bool)0)
#define TRUE ((bool)!FALSE)

bool test_recuperacion(void);
bool test_sobreescritura(void);
bool test_map(void);/* Prueba mala: la estoy reimplementando */
bool test_varios_dict(void);
bool test_copia_llave(void);
bool test_memory_leak(void);

void modo_uso(const char *ejecutable);
void realizar_test(size_t nTest);

double random_double();

char xor(const char *string);
void mapeada(char *llave, void *valor);

const struct {
	bool (*funcion)(void);
	char *descripcion;
} tests[] = {
	{test_recuperacion, "Recuperacin de valores"},
	{test_sobreescritura, "Sobreescritura de valores antiguos"},
	{test_map, "Mapeo de funciones"},
	{test_varios_dict, "Aislamiento entre varias instancias de diccionarios"},
	{test_copia_llave, "Manejo interno de las llaves"},
	{test_memory_leak, "Liberar completamente la memoria"}
};

const size_t TOTAL_TESTS = sizeof(tests) / sizeof(*tests);

int main(int argc, const char *argv[]) {
	if (argc <= 1) {
		modo_uso(*argv);
		return EXIT_FAILURE;
	} else {
		size_t nArg;
		setvbuf(stdout, NULL, _IONBF, 0);
		srand(time(0));
		for (nArg = 1; nArg < argc; ++nArg) {
			int nTest = atoi(argv[nArg]);
			if (nTest < 0 || TOTAL_TESTS < nTest) {
				printf("Id de Test invlido: %i\n", nTest);
			} else {
				if (nTest == 0) {
					printf("Realizando todos los tests...\n");
					while (nTest++ < TOTAL_TESTS) {
						realizar_test((size_t)nTest);
					}
					printf("Batera de tests finalizada.\n");
				} else {
					realizar_test((size_t)nTest);
				}
			}
		}
	}

	return EXIT_SUCCESS;
}

void realizar_test(size_t nTest) {
	printf("Realizando test #%u: %s...\n", nTest, tests[nTest - 1].descripcion);
	printf(tests[nTest - 1].funcion() ? "Test #%u completado con xito.\n" : "Test #%u completado con errores.\n", nTest);
}

void modo_uso(const char *ejecutable) {
	size_t nTest;
	printf("Modo de uso: %s lista_id_tests\n", ejecutable);
	printf("IDs de los tests:\n");
	printf("0: Todos los tests.\n");
	for (nTest = 0; nTest < TOTAL_TESTS; ++nTest) {
		printf("%u: %s.\n", nTest + 1, tests[nTest].descripcion);
	}
	printf("\nEjemplo: %s 2 3 realiza las pruebas 2 y 3.\n", ejecutable);
}

double random_double() {
	int n = 0;
	double d = rand();
	while (n == 0) {
		n = rand();
	}
	return d / n;
}

bool test_recuperacion(void) {
	static const size_t numero_ejemplos = 100000;

	size_t n; bool ok = TRUE;
	double *ejemplos, *respaldo_ejemplos;
	char **llaves;

	DEBUG(printf(" Generando datos de prueba...\n"))

	ejemplos = malloc(numero_ejemplos * sizeof(*ejemplos));
	for (n = 0; n < numero_ejemplos; ++n) {
		ejemplos[n] = 2.5 * n;
		DEBUG(printf("  Valor generado: %f\n", ejemplos[n]))
	}

	respaldo_ejemplos = malloc(numero_ejemplos * sizeof(*ejemplos));
	memcpy(respaldo_ejemplos, ejemplos, numero_ejemplos * sizeof(*ejemplos));

	llaves = malloc(numero_ejemplos * sizeof(*llaves));
	for (n = 0; n < numero_ejemplos; ++n) {
		char *llave;
		asprintf(&llave, "%f", ejemplos[n]);
		llaves[n] = llave;
	}

	for (n = numero_ejemplos / 2; n <= 4 * numero_ejemplos; n *= 2) {
		size_t nEjemplo;
		DICT *dict;

		DEBUG(printf(" Probando diccionario de tamao %u...\n", n))

		dict = init_dict(n);

		for (nEjemplo = 0; nEjemplo < numero_ejemplos; ++nEjemplo) {
			DEBUG(printf("  Agregando llave=valor \"%s\"=%f...\n", llaves[nEjemplo], ejemplos[nEjemplo]))
			add_dict(dict, llaves[nEjemplo], ejemplos + nEjemplo);
		}

		for (nEjemplo = 0; nEjemplo < numero_ejemplos; ++nEjemplo) {
			double *presunto_valor;
			DEBUG(printf("  Buscando llave \"%s\"...\n", llaves[nEjemplo]))
			presunto_valor = search_dict(dict, llaves[nEjemplo]);
			if (presunto_valor == NULL) {
				printf("ERROR: No se pudo recuperar el valor asociado a la llave \"%s\".\n", llaves[nEjemplo]);
				ok = FALSE;
			} else if (presunto_valor != ejemplos + nEjemplo) {
				printf("ERROR: Para la llave \"%s\" se asoci el puntero %p, pero se recuper %p.\n", llaves[nEjemplo], (void *)(ejemplos + nEjemplo), (void *)presunto_valor);
				ok = FALSE;
			} else if (*presunto_valor != respaldo_ejemplos[nEjemplo]) {
				printf("ERROR: Para la llave \"%s\" se asoci un puntero a %f, pero ahora lo apuntado vale %f.\n", llaves[nEjemplo], respaldo_ejemplos[nEjemplo], *presunto_valor);
				ok = FALSE;
			}
		}

		DEBUG(printf(" Liberando diccionario de tamao %u.\n", n))

		free_dict(dict);
	}

	for (n = 0; n < numero_ejemplos; ++n) {
		free(llaves[n]);
	}
	free(llaves);
	free(ejemplos);
	free(respaldo_ejemplos);

	return ok;
}

bool test_sobreescritura(void) {
	static const size_t numero_ejemplos = 100000;

	size_t n; bool ok = TRUE;
	double *ejemplos, *otros_ejemplos;
	char **llaves;

	DEBUG(printf(" Generando datos de prueba...\n"))

	ejemplos = malloc(numero_ejemplos * sizeof(*ejemplos));
	otros_ejemplos = malloc(numero_ejemplos * sizeof(*otros_ejemplos));
	for (n = 0; n < numero_ejemplos; ++n) {
		ejemplos[n] = 1.0 + 2.5 * n;
		otros_ejemplos[n] = 0.5 * n;
		DEBUG(printf("  Valores generados: %f, %f\n", ejemplos[n], otros_ejemplos[n]))
	}

	llaves = malloc(numero_ejemplos * sizeof(*llaves));
	for (n = 0; n < numero_ejemplos; ++n) {
		char *llave;
		asprintf(&llave, "%u", n);
		llaves[n] = llave;
	}

	for (n = numero_ejemplos / 2; n <= 4 * numero_ejemplos; n *= 2) {
		size_t nEjemplo;
		DICT *dict;

		DEBUG(printf(" Probando diccionario de tamao %u...\n", n))

		dict = init_dict(n);

		for (nEjemplo = 0; nEjemplo < numero_ejemplos; ++nEjemplo) {
			DEBUG(printf("  Agregando llave=valor \"%s\"=%f...\n", llaves[nEjemplo], ejemplos[nEjemplo]))
			add_dict(dict, llaves[nEjemplo], ejemplos + nEjemplo);
		}
		for (nEjemplo = 0; nEjemplo < numero_ejemplos; ++nEjemplo) {
			DEBUG(printf("  Re-agregando llave=valor \"%s\"=%f...\n", llaves[nEjemplo], otros_ejemplos[nEjemplo]))
			add_dict(dict, llaves[nEjemplo], otros_ejemplos + nEjemplo);
		}

		for (nEjemplo = 0; nEjemplo < numero_ejemplos; ++nEjemplo) {
			double *presunto_valor;
			DEBUG(printf("  Buscando llave \"%s\"...\n", llaves[nEjemplo]))
			presunto_valor = search_dict(dict, llaves[nEjemplo]);
			if (presunto_valor == NULL) {
				printf("ERROR: No se pudo recuperar el valor asociado a la llave \"%s\".\n", llaves[nEjemplo]);
				ok = FALSE;
			} else if (presunto_valor == ejemplos + nEjemplo) {
				printf("ERROR: Para llave=\"%s\" no se sobreescribi el puntero antiguo %p por el puntero nuevo %p.\n", llaves[nEjemplo], (void *)(ejemplos + nEjemplo), (void *)(otros_ejemplos + nEjemplo));
				ok = FALSE;
			} else if (presunto_valor != otros_ejemplos + nEjemplo) {
				printf("ERROR: Para la llave \"%s\" se re-asoci el puntero %p, pero se recuper %p.\n", llaves[nEjemplo], (void *)(otros_ejemplos + nEjemplo), (void *)presunto_valor);
				ok = FALSE;
			}
		}

		DEBUG(printf(" Liberando diccionario de tamao %u.\n", n))

		free_dict(dict);
	}

	for (n = 0; n < numero_ejemplos; ++n) {
		free(llaves[n]);
	}
	free(llaves);
	free(ejemplos);
	free(otros_ejemplos);

	return ok;
}

char xor(const char *string) {
	char c = '\0';
	while (*string) {
		c ^= *string;
		++string;
	}
	return c;
}

void mapeada(char *llave, void *valor) {
	char *val = (char *)valor;
	char c = xor(llave);
	while (*val) {
		*val ^= c;
		++val;
	}
}

bool test_map(void) {
	static const size_t numero_ejemplos = 100000;

	size_t n; bool ok = TRUE;
	char **ejemplos, **copia_ejemplos, **llaves;

	DEBUG(printf(" Generando datos de prueba...\n"))

	llaves = malloc(numero_ejemplos * sizeof(*llaves));
	ejemplos = malloc(numero_ejemplos * sizeof(*ejemplos));
	copia_ejemplos = malloc(numero_ejemplos * sizeof(*copia_ejemplos));
	for (n = 0; n < numero_ejemplos; ++n) {
		size_t m = ~n;
		asprintf(llaves + n, "%u", n);
		asprintf(ejemplos + n, "%u", m);
		asprintf(copia_ejemplos + n, "%u", m);
		DEBUG(printf("  llave=valor: \"%s\"=%s\n", llaves[n], ejemplos[n]))
	}

	for (n = numero_ejemplos / 2; n <= 4 * numero_ejemplos; n *= 2) {
		size_t nEjemplo;
		DICT *dict;

		DEBUG(printf(" Probando diccionario de tamao %u...\n", n))

		dict = init_dict(n);

		for (nEjemplo = 0; nEjemplo < numero_ejemplos; ++nEjemplo) {
			DEBUG(printf("  Agregando llave=valor \"%s\"=\"%s\"...\n", llaves[nEjemplo], ejemplos[nEjemplo]))
			add_dict(dict, llaves[nEjemplo], ejemplos[nEjemplo]);
		}

  	map_dict(dict, mapeada);
  	map_dict(dict, mapeada);

		for (nEjemplo = 0; nEjemplo < numero_ejemplos; ++nEjemplo) {
			char *presunto_valor;
			DEBUG(printf("  Buscando llave \"%s\"...\n", llaves[nEjemplo]))
			presunto_valor = search_dict(dict, llaves[nEjemplo]);
			if (presunto_valor == NULL) {
				printf("ERROR: No se pudo recuperar el valor asociado a la llave \"%s\".\n", llaves[nEjemplo]);
				ok = FALSE;
			} else if (strcmp(presunto_valor, copia_ejemplos[nEjemplo])) {
				printf("ERROR: Para la llave \"%s\" se asoci el string \"%s\", pero se recuper \"%s\".\n", llaves[nEjemplo], copia_ejemplos[nEjemplo], presunto_valor);
				ok = FALSE;
			}
		}

		DEBUG(printf(" Liberando diccionario de tamao %u.\n", n))

		free_dict(dict);
	}

	for (n = 0; n < numero_ejemplos; ++n) {
		free(llaves[n]);
		free(ejemplos[n]);
		free(copia_ejemplos[n]);
	}
	free(llaves);
	free(ejemplos);
	free(copia_ejemplos);

	return ok;
}

bool test_varios_dict(void) {
	static const size_t numero_ejemplos = 100000;
	static const size_t tamano_base = 50;
	size_t n; bool ok = TRUE;
	char **llaves;
	double *valores;

	DEBUG(printf(" Generando valores de prueba...\n"))
	llaves = malloc(numero_ejemplos * sizeof(*llaves));
	valores = malloc(numero_ejemplos * sizeof(*valores));
	for (n = 0; n < numero_ejemplos; ++n) {
		valores[n] = random_double();
		asprintf(llaves + n, "%f", valores[n]);
		DEBUG(printf("  llave=valor: \"%s\"=%p\n", llaves[n], (void *)(valores + n)))
	}

	for (n = tamano_base; n < 8 * tamano_base; n *= 2) {
		size_t m;
		size_t tamano_dicts[3]; DICT *dicts[3];
		tamano_dicts[0] = n / 2;
		tamano_dicts[1] = n;
		tamano_dicts[2] = n * 2;

		DEBUG(printf(" Creando diccionarios de tamao %u, %u y %u...\n", tamano_dicts[0], tamano_dicts[1], tamano_dicts[2]))

		dicts[0] = init_dict(tamano_dicts[0]);
		dicts[1] = init_dict(tamano_dicts[1]);
		dicts[2] = init_dict(tamano_dicts[2]);

		DEBUG(printf("  Agregando valores...\n"))
		for (m = 0; m < numero_ejemplos; ++m) {
			add_dict(dicts[0], llaves[m], valores + m);
			add_dict(dicts[1], llaves[m], valores + m);
			add_dict(dicts[2], llaves[m], valores + m);
		}

		DEBUG(printf("  Recuperando valores...\n"))
		for (m = 0; m < numero_ejemplos; ++m) {
			size_t d;
			for (d = 0; d < sizeof(dicts) / sizeof(*dicts); ++d) {
				double *presunto_valor = search_dict(dicts[d], llaves[m]);
				if (presunto_valor != valores + m) {
					printf("ERROR: Se recuper %p en vez del valor esperado %p para la llave \"%s\"\n", (void *)presunto_valor, (void *)(valores + m), llaves[m]);
					ok = FALSE;
				}
			}
		}

		DEBUG(printf(" Liberando diccionarios...\n"))

		free_dict(dicts[0]);
		free_dict(dicts[1]);
		free_dict(dicts[2]);
	}

	free(llaves);
	free(valores);

	return ok;
}

bool test_copia_llave(void) {
	static const size_t numero_ejemplos = 100000;
	static const size_t tamano_base = 50;
	size_t n; bool ok = TRUE;
	char **llaves1, **llaves2;

	DEBUG(printf(" Generando datos de prueba...\n"))
	llaves1 = malloc(numero_ejemplos * sizeof(*llaves1));
	llaves2 = malloc(numero_ejemplos * sizeof(*llaves2));
	for (n = 0; n < numero_ejemplos; ++n) {
		asprintf(llaves1 + n, "%u", n);
		asprintf(llaves2 + n, "%u", n);
	}

	for (n = tamano_base; n <= 4 * tamano_base; n *= 2) {
		size_t m; DICT *dict;

		DEBUG(printf(" Probando diccionario de tamao %u...\n", n))
		dict = init_dict(n);

		for (m = 0; m < numero_ejemplos; ++m) {
			DEBUG(printf("  llave=valor: \"%s\"=%p\n", llaves1[m], (void *)(llaves2 + m)))
			add_dict(dict, llaves1[m], llaves2 + m);
		}

		for (m = 0; m < numero_ejemplos; ++m) {
			char **presunto_valor = search_dict(dict, llaves2[m]);
			if (presunto_valor != llaves2 + m) {
				printf("ERROR: A la llave \"%s\" se le asoci el valor %p, pero se recuper %p.\n", llaves2[m], (void *)(llaves2 + m), (void *)presunto_valor);
				ok = FALSE;
			}
		}

		DEBUG(printf(" Liberando diccionario de tamao %u...\n", n))
		free_dict(dict);
	}

	free(llaves1);
	free(llaves2);
	return ok;
}

bool test_memory_leak(void) {
	static const size_t numero_ejemplos = 100000;
	static const size_t tamano_base = 50;
	size_t nPrueba; char **llaves; size_t n;
	printf(
		" Este test dura muuucho.\n"
		" El proceso deber usar cada vez ms memoria hasta llegar a un punto estable.\n"
		" Si el proceso sigue consumiendo cada vez ms memoria, sin parar, evidenciar una fuga de memoria en el manejo interno del diccionario.\n"
	);

	DEBUG(printf(" Generando datos de prueba...\n"));
	llaves = malloc(numero_ejemplos * sizeof(*llaves));
	for (n = 0; n < numero_ejemplos; ++n) {
		asprintf(llaves + n, "%u", n);
	}

	for (nPrueba = 1; nPrueba != 0; ++nPrueba) {
		DEBUG(printf(" Prueba #%u...\n", nPrueba))
		for (n = tamano_base; n <= 8 * tamano_base; n *= 2) {
			size_t m;
			DICT *dict;

			DEBUG(printf("  Creando diccionario de tamao %u...\n", n))
			dict = init_dict(n);

			for (m = 0; m < numero_ejemplos; ++m) {
				DEBUG(printf("   llave=valor: \"%s\"=%s\n", llaves[m], llaves[m]))
				add_dict(dict, llaves[m], llaves[m]);
			}

			DEBUG(printf("  Liberando diccionario de tamao %u...\n", n))
			free_dict(dict);
		}
	}

	free(llaves);

	return TRUE;
}
