/*
Probador Diccionario Tarea 2
por Luis Len Crdenas Graide

Compilacin:
% make

Ejecucin:
./matadict

Recompilacin (en caso de que lo anterior no funcione despus de editar los .c):
% make cleanall all

Activar modo de depuracin:
% make debug

Por favor, reportar por las news los errores que detecten en el probador.

OJO: El que este probador no detecte fallas no implica que la tarea est buena,
sino que simplemente dicha falla no fue detectada.

*/

#include <string.h>
#include <math.h>
#include <float.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>

#include "dict.h"

#ifdef __DEBUGGING__
#define DEBUG(bloque) {bloque;}
#else
#define DEBUG(bloque) ;
#endif

typedef int bool;

#define FALSE ((bool)0)
#define TRUE ((bool)!FALSE)

bool test_recuperacion(void);
bool test_sobreescritura(void);
bool test_map(void);
bool test_varios_dict(void);
bool test_copia_llave(void);
bool test_memory_leak(void);

void modo_uso(const char *ejecutable);
void realizar_test(size_t nTest);

double random_double();

char xor(const char *string);
void mapeada(char *llave, void *valor);

const struct {
	bool (*funcion)(void);
	char *descripcion;
} tests[] = {
	/* Implementados */
	{test_recuperacion, "Recuperacin de valores"},
	{test_sobreescritura, "Sobreescritura de valores antiguos"},
	{test_map, "Mapeo de funciones"},
	/* No implementados */
	{test_varios_dict, "Aislamiento entre varias instancias de diccionarios"},
	{test_copia_llave, "Manejo interno de las llaves"},
	{test_memory_leak, "Liberar completamente la memoria"}
};

const size_t TOTAL_TESTS = sizeof(tests) / sizeof(*tests);

int main(int argc, const char *argv[]) {
	if (argc <= 1) {
		modo_uso(*argv);
		return EXIT_FAILURE;
	} else {
		size_t nArg;
		setvbuf(stdout, NULL, _IONBF, 0);
		srand(time(0));
		for (nArg = 1; nArg < argc; ++nArg) {
			int nTest = atoi(argv[nArg]);
			if (nTest < 0 || TOTAL_TESTS < nTest) {
				printf("Id de Test invlido: %i\n", nTest);
			} else {
				if (nTest == 0) {
					printf("Realizando todos los tests...\n");
					while (nTest++ < TOTAL_TESTS) {
						realizar_test((size_t)nTest);
					}
					printf("Batera de tests finalizada.\n");
				} else {
					realizar_test((size_t)nTest);
				}
			}
		}
	}

	return EXIT_SUCCESS;
}

void realizar_test(size_t nTest) {
	printf("Realizando test #%u: %s...\n", nTest, tests[nTest - 1].descripcion);
	printf(tests[nTest - 1].funcion() ? "Test #%u completado con xito.\n" : "Test #%u completado con errores.\n", nTest);
}

void modo_uso(const char *ejecutable) {
	size_t nTest;
	printf("Modo de uso: %s lista_id_tests\n", ejecutable);
	printf("IDs de los tests:\n");
	printf("0: Todos los tests.\n");
	for (nTest = 0; nTest < TOTAL_TESTS; ++nTest) {
		printf("%u: %s.\n", nTest + 1, tests[nTest].descripcion);
	}
	printf("\nEjemplo: %s 2 3 realiza las pruebas 2 y 3.\n", ejecutable);
}

double random_double() {
	int n = 0;
	double d = rand();
	while (n == 0) {
		n = rand();
	}
	return d / n;
}

bool test_recuperacion(void) {
	static const size_t numero_ejemplos = 100000;

	size_t n; bool ok = TRUE;
	double *ejemplos, *respaldo_ejemplos;
	char **llaves;

	DEBUG(printf(" Generando datos de prueba...\n"))

	ejemplos = malloc(numero_ejemplos * sizeof(*ejemplos));
	for (n = 0; n < numero_ejemplos; ++n) {
		ejemplos[n] = 2.5 * n;
		DEBUG(printf("  Valor generado: %f\n", ejemplos[n]))
	}

	respaldo_ejemplos = malloc(numero_ejemplos * sizeof(*ejemplos));
	memcpy(respaldo_ejemplos, ejemplos, numero_ejemplos * sizeof(*ejemplos));

	llaves = malloc(numero_ejemplos * sizeof(*llaves));
	for (n = 0; n < numero_ejemplos; ++n) {
		char *llave;
		asprintf(&llave, "%f", ejemplos[n]);
		llaves[n] = llave;
	}

	for (n = numero_ejemplos / 2; n <= 4 * numero_ejemplos; n *= 2) {
		size_t nEjemplo;
		DICT *dict;

		DEBUG(printf(" Probando diccionario de tamao %u...\n", n))

		dict = init_dict(n);

		for (nEjemplo = 0; nEjemplo < numero_ejemplos; ++nEjemplo) {
			DEBUG(printf("  Agregando llave=valor \"%s\"=%f...\n", llaves[nEjemplo], ejemplos[nEjemplo]))
			add_dict(dict, llaves[nEjemplo], ejemplos + nEjemplo);
		}

		for (nEjemplo = 0; nEjemplo < numero_ejemplos; ++nEjemplo) {
			double *presunto_valor;
			DEBUG(printf("  Buscando llave \"%s\"...\n", llaves[nEjemplo]))
			presunto_valor = search_dict(dict, llaves[nEjemplo]);
			if (presunto_valor == NULL) {
				printf("ERROR: No se pudo recuperar el valor asociado a la llave \"%s\".\n", llaves[nEjemplo]);
				ok = FALSE;
			} else if (presunto_valor != ejemplos + nEjemplo) {
				printf("ERROR: Para la llave \"%s\" se asoci el puntero %p, pero se recuper %p.\n", llaves[nEjemplo], (void *)(ejemplos + nEjemplo), (void *)presunto_valor);
				ok = FALSE;
			} else if (*presunto_valor != respaldo_ejemplos[nEjemplo]) {
				printf("ERROR: Para la llave \"%s\" se asoci un puntero a %f, pero ahora lo apuntado vale %f.\n", llaves[nEjemplo], respaldo_ejemplos[nEjemplo], *presunto_valor);
				ok = FALSE;
			}
		}

		DEBUG(printf(" Liberando diccionario de tamao %u.\n", n))

		free_dict(dict);
	}

	for (n = 0; n < numero_ejemplos; ++n) {
		free(llaves[n]);
	}
	free(llaves);
	free(ejemplos);
	free(respaldo_ejemplos);

	return ok;
}

bool test_sobreescritura(void) {
	static const size_t numero_ejemplos = 100000;

	size_t n; bool ok = TRUE;
	double *ejemplos, *otros_ejemplos;
	char **llaves;

	DEBUG(printf(" Generando datos de prueba...\n"))

	ejemplos = malloc(numero_ejemplos * sizeof(*ejemplos));
	otros_ejemplos = malloc(numero_ejemplos * sizeof(*otros_ejemplos));
	for (n = 0; n < numero_ejemplos; ++n) {
		ejemplos[n] = 1.0 + 2.5 * n;
		otros_ejemplos[n] = 0.5 * n;
		DEBUG(printf("  Valores generados: %f, %f\n", ejemplos[n], otros_ejemplos[n]))
	}

	llaves = malloc(numero_ejemplos * sizeof(*llaves));
	for (n = 0; n < numero_ejemplos; ++n) {
		char *llave;
		asprintf(&llave, "%u", n);
		llaves[n] = llave;
	}

	for (n = numero_ejemplos / 2; n <= 4 * numero_ejemplos; n *= 2) {
		size_t nEjemplo;
		DICT *dict;

		DEBUG(printf(" Probando diccionario de tamao %u...\n", n))

		dict = init_dict(n);

		for (nEjemplo = 0; nEjemplo < numero_ejemplos; ++nEjemplo) {
			DEBUG(printf("  Agregando llave=valor \"%s\"=%f...\n", llaves[nEjemplo], ejemplos[nEjemplo]))
			add_dict(dict, llaves[nEjemplo], ejemplos + nEjemplo);
		}
		for (nEjemplo = 0; nEjemplo < numero_ejemplos; ++nEjemplo) {
			DEBUG(printf("  Re-agregando llave=valor \"%s\"=%f...\n", llaves[nEjemplo], otros_ejemplos[nEjemplo]))
			add_dict(dict, llaves[nEjemplo], otros_ejemplos + nEjemplo);
		}

		for (nEjemplo = 0; nEjemplo < numero_ejemplos; ++nEjemplo) {
			double *presunto_valor;
			DEBUG(printf("  Buscando llave \"%s\"...\n", llaves[nEjemplo]))
			presunto_valor = search_dict(dict, llaves[nEjemplo]);
			if (presunto_valor == NULL) {
				printf("ERROR: No se pudo recuperar el valor asociado a la llave \"%s\".\n", llaves[nEjemplo]);
				ok = FALSE;
			} else if (presunto_valor == ejemplos + nEjemplo) {
				printf("ERROR: Para llave=\"%s\" no se sobreescribi el puntero antiguo %p por el puntero nuevo %p.\n", llaves[nEjemplo], (void *)(ejemplos + nEjemplo), (void *)(otros_ejemplos + nEjemplo));
				ok = FALSE;
			} else if (presunto_valor != otros_ejemplos + nEjemplo) {
				printf("ERROR: Para la llave \"%s\" se re-asoci el puntero %p, pero se recuper %p.\n", llaves[nEjemplo], (void *)(otros_ejemplos + nEjemplo), (void *)presunto_valor);
				ok = FALSE;
			}
		}

		DEBUG(printf(" Liberando diccionario de tamao %u.\n", n))

		free_dict(dict);
	}

	for (n = 0; n < numero_ejemplos; ++n) {
		free(llaves[n]);
	}
	free(llaves);
	free(ejemplos);
	free(otros_ejemplos);

	return ok;
}

char xor(const char *string) {
	char c = '\0';
	while (*string) {
		c ^= *string;
		++string;
	}
	return c;
}

void mapeada(char *llave, void *valor) {
	char *val = (char *)valor;
	char c = xor(llave);
	while (*val) {
		*val ^= c;
		++val;
	}
}

bool test_map(void) {
	static const size_t numero_ejemplos = 100000;

	size_t n; bool ok = TRUE;
	char **ejemplos, **copia_ejemplos, **llaves;

	DEBUG(printf(" Generando datos de prueba...\n"))

	llaves = malloc(numero_ejemplos * sizeof(*llaves));
	ejemplos = malloc(numero_ejemplos * sizeof(*ejemplos));
	copia_ejemplos = malloc(numero_ejemplos * sizeof(*copia_ejemplos));
	for (n = 0; n < numero_ejemplos; ++n) {
		size_t m = ~n;
		asprintf(llaves + n, "%u", n);
		asprintf(ejemplos + n, "%u", m);
		asprintf(copia_ejemplos + n, "%u", m);
		DEBUG(printf("  llave=valor: %s=%s\n", llaves[n], ejemplos[n]))
	}

	for (n = numero_ejemplos / 2; n <= 4 * numero_ejemplos; n *= 2) {
		size_t nEjemplo;
		DICT *dict;

		DEBUG(printf(" Probando diccionario de tamao %u...\n", n))

		dict = init_dict(n);

		for (nEjemplo = 0; nEjemplo < numero_ejemplos; ++nEjemplo) {
			DEBUG(printf("  Agregando llave=valor \"%s\"=\"%s\"...\n", llaves[nEjemplo], ejemplos[nEjemplo]))
			add_dict(dict, llaves[nEjemplo], ejemplos[nEjemplo]);
		}

  	map_dict(dict, mapeada);
  	map_dict(dict, mapeada);

		for (nEjemplo = 0; nEjemplo < numero_ejemplos; ++nEjemplo) {
			char *presunto_valor;
			DEBUG(printf("  Buscando llave \"%s\"...\n", llaves[nEjemplo]))
			presunto_valor = search_dict(dict, llaves[nEjemplo]);
			if (presunto_valor == NULL) {
				printf("ERROR: No se pudo recuperar el valor asociado a la llave \"%s\".\n", llaves[nEjemplo]);
				ok = FALSE;
			} else if (strcmp(presunto_valor, copia_ejemplos[nEjemplo])) {
				printf("ERROR: Para la llave \"%s\" se asoci el string \"%s\", pero se recuper \"%s\".\n", llaves[nEjemplo], copia_ejemplos[nEjemplo], presunto_valor);
				ok = FALSE;
			}
		}

		DEBUG(printf(" Liberando diccionario de tamao %u.\n", n))

		free_dict(dict);
	}

	for (n = 0; n < numero_ejemplos; ++n) {
		free(llaves[n]);
		free(ejemplos[n]);
		free(copia_ejemplos[n]);
	}
	free(llaves);
	free(ejemplos);
	free(copia_ejemplos);

	return ok;
}

bool test_varios_dict(void) {
	return FALSE;
}

bool test_copia_llave(void) {
	return FALSE;
}

bool test_memory_leak(void) {
	return FALSE;
}
