/* CC31A 2005 C1 P2 */

unsigned long setparity(unsigned long val) {

	/* Recuerda la paridad segn la cantidad de bits en 1 */
	unsigned long paridad = 0x1;/* Inicialmente, 0 bits en 1 => paridad 1 */

	/* Hay que olvidar del bit de mayor orden de val, sin olvidar todo val */
	unsigned long temp = val = (val << 1) >> 1;

	while (temp) {/* Mientras haya 1s que contar */
		/* Si hay un 1 en el bit de menor orden, se cambia la paridad */
		paridad ^= temp & 0x1; /* temp % 2 */
		/* Recuerdo: b ^ 0 == b && b ^ 1 == ~b && b ^ b == 0 && (b ^ v) ^ v == b */

		/* Se avanza a los siguientes bits de mayor orden */
		temp >>= 1; /* temp /= 2 */
	}

	/* Enciende la paridad adecuada a val. Se calcula el nmero de bits del tipo
	como 8 * sizeof(tipo), pero se resta 1 para que la paridad quede en el ltimo
	bit (ms significativo). Si no se resta 1, "se pasa" y deja todo en 0. */
	return val | (paridad << (8 * sizeof(val) - 1));
}
/* Las dos gracias de esta solucin son que usa sizeof en una sola parte (el
resto no depende de cuntos bits tenga unsigned int) y que slo hace >> o <<
con constantes, lo que es potencialmente ms eficiente */

/* Soluciones alternativas:
- Usar un for para llevar la cuenta de los bits visitados con el iterador entre
0 y 8 * sizeof(unsigned long) (- 1?) en vez de hacer >> in situ.
- Usar / y % en vez de >> y &.
- Llevar la cuenta de los bits en 1 para determinar la paridad al final en vez
de llevar la paridad "al vuelo" (con paridad ^= ...).
- Ir construyendo el resultado bit por bit en vez de aplicar directamente la
paridad al bit de mayor orden.
- En vez de botar el bit de mayor orden al comienzo, simplemente se puede
ignorar, teniendo cuidado de tratar con l adecuadamente al final (dependiendo
de si vala 1  0).

Puntuacin:
- Independencia del nmero de bits tanto al calcular la paridad [0.5 puntos]
como al setearla [0.5 puntos].
- Calcular correctamente la paridad segn el nmero de 1s (par => 1, impar =>
0) [1.0 puntos]
- [0.5 puntos] Ignorar el bit de mayor orden.
- [1.5 puntos] Retornar juntos el valor original + la paridad en el bit de
mayor orden.
Explicacin de ejemplos [2 puntos, 0.4 c/u de los 5]
*/

/* Para probar la respuesta:

gcc -pedantic -Wall -ansi 2005c1p2.c -o p2
./p2 0 1 2 3 4 5 6 7 8 0xFFFFFFFF 0xFFFFFFFE

*/

#include <stdio.h>
#include <stdlib.h>

int main(int argc, char **argv) {
	while (--argc > 0) {
		unsigned long ul = strtoul(argv[argc], NULL, 0);
		printf("%s: setparity(0x%lX) => 0x%lX\n", argv[argc], ul, setparity(ul));
	}
	return EXIT_SUCCESS;
}
