#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include "input.h"

int readdec() {
	int n = 0;
	int c;
	while (isdigit(c = getchar())) {
		n *= 10;
		n += (c - '0');
	}
	return n;
}

int readbin() {
	int n = 0;
	int c;
	c = getchar();
	while ('0' <= c && c <= '1') {
		n <<= 1; /* *= 2 */
		n |= (c - '0');
		c = getchar();
	}
	return n;
}

int readhex() {
	int n = 0;
	int c;
	c = getchar();
	while (isxdigit(c)) {
		n <<= 4;
		n |= (isdigit(c) ? c - '0' : toupper(c) - 'A' + 10);
		c = getchar();
	}
	return n;
}
