/* 6 mascaras */

#include <stdio.h>
#include <stdlib.h>

/*
& 0 1  | 0 1  ~ 0 1
0 0 0  0 0 1    1 0
1 0 1  1 1 1
*/

const int FONT_NORMAL = 0x0;
const int FONT_BOLD = 0x1;
const int FONT_ITALIC = 0x2;
const int FONT_UNDERLINE = 0x4;

int is_font_normal(int f) {
	return f == FONT_NORMAL;
}

int set_font_attr(int font, int attr) {return font | attr;}
int unset_font_attr(int font, int attr) {return font & ~attr;}
int isset_font_attr(int font, int attr) {return font & attr;}

int main() {
	int font = FONT_NORMAL;
	font = set_font_attr(set_font_attr(font, FONT_BOLD), FONT_UNDERLINE);
	font = set_font_attr(font, FONT_BOLD | FONT_UNDERLINE);
	font |= FONT_BOLD | FONT_UNDERLINE;
	printf("font\t= %X\n\n", font);

	printf("bold\t= %x\n", isset_font_attr(font, FONT_BOLD));
	printf("italic\t= %x\n", isset_font_attr(font, FONT_ITALIC));
	printf("underline\t= %x\n", isset_font_attr(font, FONT_UNDERLINE));

	printf("\n");

	printf("bold\t= %i\n", (isset_font_attr(font, FONT_BOLD) ? 1 : 0));
	printf("italic\t= %i\n", (isset_font_attr(font, FONT_ITALIC) ? 1 : 0));
	printf("underline\t= %i\n", (isset_font_attr(font, FONT_UNDERLINE) ? 1 : 0));

	printf("bold=%i, italic=%i, underline=%i\n",
		(isset_font_attr(font, FONT_BOLD) ? 1 : 0),
		(isset_font_attr(font, FONT_ITALIC) ? 1 : 0),
		(isset_font_attr(font, FONT_UNDERLINE) ? 1 : 0)
	);

	font = unset_font_attr(font, FONT_BOLD);
	font &= ~FONT_BOLD;
	printf("font\t= 0x%X\n", font);

	printf("normal? %i\n", is_font_normal(font));

	return EXIT_SUCCESS;
}
